/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapterFactory;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalJdbcDatabaseAdapterFactory
extends AbstractDatabaseAdapterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExternalJdbcDatabaseAdapterFactory.class);

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public String getDisableReason() {
        Config config = ConfigImpl.getInstance();
        String hostName = config.getPropertyAsNonEmptyTrimmedString("jdbc.hostName", null);
        if (StringUtil.isEmpty((String)hostName)) {
            return String.format("Configuration lacks '%s'!", "jdbc.hostName");
        }
        String driverName = this.getDriverName();
        if (!StringUtil.isEmpty((String)driverName)) {
            try {
                Class.forName(driverName);
            }
            catch (Throwable error) {
                String result = String.format("Loading driver '%s' failed: %s", driverName, error);
                logger.debug(result, error);
                return result;
            }
        }
        String userName = config.getPropertyAsNonEmptyTrimmedString("jdbc.userName", null);
        String password = config.getPropertyAsNonEmptyTrimmedString("jdbc.password", null);
        String url = this.getJdbcSysdbUrl();
        if (!StringUtil.isEmpty((String)url)) {
            try {
                Connection connection = DriverManager.getConnection(url, userName, password);
                connection.close();
            }
            catch (Throwable error) {
                String result = String.format("Connecting to '%s' failed: %s", url, error);
                logger.debug(result, error);
                return result;
            }
        }
        return null;
    }

    protected String getJdbcProtocol() {
        return this.getName();
    }

    public String getJdbcSysdbUrl() {
        Config config = ConfigImpl.getInstance();
        String jdbcProtocol = this.getJdbcProtocol();
        Objects.requireNonNull(jdbcProtocol, "jdbcProtocol");
        String hostName = config.getPropertyAsNonEmptyTrimmedString("jdbc.hostName", null);
        Objects.requireNonNull(hostName, "hostName");
        String url = "jdbc:" + this.getJdbcProtocol() + "://" + hostName + "/";
        String sysdbName = config.getPropertyAsNonEmptyTrimmedString("jdbc.sysdbName", null);
        if (!StringUtil.isEmpty((String)sysdbName)) {
            url = url + sysdbName;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDriverName() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("databaseAdapter.name", Objects.requireNonNull(this.getName(), "name"));
        String resolvedPersistencePropertiesTemplateFileName = IOUtil.replaceTemplateVariables((String)"cloudstore-persistence.${databaseAdapter.name}.properties", variables);
        InputStream in = this.getClass().getResourceAsStream("/" + resolvedPersistencePropertiesTemplateFileName);
        if (in == null) {
            logger.warn("Did not find resource: {}", (Object)resolvedPersistencePropertiesTemplateFileName);
            return null;
        }
        try {
            String driverName;
            Properties p = new Properties();
            p.load(in);
            String string = driverName = p.getProperty(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
            return string;
        }
        catch (Exception x) {
            logger.warn("Reading resource '" + resolvedPersistencePropertiesTemplateFileName + "' failed: " + x, (Throwable)x);
            String string = null;
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.warn("Closing resource '" + resolvedPersistencePropertiesTemplateFileName + "' failed: " + e, (Throwable)e);
            }
        }
    }
}

