/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapterFactory;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;

public abstract class AbstractDatabaseAdapter
implements DatabaseAdapter {
    public static final String PERSISTENCE_PROPERTIES_TEMPLATE_FILE_NAME = "cloudstore-persistence.${databaseAdapter.name}.properties";
    private AbstractDatabaseAdapterFactory factory;
    private UUID repositoryId;
    private File localRoot;

    public AbstractDatabaseAdapterFactory getFactory() {
        return this.factory;
    }

    public AbstractDatabaseAdapterFactory getFactoryOrFail() {
        return Objects.requireNonNull(this.factory, "factory");
    }

    protected void setFactory(AbstractDatabaseAdapterFactory factory) {
        this.factory = factory;
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    public UUID getRepositoryIdOrFail() {
        return Objects.requireNonNull(this.repositoryId, "repositoryId");
    }

    @Override
    public void setRepositoryId(UUID repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public File getLocalRoot() {
        return this.localRoot;
    }

    public File getLocalRootOrFail() {
        return Objects.requireNonNull(this.localRoot, "localRoot");
    }

    @Override
    public void setLocalRoot(File localRoot) {
        this.localRoot = localRoot;
    }

    protected File getMetaDir() {
        return OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    protected File getPersistencePropertiesFile() {
        return OioFileFactory.createFile((File)this.getMetaDir(), (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
    }

    protected void createPersistencePropertiesFile() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("databaseAdapter.name", this.getFactoryOrFail().getName());
        String resolvedPersistencePropertiesTemplateFileName = IOUtil.replaceTemplateVariables((String)PERSISTENCE_PROPERTIES_TEMPLATE_FILE_NAME, variables);
        try {
            IOUtil.copyResource(this.getClass(), (String)("/" + resolvedPersistencePropertiesTemplateFileName), (File)this.getPersistencePropertiesFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createPersistencePropertiesFileAndDatabase() throws Exception {
        this.createPersistencePropertiesFile();
        this.createDatabase();
    }

    protected abstract void createDatabase() throws Exception;

    @Override
    public void close() throws Exception {
    }

    @Override
    public void shutdownEmbeddedDatabase() {
    }
}

