/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapter;
import co.codewizards.cloudstore.local.db.DatabaseAdapter;
import co.codewizards.cloudstore.local.db.DatabaseAdapterFactory;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;

public abstract class AbstractDatabaseAdapterFactory
implements DatabaseAdapterFactory {
    @Override
    public String getDisableReason() {
        return null;
    }

    @Override
    public DatabaseAdapter createDatabaseAdapter() {
        DatabaseAdapter databaseAdapter = this._createDatabaseAdapter();
        if (databaseAdapter == null) {
            throw new IllegalStateException(String.format("databaseAdapterFactory._createDatabaseAdapter() returned null! Implementation error in %s!", this.getClass().getName()));
        }
        if (databaseAdapter instanceof AbstractDatabaseAdapter) {
            ((AbstractDatabaseAdapter)databaseAdapter).setFactory(this);
        }
        return databaseAdapter;
    }

    protected abstract DatabaseAdapter _createDatabaseAdapter();

    protected File getMetaDir(File localRoot) {
        Objects.requireNonNull(localRoot, "localRoot");
        return OioFileFactory.createFile((File)localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME});
    }

    protected Properties readRawPersistenceProperties(File localRoot) {
        Properties rawProperties;
        Objects.requireNonNull(localRoot, "localRoot");
        File persistencePropertiesFile = OioFileFactory.createFile((File)this.getMetaDir(localRoot), (String[])new String[]{LocalRepoManager.PERSISTENCE_PROPERTIES_FILE_NAME});
        if (!persistencePropertiesFile.isFile()) {
            throw new IllegalStateException("The persistencePropertiesFile does not exist or is not a file: " + persistencePropertiesFile.getAbsolutePath());
        }
        try {
            rawProperties = PropertiesUtil.load((File)persistencePropertiesFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return rawProperties;
    }
}

