/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.local.db.DatabaseMigrater;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMigraterThreadManager {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseMigraterThreadManager.class);
    private final AtomicLong nextId = new AtomicLong();

    protected DatabaseMigraterThreadManager() {
    }

    public static DatabaseMigraterThreadManager getInstance() {
        return Holder.instance;
    }

    public void launch(final DatabaseMigrater databaseMigrater) {
        Objects.requireNonNull(databaseMigrater, "databaseMigrater");
        new Thread(){
            {
                this.setName("DatabaseMigraterThread-" + DatabaseMigraterThreadManager.this.nextId.getAndIncrement());
                this.setDaemon(false);
            }

            @Override
            public void run() {
                try {
                    databaseMigrater.migrateIfNeeded();
                }
                catch (Throwable error) {
                    logger.error("run: " + error, error);
                }
            }
        }.start();
    }

    private static final class Holder {
        protected static DatabaseMigraterThreadManager instance = new DatabaseMigraterThreadManager();

        private Holder() {
        }
    }
}

