/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.local.PersistencePropertiesEnum;
import co.codewizards.cloudstore.local.PersistencePropertiesProvider;
import co.codewizards.cloudstore.local.db.AbstractDatabaseAdapter;
import co.codewizards.cloudstore.local.db.Column;
import co.codewizards.cloudstore.local.db.Table;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DerbyDatabaseAdapter.class);
    private Map<String, String> persistenceProperties;
    private String connectionURL;
    private String connectionDriverName;
    private String connectionUserName;
    private String connectionPassword;

    @Override
    protected void createDatabase() throws Exception {
        if (this.connectionURL == null) {
            this.initProperties();
            this.initDriverClass();
        }
        this.connectionURL = Objects.requireNonNull(this.connectionURL, "connectionURL").trim() + ";create=true";
        Connection connection = this.createConnection();
        connection.close();
    }

    private void initDriverClass() {
        if (StringUtil.isEmpty((String)this.connectionDriverName)) {
            return;
        }
        try {
            Class.forName(this.connectionDriverName);
        }
        catch (Throwable e) {
            logger.warn("initDriverClass: " + e, e);
        }
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (this.connectionURL == null) {
            this.initProperties();
            this.initDriverClass();
        }
        if (StringUtil.isEmpty((String)this.connectionUserName) && StringUtil.isEmpty((String)this.connectionPassword)) {
            return DriverManager.getConnection(this.connectionURL);
        }
        return DriverManager.getConnection(this.connectionURL, this.connectionUserName, this.connectionPassword);
    }

    private void initProperties() {
        PersistencePropertiesProvider persistencePropertiesProvider = new PersistencePropertiesProvider(this.getRepositoryIdOrFail(), this.getLocalRootOrFail());
        this.persistenceProperties = persistencePropertiesProvider.getPersistenceProperties();
        this.connectionDriverName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_DRIVER_NAME.key);
        this.connectionURL = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_URL.key);
        this.connectionUserName = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_USER_NAME.key);
        this.connectionPassword = this.persistenceProperties.get(PersistencePropertiesEnum.CONNECTION_PASSWORD.key);
    }

    @Override
    public void shutdownEmbeddedDatabase() {
        if (this.connectionURL == null) {
            this.initProperties();
            this.initDriverClass();
        }
        DerbyUtil.shutdownDerbyDatabase((String)this.connectionURL);
    }

    @Override
    public boolean passivateIdentityColumn(Connection connection, Table table, SortedMap<String, Column> columnName2Column) throws Exception {
        Column idCol = (Column)columnName2Column.get("ID");
        if (idCol == null) {
            return false;
        }
        if (!Boolean.TRUE.equals(idCol.autoIncrement)) {
            return false;
        }
        try (Statement statement = connection.createStatement();){
            String sql = String.format("alter table \"%s\" drop column \"id\" cascade", table.name);
            logger.info("passivateIdentityColumn: Executing: {}", (Object)sql);
            statement.executeUpdate(sql);
            sql = String.format("alter table \"%s\" add column \"id\" bigint primary key generated by default as identity", table.name);
            logger.info("passivateIdentityColumn: Executing: {}", (Object)sql);
            statement.executeUpdate(sql);
        }
        return true;
    }

    @Override
    public void activateIdentityColumn(Connection connection, Table table, SortedMap<String, Column> columnName2Column) throws Exception {
        try (Statement statement = connection.createStatement();){
            long nextId;
            String sql = String.format("select max(\"id\") from \"%s\"", table.name);
            logger.info("activateIdentityColumn: Executing: {}", (Object)sql);
            try (ResultSet rs = statement.executeQuery(sql);){
                if (!rs.next()) {
                    throw new IllegalStateException("SELECT MAX(...) returned no row! Table: " + table.name);
                }
                nextId = rs.getLong(1);
                nextId = rs.wasNull() ? 1L : ++nextId;
                if (rs.next()) {
                    throw new IllegalStateException("SELECT MAX(...) returned multiple rows! Table: " + table.name);
                }
            }
            sql = String.format("alter table \"%s\" alter column \"id\" restart with %s", table.name, nextId);
            logger.info("activateIdentityColumn: Executing: {}", (Object)sql);
            statement.executeUpdate(sql);
        }
    }
}

