/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.local.PersistencePropertiesVariableProvider;
import java.util.Map;
import java.util.Objects;

public class ExternalJdbcPersistencePropertiesVariableProvider
implements PersistencePropertiesVariableProvider {
    private Config config;
    private Map<String, Object> variableMap;

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public void populatePersistencePropertiesVariableMap(Map<String, Object> variableMap) {
        this.variableMap = Objects.requireNonNull(variableMap, "variableMap");
        this.config = ConfigImpl.getInstance();
        this.copyConfigValueToVariable("jdbc.hostName");
        this.copyConfigValueToVariable("jdbc.userName");
        this.copyConfigValueToVariable("jdbc.password");
        this.copyConfigValueToVariable("jdbc.dbNamePrefix");
        this.copyConfigValueToVariable("jdbc.dbNameSuffix");
        this.copyConfigValueToVariable("jdbc.sysdbName");
    }

    private void copyConfigValueToVariable(String key) {
        Objects.requireNonNull(key, "key");
        String value = Objects.requireNonNull(this.config, "config").getPropertyAsNonEmptyTrimmedString(key, "");
        Objects.requireNonNull(this.variableMap, "variableMap").put(key, value);
    }
}

