/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import java.util.Objects;

public class Table
implements Comparable<Table> {
    public final String catalogue;
    public final String schema;
    public final String name;

    public Table(String catalogue, String schema, String name) {
        this.catalogue = catalogue;
        this.schema = schema;
        this.name = Objects.requireNonNull(name, "name");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[catalogue=" + Table.toStringWithSingleQuotes(this.catalogue) + ", schema=" + Table.toStringWithSingleQuotes(this.schema) + ", name=" + Table.toStringWithSingleQuotes(this.name) + "]";
    }

    private static String toStringWithSingleQuotes(String value) {
        if (value == null) {
            return String.valueOf(value);
        }
        return "'" + value + "'";
    }

    @Override
    public int compareTo(Table other) {
        Objects.requireNonNull(other, "other");
        int res = Table.compare(this.catalogue, other.catalogue);
        if (res != 0) {
            return res;
        }
        res = Table.compare(this.schema, other.schema);
        if (res != 0) {
            return res;
        }
        res = Table.compare(this.name, other.name);
        return res;
    }

    private static int compare(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.catalogue == null ? 0 : this.catalogue.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.schema, other.schema) && Objects.equals(this.catalogue, other.catalogue);
    }
}

