/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.dbupdate;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.core.util.PropertiesUtil;
import co.codewizards.cloudstore.local.dbupdate.AbstractDbUpdateStep;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class DbUpdateStep003
extends AbstractDbUpdateStep {
    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public void performUpdate() throws Exception {
        File persistencePropertiesFile = this.getPersistencePropertiesFile();
        String dateString = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        File persistencePropertiesBackup = persistencePropertiesFile.getParentFile().createFile(new String[]{persistencePropertiesFile.getName() + "." + dateString + ".bak"});
        IOUtil.copyFile((File)persistencePropertiesFile, (File)persistencePropertiesBackup);
        Properties persistenceProperties = PropertiesUtil.load((File)persistencePropertiesFile);
        String connectionUrl = persistenceProperties.getProperty("javax.jdo.option.ConnectionURL");
        if (connectionUrl != null && connectionUrl.contains(":derby:")) {
            IOUtil.copyResource(this.getClass(), (String)"/cloudstore-persistence.derby.properties", (File)this.getPersistencePropertiesFile());
        } else {
            persistenceProperties.setProperty("datanucleus.schema.autoCreateDatabase", "true");
            persistenceProperties.setProperty("datanucleus.schema.autoCreateTables", "true");
            persistenceProperties.setProperty("datanucleus.schema.autoCreateColumns", "true");
            persistenceProperties.setProperty("datanucleus.schema.autoCreateConstraints", "true");
            persistenceProperties.remove("datanucleus.autoCreateSchema");
            persistenceProperties.remove("datanucleus.autoCreateTables");
            persistenceProperties.remove("datanucleus.autoCreateColumns");
            persistenceProperties.remove("datanucleus.autoCreateConstraints");
            persistenceProperties.setProperty("datanucleus.schema.validateTables", "true");
            persistenceProperties.setProperty("datanucleus.schema.validateColumns", "true");
            persistenceProperties.setProperty("datanucleus.schema.validateConstraints", "true");
            persistenceProperties.remove("datanucleus.validateTables");
            persistenceProperties.remove("datanucleus.validateColumns");
            persistenceProperties.remove("datanucleus.validateConstraints");
            PropertiesUtil.store((File)persistencePropertiesFile, (Properties)persistenceProperties, null);
        }
    }
}

