/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.FileInProgressMarkerDao;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.Inheritance;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Queries;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.Unique;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable
@Inheritance(strategy=InheritanceStrategy.NEW_TABLE)
@Index(name="FileInProgressMark_fromRepositoryId_toRepositoryId", members={"fromRepositoryId", "toRepositoryId"})
@Unique(name="FileInProgressMark_fromRepositoryId_toRepositoryId_pathSha1", members={"fromRepositoryId", "toRepositoryId", "pathSha1"})
@Queries(value={@Query(name="getFileInProgressMarkers_fromRepositoryId_toRepositoryId", value="SELECT WHERE this.fromRepositoryId == :fromRepositoryId && this.toRepositoryId == :toRepositoryId"), @Query(name="getFileInProgressMarker_fromRepositoryId_toRepositoryId_pathSha1", value="SELECT UNIQUE WHERE this.fromRepositoryId == :fromRepositoryId && this.toRepositoryId == :toRepositoryId && this.pathSha1 == :pathSha1")})
public class FileInProgressMarker
extends Entity
implements Persistable {
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String fromRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String toRepositoryId;
    @Persistent(nullValue=NullValue.EXCEPTION)
    private String pathSha1;
    @Persistent(nullValue=NullValue.EXCEPTION, defaultFetchGroup="true")
    @Column(jdbcType="CLOB")
    private String path;
    private static final String[] dnFieldNames = FileInProgressMarker.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = FileInProgressMarker.__dnGetInheritedFieldCount();

    public UUID getFromRepositoryId() {
        return FileInProgressMarkerDao.convertToUuid(FileInProgressMarker.dnGetfromRepositoryId(this));
    }

    public void setFromRepositoryId(UUID fromRepositoryId) {
        if (!Util.equal((Object)this.getFromRepositoryId(), (Object)fromRepositoryId)) {
            FileInProgressMarker.dnSetfromRepositoryId(this, FileInProgressMarkerDao.convertToString(fromRepositoryId));
        }
    }

    public UUID getToRepositoryId() {
        return FileInProgressMarkerDao.convertToUuid(FileInProgressMarker.dnGettoRepositoryId(this));
    }

    public void setToRepositoryId(UUID toRepositoryId) {
        if (!Util.equal((Object)this.getToRepositoryId(), (Object)toRepositoryId)) {
            FileInProgressMarker.dnSettoRepositoryId(this, FileInProgressMarkerDao.convertToString(toRepositoryId));
        }
    }

    public String getPath() {
        return FileInProgressMarker.dnGetpath(this);
    }

    public void setPath(String path) {
        FileInProgressMarker.dnSetpathSha1(this, HashUtil.sha1((String)path));
        FileInProgressMarker.dnSetpath(this, path);
    }

    @Override
    protected String toString_getProperties() {
        return super.toString_getProperties() + String.format(", fromRepositoryId=\"%s\", toRepositoryId=\"%s\", path=\"%s\"", this.getClass().getSimpleName(), JDOHelper.getObjectId((Object)this), FileInProgressMarker.dnGetfromRepositoryId(this), FileInProgressMarker.dnGettoRepositoryId(this), FileInProgressMarker.dnGetpath(this));
    }

    static {
        EnhancementHelper.registerClass((Class)FileInProgressMarker.___dn$loadClass("co.codewizards.cloudstore.local.persistence.FileInProgressMarker"), (Persistable)new FileInProgressMarker());
    }

    @Override
    public boolean dnIsDetached() {
        return false;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm) {
        FileInProgressMarker result = new FileInProgressMarker();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    @Override
    public Persistable dnNewInstance(StateManager sm, Object obj) {
        FileInProgressMarker result = new FileInProgressMarker();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.fromRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.path = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.pathSha1 = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.toRepositoryId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                super.dnReplaceField(index);
            }
        }
    }

    @Override
    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.fromRepositoryId);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.path);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.pathSha1);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.toRepositoryId);
                break;
            }
            default: {
                super.dnProvideField(index);
            }
        }
    }

    protected final void dnCopyField(FileInProgressMarker obj, int index) {
        switch (index - dnInheritedFieldCount) {
            case 0: {
                this.fromRepositoryId = obj.fromRepositoryId;
                break;
            }
            case 1: {
                this.path = obj.path;
                break;
            }
            case 2: {
                this.pathSha1 = obj.pathSha1;
                break;
            }
            case 3: {
                this.toRepositoryId = obj.toRepositoryId;
                break;
            }
            default: {
                super.dnCopyField(obj, index);
            }
        }
    }

    @Override
    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof FileInProgressMarker)) {
            throw new IllegalArgumentException("object is not an object of type co.codewizards.cloudstore.local.persistence.FileInProgressMarker");
        }
        FileInProgressMarker other = (FileInProgressMarker)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"fromRepositoryId", "path", "pathSha1", "toRepositoryId"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return Entity.dnGetManagedFieldCount();
    }

    protected static int dnGetManagedFieldCount() {
        return 4 + Entity.dnGetManagedFieldCount();
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetfromRepositoryId(FileInProgressMarker objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.fromRepositoryId);
        }
        return objPC.fromRepositoryId;
    }

    private static void dnSetfromRepositoryId(FileInProgressMarker objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0 + dnInheritedFieldCount, objPC.fromRepositoryId, val);
        } else {
            objPC.fromRepositoryId = val;
        }
    }

    private static String dnGetpath(FileInProgressMarker objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.path);
        }
        return objPC.path;
    }

    private static void dnSetpath(FileInProgressMarker objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1 + dnInheritedFieldCount, objPC.path, val);
        } else {
            objPC.path = val;
        }
    }

    private static String dnGetpathSha1(FileInProgressMarker objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.pathSha1);
        }
        return objPC.pathSha1;
    }

    private static void dnSetpathSha1(FileInProgressMarker objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2 + dnInheritedFieldCount, objPC.pathSha1, val);
        } else {
            objPC.pathSha1 = val;
        }
    }

    private static String dnGettoRepositoryId(FileInProgressMarker objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3 + dnInheritedFieldCount)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.toRepositoryId);
        }
        return objPC.toRepositoryId;
    }

    private static void dnSettoRepositoryId(FileInProgressMarker objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3 + dnInheritedFieldCount, objPC.toRepositoryId, val);
        } else {
            objPC.toRepositoryId = val;
        }
    }
}

