/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.progress;

import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class LoggerProgressMonitor
implements ProgressMonitor {
    private final Logger logger;
    public static final String MESSAGE_VARIABLE_NAME = "${name}";
    public static final String MESSAGE_VARIABLE_PERCENTAGE = "${percentage}";
    private String message = "${name}: ${percentage}";
    private String name;
    private double internalTotalWork = Double.NaN;
    private double internalWorked = 0.0;
    protected float percentageWorked = 0.0f;
    private float lastLogMessage_percentageWorked = Float.MIN_VALUE;
    private long lastLogMessage_timestamp = 0L;
    private long logMinPeriodMSec = 5000L;
    private float logMinPercentageDifference = 5.0f;
    private int nestedBeginTasks = 0;
    private LogLevel logLevel = LogLevel.info;
    private static final NumberFormat PERCENTAGE_FORMAT = new DecimalFormat("0.00");
    private volatile boolean canceled = false;

    public LoggerProgressMonitor(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger == null");
        }
        this.logger = logger;
    }

    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized void setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("message must not be null!");
        }
        this.message = message;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public synchronized long getLogMinPeriodMSec() {
        return this.logMinPeriodMSec;
    }

    public synchronized void setLogMinPeriodMSec(long logMinPeriodMSec) {
        this.logMinPeriodMSec = logMinPeriodMSec;
    }

    public synchronized float getLogMinPercentageDifference() {
        return this.logMinPercentageDifference;
    }

    public synchronized void setLogMinPercentageDifference(float logMinPercentageDifference) {
        this.logMinPercentageDifference = logMinPercentageDifference;
    }

    @Override
    public synchronized void beginTask(String name, int totalWork) {
        if (++this.nestedBeginTasks > 1) {
            return;
        }
        if (name == null) {
            name = "anonymous";
        }
        if (totalWork < 0) {
            totalWork = 0;
        }
        this.name = name;
        this.internalTotalWork = totalWork;
    }

    @Override
    public synchronized void done() {
        if (this.nestedBeginTasks == 0 || --this.nestedBeginTasks > 0) {
            return;
        }
        double stillToWork = this.internalTotalWork - this.internalWorked;
        if (stillToWork > 0.0) {
            this.internalWorked(stillToWork);
        }
    }

    @Override
    public synchronized void internalWorked(double worked) {
        if (worked < 0.0 || worked == Double.NaN) {
            return;
        }
        if (this.internalWorked == this.internalTotalWork) {
            return;
        }
        this.internalWorked += worked;
        if (this.internalWorked > this.internalTotalWork) {
            this.internalWorked = this.internalTotalWork;
        }
        this.percentageWorked = (float)(100.0 * this.internalWorked / this.internalTotalWork);
        boolean doLog = false;
        if (!doLog && this.internalWorked == this.internalTotalWork) {
            doLog = true;
        }
        if (!doLog && this.percentageWorked - this.lastLogMessage_percentageWorked >= this.logMinPercentageDifference) {
            doLog = true;
        }
        long now = ChronosUtil.nowAsMillis();
        if (!doLog && now - this.lastLogMessage_timestamp >= this.logMinPeriodMSec) {
            doLog = true;
        }
        if (doLog) {
            this.lastLogMessage_percentageWorked = this.percentageWorked;
            this.lastLogMessage_timestamp = now;
            String percentageString = PERCENTAGE_FORMAT.format(this.percentageWorked) + '%';
            String msg = this.message.replaceAll(Pattern.quote(MESSAGE_VARIABLE_NAME), this.name);
            msg = msg.replaceAll(Pattern.quote(MESSAGE_VARIABLE_PERCENTAGE), percentageString);
            switch (this.logLevel) {
                case trace: {
                    this.logger.trace(msg);
                    break;
                }
                case debug: {
                    this.logger.debug(msg);
                    break;
                }
                case info: {
                    this.logger.info(msg);
                    break;
                }
                case warn: {
                    this.logger.warn(msg);
                    break;
                }
                case error: {
                    this.logger.error(msg);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown logLevel: " + (Object)((Object)this.logLevel));
                }
            }
        }
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public synchronized void setLogLevel(LogLevel logLevel) {
        if (logLevel == null) {
            throw new IllegalArgumentException("logLevel must not be null!");
        }
        this.logLevel = logLevel;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    @Override
    public synchronized void setTaskName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void subTask(String name) {
        this.name = name;
    }

    @Override
    public void worked(int work) {
        this.internalWorked(work);
    }

    public static enum LogLevel {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

