/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.progress.LoggerProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncQueueItem;
import co.codewizards.cloudstore.core.repo.sync.RepoToRepoSync;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepoSyncRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RepoSyncRunner.class);
    private final RepoSyncQueueItem repoSyncQueueItem;
    private Map<UUID, URL> remoteRepositoryId2RemoteRootMap = new HashMap<UUID, URL>(0);
    private UUID remoteRepositoryId;
    private URL remoteRoot;
    private Date syncStarted;
    private Date syncFinished;

    public RepoSyncRunner(RepoSyncQueueItem repoSyncQueueItem) {
        this.repoSyncQueueItem = Objects.requireNonNull(repoSyncQueueItem, "repoSyncQueueItem");
    }

    public RepoSyncQueueItem getSyncQueueItem() {
        return this.repoSyncQueueItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.syncStarted = ChronosUtil.nowAsDate();
        try {
            this.remoteRepositoryId = null;
            this.remoteRoot = null;
            try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(this.repoSyncQueueItem.localRoot);){
                this.remoteRepositoryId2RemoteRootMap = new HashMap<UUID, URL>(localRepoManager.getRemoteRepositoryId2RemoteRootMap());
            }
            for (Map.Entry<UUID, URL> me : this.remoteRepositoryId2RemoteRootMap.entrySet()) {
                this.remoteRepositoryId = me.getKey();
                this.remoteRoot = me.getValue();
                RepoToRepoSync repoToRepoSync = RepoToRepoSync.create(this.repoSyncQueueItem.localRoot, this.remoteRoot);
                try {
                    repoToRepoSync.sync(new LoggerProgressMonitor(logger));
                }
                finally {
                    if (repoToRepoSync == null) continue;
                    repoToRepoSync.close();
                }
            }
            this.remoteRepositoryId = null;
            this.remoteRoot = null;
        }
        finally {
            this.syncFinished = ChronosUtil.nowAsDate();
        }
    }

    public UUID getRemoteRepositoryId() {
        return this.remoteRepositoryId;
    }

    public URL getRemoteRoot() {
        return this.remoteRoot;
    }

    public Map<UUID, URL> getRemoteRepositoryId2RemoteRootMap() {
        return this.remoteRepositoryId2RemoteRootMap;
    }

    public Date getSyncStarted() {
        return this.syncStarted;
    }

    public Date getSyncFinished() {
        return this.syncFinished;
    }
}

