/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.DelayedMethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.DelayedResponseIdScheduledEviction;
import co.codewizards.cloudstore.ls.core.invoke.InvocationType;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.filter.InvocationFilterRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeMethodExecutor {
    private static final Logger logger = LoggerFactory.getLogger(InvokeMethodExecutor.class);
    private static final AtomicInteger nextInstanceId = new AtomicInteger();
    private final int instanceId = nextInstanceId.getAndIncrement();
    private final Executor executor = Executors.newCachedThreadPool();
    private final Map<Uid, InvocationRunnable> delayedResponseId2InvocationRunnable = Collections.synchronizedMap(new HashMap());
    private final SortedSet<DelayedResponseIdScheduledEviction> delayedResponseIdScheduledEvictions = Collections.synchronizedSortedSet(new TreeSet());
    private final Timer evictOldDataTimer = new Timer(String.format("InvokeMethodExecutor[%d].evictOldDataTimer", this.instanceId), true);
    private final TimerTask evictOldDataTimerTask = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LinkedList<Uid> delayedResponseIdsToEvict = new LinkedList<Uid>();
                Object object = InvokeMethodExecutor.this.delayedResponseIdScheduledEvictions;
                synchronized (object) {
                    Iterator it = InvokeMethodExecutor.this.delayedResponseIdScheduledEvictions.iterator();
                    while (it.hasNext()) {
                        DelayedResponseIdScheduledEviction delayedResponseIdScheduledEviction = (DelayedResponseIdScheduledEviction)it.next();
                        if (ChronosUtil.nowAsMillis() < delayedResponseIdScheduledEviction.getScheduledEvictionTimestamp()) break;
                        delayedResponseIdsToEvict.add(delayedResponseIdScheduledEviction.getDelayedResponseId());
                        it.remove();
                    }
                }
                object = InvokeMethodExecutor.this.delayedResponseId2InvocationRunnable;
                synchronized (object) {
                    for (Uid delayedResponseId : delayedResponseIdsToEvict) {
                        InvokeMethodExecutor.this.delayedResponseId2InvocationRunnable.remove(delayedResponseId);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("evictOldDataTimerTask.run: " + t, t);
            }
        }
    };

    public InvokeMethodExecutor() {
        this.evictOldDataTimer.schedule(this.evictOldDataTimerTask, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInvocationResponse execute(ExtMethodInvocationRequest extMethodInvocationRequest) throws Exception {
        Objects.requireNonNull(extMethodInvocationRequest, "extMethodInvocationRequest");
        InvocationFilterRegistry.getInstance().assertCanInvoke(extMethodInvocationRequest);
        InvocationRunnable invocationRunnable = new InvocationRunnable(extMethodInvocationRequest);
        this.executor.execute(invocationRunnable);
        InvocationRunnable invocationRunnable2 = invocationRunnable;
        synchronized (invocationRunnable2) {
            MethodInvocationResponse methodInvocationResponse = invocationRunnable.getMethodInvocationResponse();
            if (methodInvocationResponse != null) {
                return methodInvocationResponse;
            }
            Throwable error = invocationRunnable.getError();
            if (error != null) {
                InvokeMethodExecutor.throwError(error);
            }
            try {
                invocationRunnable.wait(45000L);
            }
            catch (InterruptedException e) {
                logger.debug("performMethodInvocation: " + e, (Throwable)e);
            }
            methodInvocationResponse = invocationRunnable.getMethodInvocationResponse();
            if (methodInvocationResponse != null) {
                return methodInvocationResponse;
            }
            error = invocationRunnable.getError();
            if (error != null) {
                InvokeMethodExecutor.throwError(error);
            }
            Uid delayedResponseId = invocationRunnable.getDelayedResponseId();
            Objects.requireNonNull(delayedResponseId, "delayedResponseId");
            this.delayedResponseId2InvocationRunnable.put(delayedResponseId, invocationRunnable);
            return new DelayedMethodInvocationResponse(delayedResponseId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInvocationResponse getDelayedResponse(Uid delayedResponseId) throws Exception {
        Objects.requireNonNull(delayedResponseId, "delayedResponseId");
        long schedEvTiSt = ChronosUtil.nowAsMillis() + 240000L;
        InvocationRunnable invocationRunnable = this.delayedResponseId2InvocationRunnable.get(delayedResponseId);
        if (invocationRunnable == null) {
            throw new IllegalArgumentException("delayedResponseId unknown: " + delayedResponseId);
        }
        InvocationRunnable invocationRunnable2 = invocationRunnable;
        synchronized (invocationRunnable2) {
            MethodInvocationResponse methodInvocationResponse = invocationRunnable.getMethodInvocationResponse();
            Throwable error = invocationRunnable.getError();
            if (methodInvocationResponse != null) {
                this.delayedResponseIdScheduledEvictions.add(new DelayedResponseIdScheduledEviction(schedEvTiSt, delayedResponseId));
                return methodInvocationResponse;
            }
            if (error != null) {
                this.delayedResponseIdScheduledEvictions.add(new DelayedResponseIdScheduledEviction(schedEvTiSt, delayedResponseId));
                InvokeMethodExecutor.throwError(error);
            }
            try {
                invocationRunnable.wait(45000L);
            }
            catch (InterruptedException e) {
                logger.debug("performMethodInvocation: " + e, (Throwable)e);
            }
            schedEvTiSt = ChronosUtil.nowAsMillis() + 240000L;
            methodInvocationResponse = invocationRunnable.getMethodInvocationResponse();
            if (methodInvocationResponse != null) {
                this.delayedResponseIdScheduledEvictions.add(new DelayedResponseIdScheduledEviction(schedEvTiSt, delayedResponseId));
                return methodInvocationResponse;
            }
            error = invocationRunnable.getError();
            if (error != null) {
                this.delayedResponseIdScheduledEvictions.add(new DelayedResponseIdScheduledEviction(schedEvTiSt, delayedResponseId));
                InvokeMethodExecutor.throwError(error);
            }
            return new DelayedMethodInvocationResponse(delayedResponseId);
        }
    }

    private static void throwError(Throwable error) throws Exception {
        Objects.requireNonNull(error, "error");
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        if (error instanceof Error) {
            throw (Error)error;
        }
        throw new RuntimeException(error);
    }

    private Object[] filterWritableArguments(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return null;
        }
        boolean atLeastOneWritable = false;
        Object[] result = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (argument == null || !argument.getClass().isArray()) continue;
            result[i] = argument;
            atLeastOneWritable = true;
        }
        return atLeastOneWritable ? result : null;
    }

    private class InvocationRunnable
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(InvocationRunnable.class);
        private final ExtMethodInvocationRequest extMethodInvocationRequest;
        private MethodInvocationResponse methodInvocationResponse;
        private Throwable error;
        private Uid delayedResponseId;

        public InvocationRunnable(ExtMethodInvocationRequest extMethodInvocationRequest) {
            this.extMethodInvocationRequest = Objects.requireNonNull(extMethodInvocationRequest, "extMethodInvocationRequest");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ObjectManager objectManager = this.extMethodInvocationRequest.getObjectManager();
            MethodInvocationRequest methodInvocationRequest = this.extMethodInvocationRequest.getMethodInvocationRequest();
            ClassManager classManager = this.extMethodInvocationRequest.getObjectManager().getClassManager();
            Class<?> clazz = this.extMethodInvocationRequest.getTargetClass();
            Object object = methodInvocationRequest.getObject();
            String methodName = methodInvocationRequest.getMethodName();
            String[] argumentTypeNames = methodInvocationRequest.getArgumentTypeNames();
            Class[] argumentTypes = argumentTypeNames == null ? null : classManager.getClassesOrFail(argumentTypeNames);
            Object[] arguments = methodInvocationRequest.getArguments();
            objectManager.getReferenceCleanerRegistry().preInvoke(this.extMethodInvocationRequest);
            Throwable error = null;
            Object resultObject = null;
            try {
                InvocationType invocationType = methodInvocationRequest.getInvocationType();
                switch (invocationType) {
                    case CONSTRUCTOR: {
                        resultObject = ReflectionUtil.invokeConstructor(clazz, (Object[])arguments);
                        break;
                    }
                    case OBJECT: {
                        resultObject = ReflectionUtil.invoke((Object)object, (String)methodName, (Class[])argumentTypes, (Object[])arguments);
                        break;
                    }
                    case STATIC: {
                        resultObject = ReflectionUtil.invokeStatic(clazz, (String)methodName, (Object[])arguments);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown InvocationType: " + (Object)((Object)invocationType));
                    }
                }
                objectManager.getReferenceCleanerRegistry().postInvoke(this.extMethodInvocationRequest, resultObject, error);
            }
            catch (Throwable x) {
                try {
                    resultObject = null;
                    error = x;
                    InvocationRunnable invocationRunnable = this;
                    synchronized (invocationRunnable) {
                        this.error = x;
                    }
                    this.logger.debug("run: " + x, x);
                    objectManager.getReferenceCleanerRegistry().postInvoke(this.extMethodInvocationRequest, resultObject, error);
                }
                catch (Throwable throwable) {
                    objectManager.getReferenceCleanerRegistry().postInvoke(this.extMethodInvocationRequest, resultObject, error);
                    throw throwable;
                }
            }
            InvocationRunnable invocationRunnable = this;
            synchronized (invocationRunnable) {
                if (this.error == null) {
                    this.methodInvocationResponse = MethodInvocationResponse.forInvocation(resultObject, InvokeMethodExecutor.this.filterWritableArguments(arguments));
                    Objects.requireNonNull(this.methodInvocationResponse, "methodInvocationResponse");
                }
                this.notifyAll();
                if (this.delayedResponseId != null) {
                    InvokeMethodExecutor.this.delayedResponseIdScheduledEvictions.add(new DelayedResponseIdScheduledEviction(ChronosUtil.nowAsMillis() + 900000L, this.delayedResponseId));
                }
            }
        }

        public synchronized MethodInvocationResponse getMethodInvocationResponse() {
            return this.methodInvocationResponse;
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized Uid getDelayedResponseId() {
            if (this.delayedResponseId == null) {
                this.delayedResponseId = new Uid();
            }
            return this.delayedResponseId;
        }
    }
}

