/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.ImplementsMetaData;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ClassMetaData
extends AbstractClassMetaData {
    private static final long serialVersionUID = -1029032058753152022L;
    protected List<ImplementsMetaData> implementations = null;
    protected boolean isAbstract;

    public ClassMetaData(PackageMetaData parent, String name) {
        super(parent, name);
    }

    public ClassMetaData(InterfaceMetaData imd, String implClassName, boolean copyFields) {
        super(imd, implClassName, copyFields);
    }

    public ClassMetaData(ClassMetaData cmd, String implClassName) {
        super(cmd, implClassName);
    }

    @Override
    public synchronized void populate(ClassLoaderResolver clr, ClassLoader primary, MetaDataManager mgr) {
        if (this.isInitialised() || this.isPopulated()) {
            NucleusLogger.METADATA.error(Localiser.msg("044068", this.name));
            throw new NucleusException(Localiser.msg("044068", this.fullName)).setFatal();
        }
        if (this.populating) {
            return;
        }
        this.mmgr = mgr;
        try {
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044075", this.fullName));
            }
            this.populating = true;
            Class cls = this.loadClass(clr, primary);
            this.isAbstract = Modifier.isAbstract(cls.getModifiers());
            if (!this.isMetaDataComplete()) {
                this.mmgr.addAnnotationsDataToClass(cls, this, clr);
            }
            this.mmgr.addORMDataToClass(cls, clr);
            if (ClassUtils.isInnerClass(this.fullName) && !Modifier.isStatic(cls.getModifiers()) && this.persistenceModifier == ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                throw new InvalidClassMetaDataException("044063", new Object[]{this.fullName});
            }
            if (this.entityName == null) {
                this.entityName = this.name;
            }
            this.determineSuperClassName(clr, cls);
            this.inheritIdentity();
            this.determineIdentity();
            this.validateUserInputForIdentity();
            this.addMetaDataForMembersNotInMetaData(cls);
            this.validateUserInputForInheritanceMetaData(this.isAbstract());
            this.determineInheritanceMetaData();
            this.applyDefaultDiscriminatorValueWhenNotSpecified();
            Iterator memberIter = this.members.iterator();
            HashSet<AbstractMemberMetaData> membersToDelete = null;
            block5: while (memberIter.hasNext()) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)memberIter.next();
                if (mmd.className == null || !mmd.className.equals("#UNKNOWN")) continue;
                if (this.pcSuperclassMetaData == null) {
                    mmd.className = null;
                    continue;
                }
                AbstractMemberMetaData superFmd = this.pcSuperclassMetaData.getMetaDataForMember(mmd.getName());
                if (superFmd == null) continue;
                mmd.className = superFmd.className != null ? superFmd.className : superFmd.getClassName();
                mmd.primaryKey = superFmd.primaryKey;
                mmd.persistenceModifier = superFmd.persistenceModifier;
                mmd.valueStrategy = superFmd.valueStrategy;
                mmd.valueGeneratorName = superFmd.valueGeneratorName;
                mmd.sequence = superFmd.sequence;
                mmd.cacheable = superFmd.cacheable;
                mmd.storeInLob = superFmd.storeInLob;
                for (AbstractMemberMetaData existingMmd : this.members) {
                    if (!existingMmd.getName().equals(mmd.getName()) || existingMmd == mmd) continue;
                    mmd.type = existingMmd.getType();
                    if (membersToDelete == null) {
                        membersToDelete = new HashSet<AbstractMemberMetaData>();
                    }
                    membersToDelete.add(existingMmd);
                    continue block5;
                }
            }
            if (membersToDelete != null) {
                this.members.removeAll(membersToDelete);
            }
            if (this.objectidClass == null) {
                this.populateMemberMetaData(clr, cls, true, primary);
                this.determineObjectIdClass();
                this.populateMemberMetaData(clr, cls, false, primary);
            } else {
                this.populateMemberMetaData(clr, cls, true, primary);
                this.populateMemberMetaData(clr, cls, false, primary);
                this.determineObjectIdClass();
            }
            this.validateUnmappedColumns();
            if (this.implementations != null) {
                for (ImplementsMetaData implmd : this.implementations) {
                    implmd.populate(clr, primary);
                }
            }
            if (this.persistentInterfaceImplNeedingTableFromSuperclass) {
                AbstractClassMetaData acmd = this.getMetaDataForSuperinterfaceManagingTable(cls, clr);
                if (acmd != null) {
                    this.table = acmd.table;
                    this.schema = acmd.schema;
                    this.catalog = acmd.catalog;
                }
                this.persistentInterfaceImplNeedingTableFromSuperclass = false;
            } else if (this.persistentInterfaceImplNeedingTableFromSubclass) {
                this.persistentInterfaceImplNeedingTableFromSubclass = false;
            }
            this.setPopulated();
        }
        catch (RuntimeException e) {
            NucleusLogger.METADATA.debug(e);
            throw e;
        }
        finally {
            this.populating = false;
        }
    }

    private AbstractClassMetaData getMetaDataForSuperinterfaceManagingTable(Class cls, ClassLoaderResolver clr) {
        for (Class<?> superintf : ClassUtils.getSuperinterfaces(cls)) {
            InterfaceMetaData acmd = this.mmgr.getMetaDataForInterface(superintf, clr);
            if (acmd == null || acmd.getInheritanceMetaData() == null) continue;
            if (acmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.NEW_TABLE) {
                return acmd;
            }
            if (acmd.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
            return this.getMetaDataForSuperinterfaceManagingTable(superintf, clr);
        }
        return null;
    }

    protected void addMetaDataForMembersNotInMetaData(Class cls) {
        String api = this.mmgr.getNucleusContext().getApiName();
        HashSet<String> memberNames = new HashSet<String>();
        for (AbstractMemberMetaData mmd : this.members) {
            memberNames.add(mmd.getName());
        }
        Collections.sort(this.members);
        try {
            int i;
            int i2;
            boolean hasProperties = false;
            for (i2 = 0; i2 < this.members.size(); ++i2) {
                if (!(this.members.get(i2) instanceof PropertyMetaData)) continue;
                hasProperties = true;
                break;
            }
            if (this.members.size() == 0 && this.pcSuperclassMetaData != null) {
                for (i2 = 0; i2 < this.pcSuperclassMetaData.members.size(); ++i2) {
                    if (!(this.pcSuperclassMetaData.members.get(i2) instanceof PropertyMetaData)) continue;
                    hasProperties = true;
                    break;
                }
            }
            if (hasProperties && api.equalsIgnoreCase("JPA")) {
                Method[] clsMethods = cls.getDeclaredMethods();
                for (i = 0; i < clsMethods.length; ++i) {
                    String propertyName;
                    if (!clsMethods[i].getDeclaringClass().getName().equals(this.fullName) || clsMethods[i].isBridge() || !ClassUtils.isJavaBeanGetterMethod(clsMethods[i]) || ClassUtils.isInnerClass(clsMethods[i].getName()) || memberNames.contains(propertyName = ClassUtils.getFieldNameForJavaBeanGetter(clsMethods[i].getName()))) continue;
                    NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, propertyName));
                    PropertyMetaData mmd = new PropertyMetaData((MetaData)this, propertyName);
                    this.members.add(mmd);
                    memberNames.add(mmd.getName());
                    Collections.sort(this.members);
                }
            }
            Field[] clsFields = cls.getDeclaredFields();
            for (i = 0; i < clsFields.length; ++i) {
                if (ClassUtils.isInnerClass(clsFields[i].getName()) || Modifier.isStatic(clsFields[i].getModifiers()) || this.mmgr.isEnhancerField(clsFields[i].getName()) || !clsFields[i].getDeclaringClass().getName().equals(this.fullName) || memberNames.contains(clsFields[i].getName()) || hasProperties && api.equalsIgnoreCase("JPA")) continue;
                FieldMetaData mmd = new FieldMetaData((MetaData)this, clsFields[i].getName());
                NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, clsFields[i].getName()));
                this.members.add(mmd);
                memberNames.add(mmd.getName());
                Collections.sort(this.members);
            }
            ParameterizedType genSuperclassParamType = cls.getGenericSuperclass() instanceof ParameterizedType ? (ParameterizedType)cls.getGenericSuperclass() : null;
            TypeVariable<Class<T>>[] clsDeclTypes = cls.getTypeParameters();
            if (hasProperties) {
                Method[] allclsMethods = cls.getMethods();
                block7: for (int i3 = 0; i3 < allclsMethods.length; ++i3) {
                    int j;
                    if (allclsMethods[i3].getDeclaringClass().getName().equals(this.fullName) || !ClassUtils.isJavaBeanGetterMethod(allclsMethods[i3]) || ClassUtils.isInnerClass(allclsMethods[i3].getName()) || allclsMethods[i3].getGenericReturnType() == null || !(allclsMethods[i3].getGenericReturnType() instanceof TypeVariable)) continue;
                    TypeVariable methodTypeVar = (TypeVariable)allclsMethods[i3].getGenericReturnType();
                    Class<?> declCls = allclsMethods[i3].getDeclaringClass();
                    TypeVariable<Class<?>>[] declTypes = declCls.getTypeParameters();
                    String propertyName = ClassUtils.getFieldNameForJavaBeanGetter(allclsMethods[i3].getName());
                    String propertyNameFull = allclsMethods[i3].getDeclaringClass().getName() + "." + propertyName;
                    boolean foundTypeForTypeVariable = false;
                    if (declTypes != null) {
                        for (j = 0; j < declTypes.length; ++j) {
                            Type[] paramTypeArgs;
                            if (genSuperclassParamType == null || !declTypes[j].getName().equals(methodTypeVar.getName()) || (paramTypeArgs = genSuperclassParamType.getActualTypeArguments()) == null || paramTypeArgs.length <= j || !(paramTypeArgs[j] instanceof Class)) continue;
                            NucleusLogger.METADATA.debug("Class=" + cls.getName() + " property=" + propertyName + " declared to return " + methodTypeVar + ", namely TypeVariable(" + j + ") of " + declCls.getName() + " so using " + paramTypeArgs[j]);
                            if (!memberNames.contains(propertyName)) {
                                NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, propertyNameFull));
                                AbstractMemberMetaData overriddenMmd = this.getMemberBeingOverridden(propertyName);
                                PropertyMetaData mmd = new PropertyMetaData((MetaData)this, propertyNameFull);
                                this.mergeMemberMetaDataForOverrideOfType((Class)paramTypeArgs[j], mmd, overriddenMmd);
                                this.members.add(mmd);
                                memberNames.add(mmd.getName());
                                Collections.sort(this.members);
                            } else {
                                AbstractMemberMetaData overrideMmd = this.getMetaDataForMember(propertyName);
                                overrideMmd.type = (Class)paramTypeArgs[j];
                            }
                            foundTypeForTypeVariable = true;
                            break;
                        }
                    }
                    if (foundTypeForTypeVariable || clsDeclTypes == null) continue;
                    for (j = 0; j < clsDeclTypes.length; ++j) {
                        Type[] boundTypes;
                        if (!clsDeclTypes[j].getName().equals(methodTypeVar.getName()) || (boundTypes = clsDeclTypes[j].getBounds()) == null || boundTypes.length != 1 || !(boundTypes[0] instanceof Class)) continue;
                        boolean updateType = true;
                        AbstractMemberMetaData overriddenMmd = this.getMetaDataForMember(propertyName);
                        if (overriddenMmd != null && overriddenMmd.getTypeName().equals(((Class)boundTypes[0]).getName())) {
                            updateType = false;
                        }
                        if (updateType) {
                            NucleusLogger.METADATA.debug("Class=" + cls.getName() + " property=" + propertyName + " declared to return " + methodTypeVar + ", namely TypeVariable(" + j + ") with bound, so using bound of " + boundTypes[0]);
                            if (!memberNames.contains(propertyName)) {
                                NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, propertyNameFull));
                                PropertyMetaData mmd = new PropertyMetaData((MetaData)this, propertyNameFull);
                                this.mergeMemberMetaDataForOverrideOfType((Class)boundTypes[0], mmd, overriddenMmd);
                                this.members.add(mmd);
                                memberNames.add(mmd.getName());
                                Collections.sort(this.members);
                            } else {
                                AbstractMemberMetaData overrideMmd = this.getMetaDataForMember(propertyName);
                                overrideMmd.type = (Class)boundTypes[0];
                            }
                        }
                        foundTypeForTypeVariable = true;
                        continue block7;
                    }
                }
            } else {
                Class theClass = cls;
                while (theClass.getSuperclass() != null) {
                    theClass = theClass.getSuperclass();
                    Field[] theclsFields = theClass.getDeclaredFields();
                    block11: for (int i4 = 0; i4 < theclsFields.length; ++i4) {
                        int j;
                        if (ClassUtils.isInnerClass(theclsFields[i4].getName()) || Modifier.isStatic(theclsFields[i4].getModifiers()) || this.mmgr.isEnhancerField(theclsFields[i4].getName()) || theclsFields[i4].getGenericType() == null || !(theclsFields[i4].getGenericType() instanceof TypeVariable)) continue;
                        TypeVariable fieldTypeVar = (TypeVariable)theclsFields[i4].getGenericType();
                        Class<?> declCls = theclsFields[i4].getDeclaringClass();
                        TypeVariable<Class<?>>[] declTypes = declCls.getTypeParameters();
                        String fieldName = theclsFields[i4].getName();
                        String fieldNameFull = declCls.getName() + "." + theclsFields[i4].getName();
                        boolean foundTypeForTypeVariable = false;
                        if (declTypes != null) {
                            for (j = 0; j < declTypes.length; ++j) {
                                Type[] paramTypeArgs;
                                if (genSuperclassParamType == null || !declTypes[j].getName().equals(fieldTypeVar.getName()) || (paramTypeArgs = genSuperclassParamType.getActualTypeArguments()) == null || paramTypeArgs.length <= j || !(paramTypeArgs[j] instanceof Class)) continue;
                                NucleusLogger.METADATA.debug("Class=" + cls.getName() + " field=" + fieldName + " declared to be " + fieldTypeVar + ", namely TypeVariable(" + j + ") of " + declCls.getName() + " so using " + paramTypeArgs[j]);
                                if (!memberNames.contains(fieldName)) {
                                    NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, fieldNameFull));
                                    AbstractMemberMetaData overriddenMmd = this.getMemberBeingOverridden(fieldName);
                                    FieldMetaData mmd = new FieldMetaData((MetaData)this, fieldNameFull);
                                    this.mergeMemberMetaDataForOverrideOfType((Class)paramTypeArgs[j], mmd, overriddenMmd);
                                    this.members.add(mmd);
                                    memberNames.add(mmd.getName());
                                    Collections.sort(this.members);
                                } else {
                                    AbstractMemberMetaData overrideMmd = this.getMetaDataForMember(fieldName);
                                    overrideMmd.type = (Class)paramTypeArgs[j];
                                }
                                foundTypeForTypeVariable = true;
                                break;
                            }
                        }
                        if (foundTypeForTypeVariable || clsDeclTypes == null) continue;
                        for (j = 0; j < clsDeclTypes.length; ++j) {
                            Type[] boundTypes;
                            if (!clsDeclTypes[j].getName().equals(fieldTypeVar.getName()) || (boundTypes = clsDeclTypes[j].getBounds()) == null || boundTypes.length != 1 || !(boundTypes[0] instanceof Class)) continue;
                            boolean updateType = true;
                            AbstractMemberMetaData overriddenMmd = this.getMetaDataForMember(fieldName);
                            if (overriddenMmd != null && overriddenMmd.getTypeName().equals(((Class)boundTypes[0]).getName())) {
                                updateType = false;
                            }
                            if (updateType) {
                                NucleusLogger.METADATA.debug("Class=" + cls.getName() + " field=" + fieldName + " declared to be " + fieldTypeVar + ", namely TypeVariable(" + j + ") with bound, so using bound of " + boundTypes[0]);
                                if (!memberNames.contains(fieldName)) {
                                    NucleusLogger.METADATA.debug(Localiser.msg("044060", this.fullName, fieldNameFull));
                                    FieldMetaData mmd = new FieldMetaData((MetaData)this, fieldNameFull);
                                    this.mergeMemberMetaDataForOverrideOfType((Class)boundTypes[0], mmd, overriddenMmd);
                                    this.members.add(mmd);
                                    memberNames.add(mmd.getName());
                                    Collections.sort(this.members);
                                } else {
                                    AbstractMemberMetaData overrideMmd = this.getMetaDataForMember(fieldName);
                                    overrideMmd.type = (Class)boundTypes[0];
                                }
                            }
                            foundTypeForTypeVariable = true;
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            NucleusLogger.METADATA.error(e.getMessage(), e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private void mergeMemberMetaDataForOverrideOfType(Class type, AbstractMemberMetaData mmd, AbstractMemberMetaData overriddenMmd) {
        mmd.type = type;
        if (overriddenMmd != null) {
            mmd.primaryKey = overriddenMmd.primaryKey;
            mmd.embedded = overriddenMmd.embedded;
            mmd.serialized = overriddenMmd.serialized;
            mmd.persistenceModifier = overriddenMmd.persistenceModifier;
            mmd.valueStrategy = overriddenMmd.valueStrategy;
        }
    }

    protected void populateMemberMetaData(ClassLoaderResolver clr, Class cls, boolean pkMembers, ClassLoader primary) {
        Collections.sort(this.members);
        for (AbstractMemberMetaData mmd : this.members) {
            if (pkMembers != mmd.isPrimaryKey()) continue;
            Class fieldCls = cls;
            if (!mmd.fieldBelongsToClass()) {
                try {
                    fieldCls = clr.classForName(mmd.getClassName());
                }
                catch (ClassNotResolvedException cnre) {
                    String fieldClassName = this.getPackageName() + "." + mmd.getClassName();
                    try {
                        fieldCls = clr.classForName(fieldClassName);
                        mmd.setClassName(fieldClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        NucleusLogger.METADATA.error(Localiser.msg("044092", this.fullName, mmd.getFullFieldName(), fieldClassName));
                        throw new InvalidClassMetaDataException("044092", this.fullName, mmd.getFullFieldName(), fieldClassName);
                    }
                }
            }
            boolean populated = false;
            if (mmd instanceof PropertyMetaData) {
                Class<?> setType;
                Class<?> getType;
                Method setMethod;
                Method getMethod;
                block24: {
                    getMethod = null;
                    try {
                        getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), false), new Class[0]);
                    }
                    catch (Exception e) {
                        try {
                            getMethod = fieldCls.getDeclaredMethod(ClassUtils.getJavaBeanGetterName(mmd.getName(), true), new Class[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (getMethod != null && getMethod.getReturnType() == Void.TYPE) {
                        throw new InvalidClassMetaDataException("044166", this.fullName, mmd.getName());
                    }
                    if (getMethod == null && mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                        throw new InvalidClassMetaDataException("044073", this.fullName, mmd.getName());
                    }
                    setMethod = null;
                    try {
                        int i;
                        String setterName = ClassUtils.getJavaBeanSetterName(mmd.getName());
                        Method[] methods = fieldCls.getMethods();
                        for (i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
                            setMethod = methods[i];
                            break;
                        }
                        if (setMethod != null) break block24;
                        methods = fieldCls.getDeclaredMethods();
                        for (i = 0; i < methods.length; ++i) {
                            if (!methods[i].getName().equals(setterName) || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1 || methods[i].isBridge()) continue;
                            setMethod = methods[i];
                            break;
                        }
                    }
                    catch (Exception setterName) {
                        // empty catch block
                    }
                }
                if (setMethod == null && mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE) {
                    throw new InvalidClassMetaDataException("044074", this.fullName, mmd.getName());
                }
                if (setMethod != null && getMethod != null && !(getType = getMethod.getReturnType()).isAssignableFrom(setType = setMethod.getParameterTypes()[0]) && !setType.isAssignableFrom(getType)) {
                    throw new InvalidMetaDataException("044167", this.fullName, mmd.getName(), getType.getName(), setType.getName());
                }
                if (getMethod != null) {
                    mmd.populate(clr, null, getMethod, primary, this.mmgr);
                    populated = true;
                }
            } else {
                Field clsField = null;
                try {
                    clsField = fieldCls.getDeclaredField(mmd.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (clsField != null) {
                    mmd.populate(clr, clsField, null, primary, this.mmgr);
                    populated = true;
                }
            }
            if (populated) continue;
            throw new InvalidClassMetaDataException("044071", this.fullName, mmd.getFullFieldName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialise(ClassLoaderResolver clr) {
        if (this.initialising || this.isInitialised()) {
            return;
        }
        this.checkPopulated();
        try {
            this.initialising = true;
            if (this.pcSuperclassMetaData != null && !this.pcSuperclassMetaData.isInitialised()) {
                this.pcSuperclassMetaData.initialise(clr);
            }
            if (NucleusLogger.METADATA.isDebugEnabled()) {
                NucleusLogger.METADATA.debug(Localiser.msg("044076", this.fullName));
            }
            this.validateObjectIdClass(clr);
            Iterator membersIter = this.members.iterator();
            int numManaged = 0;
            int numOverridden = 0;
            while (membersIter.hasNext()) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)membersIter.next();
                mmd.initialise(clr);
                if (!mmd.isFieldToBePersisted()) continue;
                if (mmd.fieldBelongsToClass()) {
                    ++numManaged;
                    continue;
                }
                ++numOverridden;
            }
            this.managedMembers = new AbstractMemberMetaData[numManaged];
            this.overriddenMembers = new AbstractMemberMetaData[numOverridden];
            membersIter = this.members.iterator();
            int memberId = 0;
            int overriddenMemberId = 0;
            this.memberPositionsByName = new HashMap();
            while (membersIter.hasNext()) {
                AbstractMemberMetaData mmd = (AbstractMemberMetaData)membersIter.next();
                if (!mmd.isFieldToBePersisted()) continue;
                if (mmd.fieldBelongsToClass()) {
                    mmd.setFieldId(memberId);
                    this.managedMembers[memberId] = mmd;
                    this.memberPositionsByName.put(mmd.getName(), memberId);
                    ++memberId;
                    continue;
                }
                this.overriddenMembers[overriddenMemberId++] = mmd;
                if (this.pcSuperclassMetaData == null) {
                    throw new InvalidClassMetaDataException("044162", this.fullName, mmd.getFullFieldName());
                }
                AbstractMemberMetaData superMmd = this.pcSuperclassMetaData.getMemberBeingOverridden(mmd.getName());
                if (superMmd == null || !superMmd.isPrimaryKey()) continue;
                mmd.setPrimaryKey(true);
            }
            if (this.pcSuperclassMetaData != null) {
                if (!this.pcSuperclassMetaData.isInitialised()) {
                    this.pcSuperclassMetaData.initialise(clr);
                }
                this.noOfInheritedManagedMembers = this.pcSuperclassMetaData.getNoOfInheritedManagedMembers() + this.pcSuperclassMetaData.getNoOfManagedMembers();
            }
            this.initialiseMemberPositionInformation();
            if (this.implementations != null) {
                for (ImplementsMetaData implmd : this.implementations) {
                    implmd.initialise(clr);
                }
            }
            if (this.joins != null) {
                for (JoinMetaData joinmd : this.joins) {
                    joinmd.initialise(clr);
                }
            }
            if (this.foreignKeys != null) {
                for (ForeignKeyMetaData fkmd : this.foreignKeys) {
                    fkmd.initialise(clr);
                }
            }
            if (this.indexes != null) {
                for (IndexMetaData idxmd : this.indexes) {
                    idxmd.initialise(clr);
                }
            }
            if (this.uniqueConstraints != null) {
                for (UniqueMetaData unimd : this.uniqueConstraints) {
                    unimd.initialise(clr);
                }
            }
            if (this.fetchGroups != null) {
                this.fetchGroupMetaDataByName = new HashMap();
                for (FetchGroupMetaData fgmd : this.fetchGroups) {
                    fgmd.initialise(clr);
                    this.fetchGroupMetaDataByName.put(fgmd.getName(), fgmd);
                }
            }
            if (this.identityType == IdentityType.DATASTORE && this.identityMetaData == null) {
                if (this.pcSuperclassMetaData != null) {
                    IdentityMetaData superImd = this.pcSuperclassMetaData.getIdentityMetaData();
                    this.identityMetaData = new IdentityMetaData();
                    this.identityMetaData.setColumnName(superImd.getColumnName());
                    this.identityMetaData.setValueStrategy(superImd.getValueStrategy());
                    this.identityMetaData.setSequence(superImd.getSequence());
                    this.identityMetaData.parent = this;
                } else {
                    this.identityMetaData = new IdentityMetaData();
                    this.identityMetaData.parent = this;
                }
            }
            if (this.primaryKeyMetaData != null) {
                this.primaryKeyMetaData.initialise(clr);
            }
            if (this.versionMetaData != null) {
                this.versionMetaData.initialise(clr);
            }
            if (this.identityMetaData != null) {
                this.identityMetaData.initialise(clr);
            }
            if (this.inheritanceMetaData != null) {
                this.inheritanceMetaData.initialise(clr);
            }
            if (this.identityType == IdentityType.APPLICATION) {
                this.usesSingleFieldIdentityClass = IdentityUtils.isSingleFieldIdentityClass(this.getObjectidClass());
            }
            this.setInitialised();
        }
        finally {
            this.initialising = false;
            this.mmgr.abstractClassMetaDataInitialised(this);
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    protected AbstractMemberMetaData newDefaultedProperty(String name) {
        return new FieldMetaData((MetaData)this, name);
    }

    public final List<ImplementsMetaData> getImplementsMetaData() {
        return this.implementations;
    }

    public void addImplements(ImplementsMetaData implmd) {
        if (implmd == null) {
            return;
        }
        if (this.isInitialised()) {
            throw new RuntimeException("Already initialised");
        }
        if (this.implementations == null) {
            this.implementations = new ArrayList<ImplementsMetaData>();
        }
        this.implementations.add(implmd);
        implmd.parent = this;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(super.toString()).append(" [").append(this.getFullClassName()).append("]");
        if (this.identityType != null) {
            str.append(" identity=").append(this.identityType.toString());
            if (this.identityType == IdentityType.APPLICATION) {
                str.append("(").append(this.getNoOfPrimaryKeyMembers()).append(" pkFields, id=").append(this.objectidClass).append(")");
            }
        }
        str.append(", modifier=" + (Object)((Object)this.persistenceModifier));
        str.append(", embeddedOnly=" + this.embeddedOnly);
        if (this.inheritanceMetaData != null && this.inheritanceMetaData.getStrategy() != null) {
            str.append(", inheritance=").append(this.inheritanceMetaData.getStrategy().toString());
        }
        if (this.isInitialised()) {
            int i;
            str.append(", managedMembers.size=").append(this.managedMembers.length);
            str.append(", overriddenMembers.size=").append(this.overriddenMembers.length);
            str.append("\n");
            str.append("    managed=[");
            for (i = 0; i < this.managedMembers.length; ++i) {
                if (i != 0) {
                    str.append(",");
                }
                str.append(this.managedMembers[i] instanceof PropertyMetaData ? "Property(" : "Field(").append(this.managedMembers[i].getFullFieldName()).append(")");
            }
            str.append("]");
            str.append("\n");
            str.append("    overridden=[");
            for (i = 0; i < this.overriddenMembers.length; ++i) {
                if (i != 0) {
                    str.append(",");
                }
                str.append(this.overriddenMembers[i] instanceof PropertyMetaData ? "Property(" : "Field(").append(this.overriddenMembers[i].getFullFieldName()).append(")");
            }
            str.append("]");
        } else {
            str.append(", members.size=").append(this.members.size());
        }
        return str.toString();
    }
}

