/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.repo.local.AbstractLocalRepoTransactionListener;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.LocalRepoTransactionImpl;
import co.codewizards.cloudstore.local.persistence.AutoTrackChanged;
import co.codewizards.cloudstore.local.persistence.AutoTrackLocalRevision;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.listener.DeleteLifecycleListener;
import javax.jdo.listener.InstanceLifecycleEvent;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.listener.StoreLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTrackLifecycleListener
extends AbstractLocalRepoTransactionListener
implements StoreLifecycleListener,
DeleteLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(AutoTrackLifecycleListener.class);
    private final Map<Object, Date> oid2LastChanged = new HashMap<Object, Date>();
    private boolean defer;

    public LocalRepoTransactionImpl getTransaction() {
        return (LocalRepoTransactionImpl)super.getTransaction();
    }

    protected LocalRepoTransactionImpl getTransactionOrFail() {
        return (LocalRepoTransactionImpl)super.getTransactionOrFail();
    }

    public void setTransaction(LocalRepoTransaction transaction) {
        if (!(transaction instanceof LocalRepoTransactionImpl)) {
            throw new IllegalArgumentException("transaction is not an instance of LocalRepoTransactionImpl!");
        }
        super.setTransaction(transaction);
    }

    public void preStore(InstanceLifecycleEvent event) {
        this.onWrite(event.getPersistentInstance());
    }

    public void postStore(InstanceLifecycleEvent event) {
    }

    public void preDelete(InstanceLifecycleEvent event) {
        this.getTransactionOrFail().getLocalRevision();
        Object oid = JDOHelper.getObjectId((Object)event.getPersistentInstance());
        this.oid2LastChanged.remove(oid);
    }

    public void postDelete(InstanceLifecycleEvent event) {
    }

    private void onWrite(Object pc) {
        Object entity;
        long localRevision = this.getTransactionOrFail().getLocalRevision();
        Date changed = ChronosUtil.nowAsDate();
        Object oid = JDOHelper.getObjectId((Object)pc);
        if (!this.defer && oid != null) {
            Date oldLastChanged = this.oid2LastChanged.get(oid);
            this.oid2LastChanged.put(oid, changed);
            if (oldLastChanged != null) {
                logger.debug("onWrite: skipping (already processed in this transaction): {}", pc);
                return;
            }
        }
        if (pc instanceof AutoTrackChanged) {
            logger.debug("onWrite: setChanged({}) for {}", (Object)changed, pc);
            entity = (AutoTrackChanged)pc;
            entity.setChanged(changed);
        }
        if (pc instanceof AutoTrackLocalRevision) {
            logger.debug("onWrite: setLocalRevision({}) for {}", (Object)localRevision, pc);
            entity = (AutoTrackLocalRevision)pc;
            entity.setLocalRevision(localRevision);
        }
    }

    public void onBegin() {
        this.defer = true;
        this.getTransactionOrFail().getPersistenceManager().addInstanceLifecycleListener((InstanceLifecycleListener)this, (Class[])null);
    }

    public void onCommit() {
        this.defer = false;
        long start = ChronosUtil.nowAsMillis();
        PersistenceManager pm = this.getTransactionOrFail().getPersistenceManager();
        for (Map.Entry<Object, Date> me : this.oid2LastChanged.entrySet()) {
            try {
                Object pc = pm.getObjectById(me.getKey());
                if (!(pc instanceof AutoTrackChanged)) continue;
                Date changed = me.getValue();
                logger.debug("onCommit: setChanged({}) for {}", (Object)changed, pc);
                AutoTrackChanged entity = (AutoTrackChanged)pc;
                entity.setChanged(changed);
            }
            catch (JDOObjectNotFoundException x) {
                logger.warn("onCommit: " + (Object)((Object)x), (Throwable)x);
            }
        }
        int oid2LastChangedSize = this.oid2LastChanged.size();
        this.oid2LastChanged.clear();
        long duration = ChronosUtil.nowAsMillis() - start;
        if (duration >= 500L) {
            logger.info("onCommit: Deferred operations took {} ms for {} entities.", (Object)duration, (Object)oid2LastChangedSize);
        } else {
            logger.debug("onCommit: Deferred operations took {} ms for {} entities.", (Object)duration, (Object)oid2LastChangedSize);
        }
    }

    public void onRollback() {
        this.defer = false;
        this.oid2LastChanged.clear();
    }
}

