/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.client;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.concurrent.DeferredCompletionException;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RemoteException;
import co.codewizards.cloudstore.core.dto.RemoteExceptionUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.LocalServerPropertiesManager;
import co.codewizards.cloudstore.ls.core.provider.JavaNativeMessageBodyReader;
import co.codewizards.cloudstore.ls.core.provider.JavaNativeMessageBodyWriter;
import co.codewizards.cloudstore.ls.rest.client.CloudStoreJaxbContextResolver;
import co.codewizards.cloudstore.ls.rest.client.CredentialsProvider;
import co.codewizards.cloudstore.ls.rest.client.request.Request;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServerRestClient {
    private static final Logger logger = LoggerFactory.getLogger(LocalServerRestClient.class);
    private static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_READ_TIMEOUT = 180000;
    public static final String CONFIG_KEY_SOCKET_CONNECT_TIMEOUT = "localServer.socket.connectTimeout";
    public static final String CONFIG_KEY_SOCKET_READ_TIMEOUT = "localServer.socket.readTimeout";
    private Integer socketConnectTimeout;
    private Integer socketReadTimeout;
    private String baseUrl;
    private final LinkedList<Client> clientCache = new LinkedList();
    private CredentialsProvider credentialsProvider;
    private final ThreadLocal<ClientRef> clientThreadLocal = new ThreadLocal();
    private final List<Object> restComponents = new CopyOnWriteArrayList<Object>();

    public static LocalServerRestClient getInstance() {
        return Holder.instance;
    }

    public synchronized Integer getSocketConnectTimeout() {
        if (this.socketConnectTimeout == null) {
            this.socketConnectTimeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_SOCKET_CONNECT_TIMEOUT, 30000);
        }
        return this.socketConnectTimeout;
    }

    public synchronized void setSocketConnectTimeout(Integer socketConnectTimeout) {
        if (socketConnectTimeout != null && socketConnectTimeout < 0) {
            socketConnectTimeout = null;
        }
        this.socketConnectTimeout = socketConnectTimeout;
    }

    public synchronized Integer getSocketReadTimeout() {
        if (this.socketReadTimeout == null) {
            this.socketReadTimeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_SOCKET_READ_TIMEOUT, 180000);
        }
        return this.socketReadTimeout;
    }

    public synchronized void setSocketReadTimeout(Integer socketReadTimeout) {
        if (socketReadTimeout != null && socketReadTimeout < 0) {
            socketReadTimeout = null;
        }
        this.socketReadTimeout = socketReadTimeout;
    }

    public synchronized String getBaseUrl() {
        if (this.baseUrl == null) {
            this.baseUrl = LocalServerPropertiesManager.getInstance().getBaseUrl();
        }
        return this.baseUrl;
    }

    protected LocalServerRestClient() {
        final String clientId = new Uid().toString();
        this.setCredentialsProvider(new CredentialsProvider(){

            @Override
            public String getUserName() {
                return clientId;
            }

            @Override
            public String getPassword() {
                return LocalServerPropertiesManager.getInstance().getPassword();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <R> R execute(Request<R> request) {
        Objects.requireNonNull(request, "request");
        RuntimeException firstException = null;
        int retryCounter = 0;
        boolean retryMax = true;
        while (true) {
            this.acquireClient();
            long start = ChronosUtil.nowAsMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("execute: starting try {} of {}", (Object)(retryCounter + 1), (Object)2);
            }
            request.setLocalServerRestClient(this);
            R result = request.execute();
            if (logger.isDebugEnabled()) {
                logger.debug("execute: invocation took {} ms", (Object)(ChronosUtil.nowAsMillis() - start));
            }
            if (result == null && !request.isResultNullable()) {
                throw new IllegalStateException("result == null, but request.resultNullable == false!");
            }
            R r = result;
            this.releaseClient();
            request.setLocalServerRestClient(null);
            return r;
            {
                catch (RuntimeException x) {
                    try {
                        if (firstException == null) {
                            firstException = x;
                        }
                        String oldBaseUrl = this.getBaseUrl();
                        this.baseUrl = null;
                        if (!oldBaseUrl.equals(this.getBaseUrl())) {
                            retryCounter = 0;
                            this.clearClientCache();
                        }
                        this.markClientBroken();
                        if (++retryCounter > 1 || !this.retryExecuteAfterException(x)) {
                            logger.warn("execute: invocation failed (will NOT retry): " + x, (Throwable)x);
                            this.handleAndRethrowException(firstException);
                            throw firstException;
                        }
                        logger.warn("execute: invocation failed (will retry): " + x, (Throwable)x);
                        try {
                            Thread.sleep((long)retryCounter * 1000L);
                        }
                        catch (Exception y) {
                            Util.doNothing();
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.releaseClient();
                        request.setLocalServerRestClient(null);
                        continue;
                    }
                }
            }
            break;
        }
    }

    private synchronized void clearClientCache() {
        this.clientCache.clear();
    }

    private boolean retryExecuteAfterException(Exception x) {
        return true;
    }

    public Invocation.Builder assignCredentials(Invocation.Builder builder) {
        CredentialsProvider credentialsProvider = this.getCredentialsProviderOrFail();
        builder.property("jersey.config.client.http.auth.basic.username", (Object)credentialsProvider.getUserName());
        builder.property("jersey.config.client.http.auth.basic.password", (Object)credentialsProvider.getPassword());
        return builder;
    }

    private synchronized void acquireClient() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef != null) {
            ++clientRef.refCount;
            return;
        }
        Client client = this.clientCache.poll();
        if (client == null) {
            ClientConfig clientConfig = new ClientConfig(new Class[]{CloudStoreJaxbContextResolver.class});
            clientConfig.property("jersey.config.client.connectTimeout", (Object)this.getSocketConnectTimeout());
            clientConfig.property("jersey.config.client.readTimeout", (Object)this.getSocketReadTimeout());
            ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig);
            clientBuilder.register(JavaNativeMessageBodyReader.class);
            clientBuilder.register(JavaNativeMessageBodyWriter.class);
            for (Object restComponent : this.restComponents) {
                if (restComponent instanceof Class) {
                    clientBuilder.register((Class)restComponent);
                    continue;
                }
                clientBuilder.register(restComponent);
            }
            client = clientBuilder.build();
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)"anonymous", (String)"");
            client.register((Object)feature);
        }
        this.clientThreadLocal.set(new ClientRef(client));
    }

    public void registerRestComponent(Object restComponent) {
        this.restComponents.add(restComponent);
    }

    public Client getClientOrFail() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() already called)!");
        }
        return clientRef.client;
    }

    private synchronized void releaseClient() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() called more often than acquireClient())!");
        }
        if (--clientRef.refCount == 0) {
            this.clientThreadLocal.remove();
            if (!clientRef.broken) {
                this.clientCache.add(clientRef.client);
            }
        }
    }

    private void markClientBroken() {
        ClientRef clientRef = this.clientThreadLocal.get();
        if (clientRef == null) {
            throw new IllegalStateException("acquireClient() not called on the same thread (or releaseClient() called more often than acquireClient())!");
        }
        clientRef.broken = true;
    }

    public void handleAndRethrowException(RuntimeException x) {
        Response response = null;
        if (x instanceof WebApplicationException) {
            response = ((WebApplicationException)x).getResponse();
        } else if (x instanceof ResponseProcessingException) {
            response = ((ResponseProcessingException)x).getResponse();
        }
        if (response == null) {
            throw x;
        }
        Error error = null;
        try {
            response.bufferEntity();
            if (response.hasEntity()) {
                error = (Error)response.readEntity(Error.class);
            }
            if (error != null && DeferredCompletionException.class.getName().equals(error.getClassName())) {
                logger.debug("handleException: " + x, (Throwable)x);
            } else {
                logger.error("handleException: " + x, (Throwable)x);
            }
        }
        catch (Exception y) {
            logger.error("handleException: " + x, (Throwable)x);
            logger.error("handleException: " + y, (Throwable)y);
        }
        if (error != null) {
            RemoteExceptionUtil.throwOriginalExceptionIfPossible((Error)error);
            throw new RemoteException(error);
        }
        throw x;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    private CredentialsProvider getCredentialsProviderOrFail() {
        CredentialsProvider credentialsProvider = this.getCredentialsProvider();
        if (credentialsProvider == null) {
            throw new IllegalStateException("credentialsProvider == null");
        }
        return credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    private static class ClientRef {
        public final Client client;
        public int refCount = 1;
        public boolean broken;

        public ClientRef(Client client) {
            this.client = Objects.requireNonNull(client, "client");
        }
    }

    private static final class Holder {
        public static final LocalServerRestClient instance = new LocalServerRestClient();

        private Holder() {
        }
    }
}

