/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.chronos;

import co.codewizards.cloudstore.core.chronos.AbstractChronos;
import java.util.Calendar;

public class DefaultChronosImpl
extends AbstractChronos {
    public static final String ENV_TEST_YEAR = "TEST_YEAR";

    public static Integer getTestYear() {
        String s = System.getenv(ENV_TEST_YEAR);
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException x) {
            NumberFormatException y = new NumberFormatException(String.format("Env-var '%s' contains illegal value '%s'!", ENV_TEST_YEAR, s));
            y.initCause(x);
            throw y;
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public long nowAsMillis() {
        Integer testYear = DefaultChronosImpl.getTestYear();
        if (testYear != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(1, testYear);
            return cal.getTimeInMillis();
        }
        return System.currentTimeMillis();
    }
}

