/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.FetchPlanBackup;
import co.codewizards.cloudstore.local.persistence.Modification;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import java.util.Collection;
import java.util.Objects;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationDao
extends Dao<Modification, ModificationDao> {
    private static final Logger logger = LoggerFactory.getLogger(ModificationDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModificationsAfter(RemoteRepository remoteRepository, long localRevision) {
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom(pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getModificationsAfter_remoteRepository_localRevision");
        try {
            this.clearFetchGroups();
            long startTimestamp = ChronosUtil.nowAsMillis();
            Collection<Modification> modifications = (Collection<Modification>)query.execute((Object)remoteRepository, (Object)localRevision);
            logger.debug("getModificationsAfter: query.execute(...) took {} ms.", (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = ChronosUtil.nowAsMillis();
            modifications = this.load(modifications);
            logger.debug("getModificationsAfter: Loading result-set with {} elements took {} ms.", (Object)modifications.size(), (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            Collection<Modification> collection = modifications;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Modification> getModificationsBeforeOrEqual(RemoteRepository remoteRepository, long localRevision) {
        Objects.requireNonNull(remoteRepository, "remoteRepository");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom(pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getModificationsBeforeOrEqual_remoteRepository_localRevision");
        try {
            this.clearFetchGroups();
            long startTimestamp = ChronosUtil.nowAsMillis();
            Collection<Modification> modifications = (Collection<Modification>)query.execute((Object)remoteRepository, (Object)localRevision);
            logger.debug("getModificationsBeforeOrEqual: query.execute(...) took {} ms.", (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = ChronosUtil.nowAsMillis();
            modifications = this.load(modifications);
            logger.debug("getModificationsBeforeOrEqual: Loading result-set with {} elements took {} ms.", (Object)modifications.size(), (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            Collection<Modification> collection = modifications;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    public Collection<Modification> getModifications(RemoteRepository remoteRepository) {
        return this.getModificationsAfter(remoteRepository, -1L);
    }
}

