/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.rest.server;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.dto.Error;
import co.codewizards.cloudstore.core.dto.RemoteException;
import co.codewizards.cloudstore.core.dto.RemoteExceptionUtil;
import co.codewizards.cloudstore.core.io.TimeoutException;
import co.codewizards.cloudstore.core.util.ExceptionUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.dto.ErrorResponse;
import co.codewizards.cloudstore.ls.core.dto.InverseServiceRequest;
import co.codewizards.cloudstore.ls.core.dto.InverseServiceResponse;
import co.codewizards.cloudstore.ls.core.dto.NullResponse;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfo;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfoMap;
import co.codewizards.cloudstore.ls.core.invoke.ClassManager;
import co.codewizards.cloudstore.ls.core.invoke.DelayedMethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.IncDecRefCountQueue;
import co.codewizards.cloudstore.ls.core.invoke.InverseMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.InverseMethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.Invoker;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationResponse;
import co.codewizards.cloudstore.ls.core.invoke.ObjectManager;
import co.codewizards.cloudstore.ls.core.invoke.ObjectRef;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxy;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyFactory;
import co.codewizards.cloudstore.ls.core.invoke.RemoteObjectProxyInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InverseInvoker
implements Invoker {
    private static final long POLL_INVERSE_SERVICE_REQUEST_TIMEOUT_MS = 15000L;
    private static final long PERFORM_INVERSE_SERVICE_REQUEST_TIMEOUT_MS = 180000L;
    private final IncDecRefCountQueue incDecRefCountQueue = new IncDecRefCountQueue((Invoker)this);
    private final ObjectManager objectManager;
    private final LinkedList<InverseServiceRequest> inverseServiceRequests = new LinkedList();
    private final Set<Uid> requestIdsWaitingForResponse = new HashSet<Uid>();
    private final Map<Uid, InverseServiceResponse> requestId2InverseServiceResponse = new HashMap<Uid, InverseServiceResponse>();
    private final ClassInfoMap classInfoMap = new ClassInfoMap();
    private volatile boolean diedOfTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InverseInvoker getInverseInvoker(ObjectManager objectManager) {
        Objects.requireNonNull(objectManager, "objectManager");
        ObjectManager objectManager2 = objectManager;
        synchronized (objectManager2) {
            InverseInvoker inverseInvoker = (InverseInvoker)objectManager.getContextObject(InverseInvoker.class.getName());
            if (inverseInvoker == null) {
                inverseInvoker = new InverseInvoker(objectManager);
                objectManager.putContextObject(InverseInvoker.class.getName(), (Object)inverseInvoker);
            }
            return inverseInvoker;
        }
    }

    private InverseInvoker(ObjectManager objectManager) {
        this.objectManager = Objects.requireNonNull(objectManager, "objectManager");
    }

    public ObjectManager getObjectManager() {
        return this.objectManager;
    }

    public <T> T invokeStatic(Class<?> clazz, String methodName, Object ... arguments) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(methodName, "methodName");
        return this.invokeStatic(clazz.getName(), methodName, (String[])null, arguments);
    }

    public <T> T invokeStatic(String className, String methodName, Object ... arguments) {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(methodName, "methodName");
        return this.invokeStatic(className, methodName, (String[])null, arguments);
    }

    public <T> T invokeStatic(Class<?> clazz, String methodName, Class<?>[] argumentTypes, Object ... arguments) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(methodName, "methodName");
        return this.invokeStatic(clazz.getName(), methodName, this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invokeStatic(String className, String methodName, String[] argumentTypeNames, Object ... arguments) {
        Objects.requireNonNull(className, "className");
        Objects.requireNonNull(methodName, "methodName");
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forStaticInvocation((String)className, (String)methodName, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    public <T> T invokeConstructor(Class<T> clazz, Object ... arguments) {
        Objects.requireNonNull(clazz, "clazz");
        return this.invokeConstructor(clazz.getName(), (String[])null, arguments);
    }

    public <T> T invokeConstructor(String className, Object ... arguments) {
        Objects.requireNonNull(className, "className");
        return this.invokeConstructor(className, (String[])null, arguments);
    }

    public <T> T invokeConstructor(Class<T> clazz, Class<?>[] argumentTypes, Object ... arguments) {
        Objects.requireNonNull(clazz, "clazz");
        return this.invokeConstructor(clazz.getName(), this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invokeConstructor(String className, String[] argumentTypeNames, Object ... arguments) {
        Objects.requireNonNull(className, "className");
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forConstructorInvocation((String)className, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    public <T> T invoke(Object object, String methodName, Object ... arguments) {
        Objects.requireNonNull(object, "object");
        Objects.requireNonNull(methodName, "methodName");
        if (!(object instanceof RemoteObjectProxy)) {
            throw new IllegalArgumentException("object is not an instance of RemoteObjectProxy!");
        }
        return this.invoke(object, methodName, (Class[])null, arguments);
    }

    public <T> T invoke(Object object, String methodName, Class<?>[] argumentTypes, Object ... arguments) {
        Objects.requireNonNull(object, "object");
        Objects.requireNonNull(methodName, "methodName");
        return this.invoke(object, methodName, this.toClassNames(argumentTypes), arguments);
    }

    public <T> T invoke(Object object, String methodName, String[] argumentTypeNames, Object ... arguments) {
        Objects.requireNonNull(object, "object");
        Objects.requireNonNull(methodName, "methodName");
        MethodInvocationRequest methodInvocationRequest = MethodInvocationRequest.forObjectInvocation((Object)object, (String)methodName, (String[])argumentTypeNames, (Object[])arguments);
        return this.invoke(methodInvocationRequest);
    }

    private <T> T invoke(MethodInvocationRequest methodInvocationRequest) {
        Objects.requireNonNull(methodInvocationRequest, "methodInvocationRequest");
        InverseMethodInvocationResponse inverseMethodInvocationResponse = (InverseMethodInvocationResponse)this.performInverseServiceRequest((InverseServiceRequest)new InverseMethodInvocationRequest(methodInvocationRequest));
        Objects.requireNonNull(inverseMethodInvocationResponse, "inverseMethodInvocationResponse");
        MethodInvocationResponse methodInvocationResponse = inverseMethodInvocationResponse.getMethodInvocationResponse();
        while (methodInvocationResponse instanceof DelayedMethodInvocationResponse) {
            DelayedMethodInvocationResponse dmir = (DelayedMethodInvocationResponse)methodInvocationResponse;
            Uid delayedResponseId = dmir.getDelayedResponseId();
            inverseMethodInvocationResponse = (InverseMethodInvocationResponse)this.performInverseServiceRequest((InverseServiceRequest)new InverseMethodInvocationRequest(delayedResponseId));
            Objects.requireNonNull(inverseMethodInvocationResponse, "inverseMethodInvocationResponse");
            methodInvocationResponse = inverseMethodInvocationResponse.getMethodInvocationResponse();
        }
        Object result = methodInvocationResponse.getResult();
        return (T)Util.cast((Object)result);
    }

    public void incRefCount(ObjectRef objectRef, Uid refId) {
        this.incDecRefCountQueue.incRefCount(objectRef, refId);
    }

    public void decRefCount(ObjectRef objectRef, Uid refId) {
        this.incDecRefCountQueue.decRefCount(objectRef, refId);
    }

    private String[] toClassNames(Class<?> ... classes) {
        String[] classNames;
        if (classes == null) {
            classNames = null;
        } else {
            classNames = new String[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                classNames[i] = classes[i].getName();
            }
        }
        return classNames;
    }

    public Object getRemoteObjectProxyOrCreate(ObjectRef objectRef) {
        return this.objectManager.getRemoteObjectProxyManager().getRemoteObjectProxyOrCreate(objectRef, new RemoteObjectProxyFactory(){

            public RemoteObjectProxy createRemoteObjectProxy(ObjectRef objectRef) {
                return InverseInvoker.this._createRemoteObjectProxy(objectRef);
            }
        });
    }

    private RemoteObjectProxy _createRemoteObjectProxy(ObjectRef objectRef) {
        Class<?>[] interfaces = this.getInterfaces(objectRef);
        ClassLoader classLoader = this.getClass().getClassLoader();
        return (RemoteObjectProxy)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new RemoteObjectProxyInvocationHandler((Invoker)this, objectRef));
    }

    private Class<?>[] getInterfaces(ObjectRef objectRef) {
        ClassInfo classInfo = this.classInfoMap.getClassInfo(objectRef.getClassId());
        if (classInfo == null) {
            classInfo = objectRef.getClassInfo();
            if (classInfo == null) {
                throw new IllegalStateException("There is no ClassInfo in the ClassInfoMap and neither in the ObjectRef! " + objectRef);
            }
            this.classInfoMap.putClassInfo(classInfo);
            objectRef.setClassInfo(null);
        }
        ClassManager classManager = this.objectManager.getClassManager();
        Set interfaceNames = classInfo.getInterfaceNames();
        ArrayList<Class<RemoteObjectProxy>> interfaces = new ArrayList<Class<RemoteObjectProxy>>(interfaceNames.size() + 1);
        for (String interfaceName : interfaceNames) {
            Class iface;
            block5: {
                iface = null;
                try {
                    iface = classManager.getClassOrFail(interfaceName);
                }
                catch (RuntimeException x) {
                    if (ExceptionUtil.getCause((Throwable)x, ClassNotFoundException.class) != null) break block5;
                    throw x;
                }
            }
            if (iface == null) continue;
            interfaces.add(iface);
        }
        interfaces.add(RemoteObjectProxy.class);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T extends InverseServiceResponse> T performInverseServiceRequest(InverseServiceRequest request) throws TimeoutException {
        Object object;
        T t;
        InverseServiceResponse response;
        Objects.requireNonNull(request, "request");
        if (this.diedOfTimeout) {
            throw new IllegalStateException(String.format("InverseInvoker[%s] died of timeout, already!", this.objectManager.getClientId()));
        }
        Uid requestId = request.getRequestId();
        Objects.requireNonNull(requestId, "request.requestId");
        Object object2 = this.requestId2InverseServiceResponse;
        // MONITORENTER : object2
        if (!this.requestIdsWaitingForResponse.add(requestId)) {
            throw new IllegalStateException("requestId already queued: " + requestId);
        }
        // MONITOREXIT : object2
        try {
            object2 = this.inverseServiceRequests;
            // MONITORENTER : object2
            this.inverseServiceRequests.add(request);
            this.inverseServiceRequests.notify();
            // MONITOREXIT : object2
            long startTimestamp = ChronosUtil.nowAsMillis();
            Map<Uid, InverseServiceResponse> map = this.requestId2InverseServiceResponse;
            // MONITORENTER : map
            boolean first = true;
            while (first || ChronosUtil.nowAsMillis() - startTimestamp < 180000L) {
                if (first) {
                    first = false;
                } else {
                    long timeSpentTillNowMillis = ChronosUtil.nowAsMillis() - startTimestamp;
                    long waitTimeout = 180000L - timeSpentTillNowMillis;
                    if (waitTimeout > 0L) {
                        try {
                            this.requestId2InverseServiceResponse.wait(waitTimeout);
                        }
                        catch (InterruptedException e) {
                            Util.doNothing();
                        }
                    }
                }
                response = this.requestId2InverseServiceResponse.remove(requestId);
                if (response == null) break block37;
                if (!(response instanceof NullResponse)) break block38;
                t = null;
                // MONITOREXIT : map
                object = this.requestId2InverseServiceResponse;
            }
        }
        catch (Throwable throwable) {
            Object object3 = this.requestId2InverseServiceResponse;
            // MONITORENTER : object3
            boolean requestWasStillWaiting = this.requestIdsWaitingForResponse.remove(requestId);
            this.requestId2InverseServiceResponse.remove(requestId);
            // MONITOREXIT : object3
            if (!requestWasStillWaiting) throw throwable;
            object3 = this.inverseServiceRequests;
            // MONITORENTER : object3
            this.inverseServiceRequests.remove(request);
            // MONITOREXIT : object3
            throw throwable;
        }
        {
            block37: {
                InverseServiceResponse t2;
                block38: {
                    // MONITORENTER : object
                    boolean requestWasStillWaiting = this.requestIdsWaitingForResponse.remove(requestId);
                    this.requestId2InverseServiceResponse.remove(requestId);
                    // MONITOREXIT : object
                    if (!requestWasStillWaiting) return t;
                    object = this.inverseServiceRequests;
                    // MONITORENTER : object
                    this.inverseServiceRequests.remove(request);
                    // MONITOREXIT : object
                    return t;
                }
                if (response instanceof ErrorResponse) {
                    Error error = ((ErrorResponse)response).getError();
                    RemoteExceptionUtil.throwOriginalExceptionIfPossible((Error)error);
                    throw new RemoteException(error);
                }
                InverseServiceResponse inverseServiceResponse = t2 = response;
                // MONITOREXIT : map
                Object object4 = this.requestId2InverseServiceResponse;
                // MONITORENTER : object4
                boolean requestWasStillWaiting = this.requestIdsWaitingForResponse.remove(requestId);
                this.requestId2InverseServiceResponse.remove(requestId);
                // MONITOREXIT : object4
                if (!requestWasStillWaiting) return (T)inverseServiceResponse;
                object4 = this.inverseServiceRequests;
                // MONITORENTER : object4
                this.inverseServiceRequests.remove(request);
                // MONITOREXIT : object4
                return (T)inverseServiceResponse;
            }
            continue;
        }
        Object object5 = this.requestId2InverseServiceResponse;
        // MONITORENTER : object5
        boolean requestWasStillWaiting = this.requestIdsWaitingForResponse.remove(requestId);
        this.requestId2InverseServiceResponse.remove(requestId);
        // MONITOREXIT : object5
        if (requestWasStillWaiting) {
            object5 = this.inverseServiceRequests;
            // MONITORENTER : object5
            this.inverseServiceRequests.remove(request);
            // MONITOREXIT : object5
        }
        if (!request.isTimeoutDeadly()) throw new TimeoutException(String.format("InverseInvoker[%s] encountered timeout while waiting for response matching requestId=%s! diedOfTimeout=%s", this.objectManager.getClientId(), requestId, this.diedOfTimeout));
        this.diedOfTimeout = true;
        throw new TimeoutException(String.format("InverseInvoker[%s] encountered timeout while waiting for response matching requestId=%s! diedOfTimeout=%s", this.objectManager.getClientId(), requestId, this.diedOfTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InverseServiceRequest pollInverseServiceRequest() {
        long startTimestamp = ChronosUtil.nowAsMillis();
        LinkedList<InverseServiceRequest> linkedList = this.inverseServiceRequests;
        synchronized (linkedList) {
            boolean first = true;
            while (first || ChronosUtil.nowAsMillis() - startTimestamp < 15000L) {
                InverseServiceRequest request;
                if (first) {
                    first = false;
                } else {
                    long timeSpentTillNowMillis = ChronosUtil.nowAsMillis() - startTimestamp;
                    long waitTimeout = 15000L - timeSpentTillNowMillis;
                    if (waitTimeout > 0L) {
                        try {
                            this.inverseServiceRequests.wait(waitTimeout);
                        }
                        catch (InterruptedException e) {
                            Util.doNothing();
                        }
                    }
                }
                if ((request = this.inverseServiceRequests.poll()) == null) continue;
                return request;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushInverseServiceResponse(InverseServiceResponse response) {
        Objects.requireNonNull(response, "response");
        Uid requestId = response.getRequestId();
        Objects.requireNonNull(requestId, "response.requestId");
        Map<Uid, InverseServiceResponse> map = this.requestId2InverseServiceResponse;
        synchronized (map) {
            if (!this.requestIdsWaitingForResponse.contains(requestId)) {
                throw new IllegalArgumentException(String.format("response.requestId=%s does not match any waiting request!", requestId));
            }
            this.requestId2InverseServiceResponse.put(requestId, response);
            this.requestId2InverseServiceResponse.notifyAll();
        }
    }

    public ClassInfoMap getClassInfoMap() {
        return this.classInfoMap;
    }
}

