/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto.jaxb;

import co.codewizards.cloudstore.core.dto.jaxb.CloudStoreJaxbContext;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.NoCloseInputStream;
import co.codewizards.cloudstore.core.io.NoCloseOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class DtoIo<D> {
    private final Class<D> dtoClass;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    protected DtoIo() {
        Class c;
        ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] actualTypeArguments = superclass.getActualTypeArguments();
        if (actualTypeArguments == null || actualTypeArguments.length < 1) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        this.dtoClass = c = (Class)actualTypeArguments[0];
        if (this.dtoClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
    }

    public byte[] serialize(D dto) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(dto, out);
        return out.toByteArray();
    }

    public void serialize(D dto, OutputStream out) {
        Objects.requireNonNull(dto, "dto");
        Objects.requireNonNull(out, "out");
        try {
            this.getMarshaller().marshal(dto, (OutputStream)new NoCloseOutputStream(out));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] serializeWithGz(D dto) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeWithGz(dto, out);
        return out.toByteArray();
    }

    public void serializeWithGz(D dto, OutputStream out) {
        Objects.requireNonNull(dto, "dto");
        Objects.requireNonNull(out, "out");
        try (GZIPOutputStream gzOut = new GZIPOutputStream(new NoCloseOutputStream(out));){
            this.getMarshaller().marshal(dto, (OutputStream)gzOut);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(D dto, File file) {
        Objects.requireNonNull(dto, "dto");
        Objects.requireNonNull(file, "file");
        try (BufferedOutputStream out = new BufferedOutputStream(StreamUtil.castStream(file.createOutputStream()));){
            this.getMarshaller().marshal(dto, (OutputStream)out);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Writing file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    public void serializeWithGz(D dto, File file) {
        Objects.requireNonNull(dto, "dto");
        Objects.requireNonNull(file, "file");
        try (BufferedOutputStream out = new BufferedOutputStream(StreamUtil.castStream(file.createOutputStream()));
             GZIPOutputStream gzOut = new GZIPOutputStream(out);){
            this.getMarshaller().marshal(dto, (OutputStream)gzOut);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Writing file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    public D deserialize(byte[] in) {
        Objects.requireNonNull(in, "in");
        return this.deserialize(new ByteArrayInputStream(in));
    }

    public D deserialize(InputStream in) {
        Objects.requireNonNull(in, "in");
        try {
            return this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)new NoCloseInputStream(in)));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public D deserializeWithGz(byte[] in) {
        Objects.requireNonNull(in, "in");
        return this.deserializeWithGz(new ByteArrayInputStream(in));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D deserializeWithGz(InputStream in) {
        Objects.requireNonNull(in, "in");
        try (GZIPInputStream gzIn = new GZIPInputStream(new NoCloseInputStream(in));){
            D d = this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)gzIn));
            return d;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public D deserialize(File file) {
        Objects.requireNonNull(file, "file");
        try (BufferedInputStream in = new BufferedInputStream(StreamUtil.castStream(file.createInputStream()));){
            D d = this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)in));
            return d;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Reading file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public D deserializeWithGz(File file) {
        Objects.requireNonNull(file, "file");
        try (BufferedInputStream in = new BufferedInputStream(StreamUtil.castStream(file.createInputStream()));){
            D d;
            try (GZIPInputStream gzIn = new GZIPInputStream(in);){
                d = this.dtoClass.cast(this.getUnmarshaller().unmarshal((InputStream)gzIn));
            }
            return d;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Reading file '" + file.getAbsolutePath() + "' failed: " + e, e);
        }
    }

    private Marshaller getMarshaller() {
        if (this.marshaller == null) {
            try {
                this.marshaller = CloudStoreJaxbContext.getJaxbContext().createMarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.marshaller;
    }

    private Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            try {
                this.unmarshaller = CloudStoreJaxbContext.getJaxbContext().createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.unmarshaller;
    }
}

