/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.auth;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.dto.DateTime;
import co.codewizards.cloudstore.core.util.PasswordUtil;
import co.codewizards.cloudstore.rest.server.auth.TransientRepoPassword;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;

public class TransientRepoPasswordManager {
    private static final int DEFAULT_VALIDITIY_PERIOD = 3600000;
    private static final int DEFAULT_RENEWAL_PERIOD = 1800000;
    private static final int DEFAULT_EARLY_RENEWAL_PERIOD = 900000;
    private static final int DEFAULT_EXPIRY_TIMER_PERIOD = 60000;
    public static final String CONFIG_KEY_VALIDITIY_PERIOD = "transientRepoPassword.validityPeriod";
    public static final String CONFIG_KEY_RENEWAL_PERIOD = "transientRepoPassword.renewalPeriod";
    public static final String CONFIG_KEY_EARLY_RENEWAL_PERIOD = "transientRepoPassword.earlyRenewalPeriod";
    public static final String CONFIG_KEY_EXPIRY_TIMER_PERIOD = "transientRepoPassword.expiryTimerPeriod";
    private int validityPeriod = Integer.MIN_VALUE;
    private int renewalPeriod = Integer.MIN_VALUE;
    private int earlyRenewalPeriod = Integer.MIN_VALUE;
    private int expiryTimerPeriod = Integer.MIN_VALUE;
    private final Map<UUID, Map<UUID, SortedSet<TransientRepoPassword>>> serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet = new HashMap<UUID, Map<UUID, SortedSet<TransientRepoPassword>>>();
    private final SortedSet<TransientRepoPassword> transientRepoPasswords = new TreeSet<TransientRepoPassword>(newestFirstAuthRepoPasswordComparator);
    private final Timer timer = new Timer();
    private final TimerTask removeExpiredAuthRepoPasswordsTimerTask = new TimerTask(){

        @Override
        public void run() {
            TransientRepoPasswordManager.this.removeExpiredAuthRepoPasswords();
        }
    };
    private static final Comparator<TransientRepoPassword> newestFirstAuthRepoPasswordComparator = new Comparator<TransientRepoPassword>(){

        @Override
        public int compare(TransientRepoPassword o1, TransientRepoPassword o2) {
            Date expiryDate2;
            Date expiryDate1 = o1.getAuthToken().getExpiryDateTime().toDate();
            if (expiryDate1.before(expiryDate2 = o2.getAuthToken().getExpiryDateTime().toDate())) {
                return 1;
            }
            if (expiryDate1.after(expiryDate2)) {
                return -1;
            }
            int result = o1.getServerRepositoryId().compareTo(o2.getServerRepositoryId());
            if (result != 0) {
                return result;
            }
            result = o1.getClientRepositoryId().compareTo(o2.getClientRepositoryId());
            return result;
        }
    };

    protected TransientRepoPasswordManager() {
        this.timer.schedule(this.removeExpiredAuthRepoPasswordsTimerTask, this.getExpiryTimerPeriod(), (long)this.getExpiryTimerPeriod());
    }

    public static TransientRepoPasswordManager getInstance() {
        return TransientRepoPasswordManagerHolder.instance;
    }

    public synchronized TransientRepoPassword getCurrentAuthRepoPassword(UUID serverRepositoryId, UUID clientRepositoryId) {
        TransientRepoPassword transientRepoPassword;
        SortedSet<TransientRepoPassword> authRepoPasswordSet;
        Objects.requireNonNull(serverRepositoryId, "serverRepositoryId");
        Objects.requireNonNull(clientRepositoryId, "clientRepositoryId");
        Map<UUID, SortedSet<TransientRepoPassword>> clientRepositoryId2AuthRepoPasswordSet = this.serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet.get(serverRepositoryId);
        if (clientRepositoryId2AuthRepoPasswordSet == null) {
            clientRepositoryId2AuthRepoPasswordSet = new HashMap<UUID, SortedSet<TransientRepoPassword>>();
            this.serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet.put(serverRepositoryId, clientRepositoryId2AuthRepoPasswordSet);
        }
        if ((authRepoPasswordSet = clientRepositoryId2AuthRepoPasswordSet.get(clientRepositoryId)) == null) {
            authRepoPasswordSet = new TreeSet<TransientRepoPassword>(newestFirstAuthRepoPasswordComparator);
            clientRepositoryId2AuthRepoPasswordSet.put(clientRepositoryId, authRepoPasswordSet);
        }
        TransientRepoPassword transientRepoPassword2 = transientRepoPassword = authRepoPasswordSet.isEmpty() ? null : authRepoPasswordSet.first();
        if (transientRepoPassword != null && this.isAfterRenewalDateOrInEarlyRenewalPeriod(transientRepoPassword)) {
            transientRepoPassword = null;
        }
        if (transientRepoPassword == null) {
            transientRepoPassword = new TransientRepoPassword(serverRepositoryId, clientRepositoryId, this.createAuthToken());
            authRepoPasswordSet.add(transientRepoPassword);
            this.transientRepoPasswords.add(transientRepoPassword);
        }
        return transientRepoPassword;
    }

    public synchronized boolean isPasswordValid(UUID serverRepositoryId, UUID clientRepositoryId, char[] password) {
        Objects.requireNonNull(serverRepositoryId, "serverRepositoryId");
        Objects.requireNonNull(clientRepositoryId, "clientRepositoryId");
        Objects.requireNonNull(password, "password");
        Map<UUID, SortedSet<TransientRepoPassword>> clientRepositoryId2AuthRepoPasswordSet = this.serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet.get(serverRepositoryId);
        if (clientRepositoryId2AuthRepoPasswordSet == null) {
            return false;
        }
        SortedSet<TransientRepoPassword> authRepoPasswordSet = clientRepositoryId2AuthRepoPasswordSet.get(clientRepositoryId);
        if (authRepoPasswordSet == null) {
            return false;
        }
        for (TransientRepoPassword transientRepoPassword : authRepoPasswordSet) {
            if (this.isExpired(transientRepoPassword)) {
                return false;
            }
            if (!Arrays.equals(password, transientRepoPassword.getPassword())) continue;
            return true;
        }
        return false;
    }

    private synchronized void removeExpiredAuthRepoPasswords() {
        TransientRepoPassword oldestAuthRepoPassword;
        while (!this.transientRepoPasswords.isEmpty() && this.isExpired(oldestAuthRepoPassword = this.transientRepoPasswords.last())) {
            this.transientRepoPasswords.remove(oldestAuthRepoPassword);
            UUID serverRepositoryId = oldestAuthRepoPassword.getServerRepositoryId();
            UUID clientRepositoryId = oldestAuthRepoPassword.getClientRepositoryId();
            Map<UUID, SortedSet<TransientRepoPassword>> clientRepositoryId2AuthRepoPasswordSet = this.serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet.get(serverRepositoryId);
            Objects.requireNonNull(clientRepositoryId2AuthRepoPasswordSet, "clientRepositoryId2AuthRepoPasswordSet");
            SortedSet<TransientRepoPassword> authRepoPasswordSet = clientRepositoryId2AuthRepoPasswordSet.get(clientRepositoryId);
            Objects.requireNonNull(authRepoPasswordSet, "authRepoPasswordSet");
            authRepoPasswordSet.remove(oldestAuthRepoPassword);
            if (authRepoPasswordSet.isEmpty()) {
                clientRepositoryId2AuthRepoPasswordSet.remove(clientRepositoryId);
            }
            if (!clientRepositoryId2AuthRepoPasswordSet.isEmpty()) continue;
            this.serverRepositoryId2ClientRepositoryId2AuthRepoPasswordSet.remove(serverRepositoryId);
        }
    }

    protected int getValidityPeriod() {
        if (this.validityPeriod == Integer.MIN_VALUE) {
            this.validityPeriod = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_VALIDITIY_PERIOD, 3600000);
        }
        return this.validityPeriod;
    }

    protected int getRenewalPeriod() {
        if (this.renewalPeriod == Integer.MIN_VALUE) {
            this.renewalPeriod = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_RENEWAL_PERIOD, 1800000);
        }
        return this.renewalPeriod;
    }

    protected int getEarlyRenewalPeriod() {
        if (this.earlyRenewalPeriod == Integer.MIN_VALUE) {
            this.earlyRenewalPeriod = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_EARLY_RENEWAL_PERIOD, 900000);
        }
        return this.earlyRenewalPeriod;
    }

    protected int getExpiryTimerPeriod() {
        if (this.expiryTimerPeriod == Integer.MIN_VALUE) {
            this.expiryTimerPeriod = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_EXPIRY_TIMER_PERIOD, 60000);
        }
        return this.expiryTimerPeriod;
    }

    private boolean isAfterRenewalDateOrInEarlyRenewalPeriod(TransientRepoPassword transientRepoPassword) {
        Objects.requireNonNull(transientRepoPassword, "authRepoPassword");
        return ChronosUtil.nowAsMillis() + (long)this.getEarlyRenewalPeriod() > transientRepoPassword.getAuthToken().getRenewalDateTime().getMillis();
    }

    private boolean isExpired(TransientRepoPassword transientRepoPassword) {
        Objects.requireNonNull(transientRepoPassword, "authRepoPassword");
        return ChronosUtil.nowAsMillis() > transientRepoPassword.getAuthToken().getExpiryDateTime().getMillis();
    }

    private AuthToken createAuthToken() {
        AuthToken authToken = new AuthToken();
        Date expiryDate = new Date(ChronosUtil.nowAsMillis() + (long)this.getValidityPeriod());
        Date renewalDate = new Date(ChronosUtil.nowAsMillis() + (long)this.getRenewalPeriod());
        authToken.setExpiryDateTime(new DateTime(expiryDate));
        authToken.setRenewalDateTime(new DateTime(renewalDate));
        authToken.setPassword(new String(PasswordUtil.createRandomPassword((int)40)));
        authToken.makeUnmodifiable();
        return authToken;
    }

    private static class TransientRepoPasswordManagerHolder {
        public static final TransientRepoPasswordManager instance = new TransientRepoPasswordManager();

        private TransientRepoPasswordManagerHolder() {
        }
    }
}

