/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommandWithExistingLocalRepo;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequest;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequestDao;
import java.util.UUID;
import org.kohsuke.args4j.Argument;

public class AcceptRepoConnectionSubCommand
extends SubCommandWithExistingLocalRepo {
    @Argument(metaVar="<remote>", index=1, required=false, usage="The unique ID of a remote repository currently requesting to be connected. If none is specified, the oldest request is accepted.")
    private String remote;
    private UUID remoteRepositoryId;

    @Override
    public String getSubCommandDescription() {
        return "Accept a connection request from a remote repository.";
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.remoteRepositoryId = this.remote == null ? null : UUID.fromString(this.remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        byte[] remotePublicKey;
        byte[] localPublicKey;
        UUID localRepositoryId;
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(this.localRoot);){
            String localPathPrefix;
            localRepositoryId = localRepoManager.getRepositoryId();
            localPublicKey = localRepoManager.getPublicKey();
            LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();
            try {
                RemoteRepositoryRequest request;
                RemoteRepositoryRequestDao remoteRepositoryRequestDao = (RemoteRepositoryRequestDao)transaction.getDao(RemoteRepositoryRequestDao.class);
                if (this.remoteRepositoryId == null) {
                    RemoteRepositoryRequest oldestRequest = null;
                    for (RemoteRepositoryRequest remoteRepositoryRequest : remoteRepositoryRequestDao.getObjects()) {
                        if (oldestRequest != null && !oldestRequest.getChanged().after(remoteRepositoryRequest.getChanged())) continue;
                        oldestRequest = remoteRepositoryRequest;
                    }
                    if (oldestRequest == null) {
                        throw new IllegalStateException("There is no connection request pending for this local repository: " + this.localRoot.getPath());
                    }
                    request = oldestRequest;
                } else {
                    request = remoteRepositoryRequestDao.getRemoteRepositoryRequestOrFail(this.remoteRepositoryId);
                }
                this.remoteRepositoryId = request.getRepositoryId();
                remotePublicKey = request.getPublicKey();
                localPathPrefix = request.getLocalPathPrefix();
                transaction.commit();
            }
            finally {
                transaction.rollbackIfActive();
            }
            localRepoManager.putRemoteRepository(this.remoteRepositoryId, null, remotePublicKey, localPathPrefix);
        }
        System.out.println("Successfully accepted the connection request for the following local and remote repositories:");
        System.out.println();
        System.out.println("  localRepository.repositoryId = " + localRepositoryId);
        System.out.println("  localRepository.localRoot = " + this.localRoot);
        System.out.println("  localRepository.publicKeySha1 = " + HashUtil.sha1ForHuman((byte[])localPublicKey));
        System.out.println();
        System.out.println("  remoteRepository.repositoryId = " + this.remoteRepositoryId);
        System.out.println("  remoteRepository.publicKeySha1 = " + HashUtil.sha1ForHuman((byte[])remotePublicKey));
        System.out.println();
        System.out.println("Please verify the 'publicKeySha1' fingerprints! If they do not match the fingerprints shown on the client, someone is attacking you and you must cancel this request immediately! To cancel the request, use this command:");
        System.out.println();
        System.out.println(String.format("  cloudstore dropRepoConnection %s %s", localRepositoryId, this.remoteRepositoryId));
    }
}

