/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Directory;
import co.codewizards.cloudstore.local.persistence.FetchPlanBackup;
import co.codewizards.cloudstore.local.persistence.LocalRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepoFileDao
extends Dao<RepoFile, RepoFileDao> {
    private static final Logger logger = LoggerFactory.getLogger(RepoFileDao.class);
    private Directory localRootDirectory;
    private DirectoryCache directoryCache;

    public RepoFile getChildRepoFile(RepoFile parent, String name) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getChildRepoFile_parent_name");
        RepoFile repoFile = (RepoFile)query.execute((Object)parent, (Object)name);
        return repoFile;
    }

    public RepoFile getRepoFile(File localRoot, File file) throws IllegalArgumentException {
        return this._getRepoFile(Objects.requireNonNull(localRoot, "localRoot"), Objects.requireNonNull(file, "file"), file);
    }

    private RepoFile _getRepoFile(File localRoot, File file, File originallySearchedFile) {
        if (localRoot.equals(file)) {
            return this.getLocalRootDirectory();
        }
        DirectoryCache directoryCache = this.getDirectoryCache();
        Directory directory = directoryCache.get(file);
        if (directory != null) {
            return directory;
        }
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            throw new IllegalArgumentException(String.format("Repository '%s' does not contain file '%s'!", localRoot, originallySearchedFile));
        }
        RepoFile parentRepoFile = this._getRepoFile(localRoot, parentFile, originallySearchedFile);
        RepoFile result = this.getChildRepoFile(parentRepoFile, file.getName());
        if (result instanceof Directory) {
            directoryCache.put(file, (Directory)result);
        }
        return result;
    }

    public Directory getLocalRootDirectory() {
        if (this.localRootDirectory == null) {
            this.localRootDirectory = ((LocalRepositoryDao)new LocalRepositoryDao().persistenceManager(this.pm())).getLocalRepositoryOrFail().getRoot();
        }
        return this.localRootDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepoFile> getChildRepoFiles(RepoFile parent) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getChildRepoFiles_parent");
        try {
            Collection repoFiles = (Collection)query.execute((Object)parent);
            Collection<RepoFile> collection = this.load(repoFiles);
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RepoFile> getRepoFilesChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        logger.debug("getRepoFilesChangedAfterExclLastSyncFromRepositoryId: localRevision={} exclLastSyncFromRepositoryId={}", (Object)localRevision, (Object)exclLastSyncFromRepositoryId);
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom(pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = ChronosUtil.nowAsMillis();
            Collection<RepoFile> repoFiles = (Collection<RepoFile>)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getRepoFilesChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = ChronosUtil.nowAsMillis();
            repoFiles = this.load(repoFiles);
            logger.debug("getRepoFilesChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)repoFiles.size(), (Object)(ChronosUtil.nowAsMillis() - startTimestamp));
            Collection<RepoFile> collection = repoFiles;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    @Override
    public void deletePersistent(RepoFile entity) {
        this.getPersistenceManager().flush();
        if (entity instanceof Directory) {
            this.getDirectoryCache().remove((Directory)entity);
        }
        super.deletePersistent(entity);
        this.getPersistenceManager().flush();
    }

    private DirectoryCache getDirectoryCache() {
        if (this.directoryCache == null) {
            this.directoryCache = new DirectoryCache();
        }
        return this.directoryCache;
    }

    private static class DirectoryCache {
        private static final int MAX_SIZE = 50;
        private final Map<File, Directory> file2DirectoryCache = new HashMap<File, Directory>();
        private final Map<Directory, File> directory2FileCache = new HashMap<Directory, File>();
        private final LinkedList<Directory> directoryCacheList = new LinkedList();

        private DirectoryCache() {
        }

        public Directory get(File file) {
            return this.file2DirectoryCache.get(file);
        }

        public void put(File file, Directory directory) {
            this.file2DirectoryCache.put(Objects.requireNonNull(file, "file"), Objects.requireNonNull(directory, "directory"));
            this.directory2FileCache.put(directory, file);
            this.directoryCacheList.remove(directory);
            this.directoryCacheList.addLast(directory);
            this.removeOldEntriesIfNecessary();
        }

        public void remove(Directory directory) {
            File file = this.directory2FileCache.remove(directory);
            this.file2DirectoryCache.remove(file);
        }

        public void remove(File file) {
            Directory directory = this.file2DirectoryCache.remove(file);
            this.directory2FileCache.remove(directory);
        }

        private void removeOldEntriesIfNecessary() {
            while (this.directoryCacheList.size() > 50) {
                Directory directory = this.directoryCacheList.removeFirst();
                this.remove(directory);
            }
        }
    }
}

