/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.db;

import co.codewizards.cloudstore.local.db.Table;
import java.util.Objects;

public class Column
implements Comparable<Column> {
    public final Table table;
    public final String name;
    public final int dataType;
    public final int size;
    public final Boolean autoIncrement;

    public Column(Table table, String name, int dataType, int size, Boolean autoIncrement) {
        this.table = Objects.requireNonNull(table, "table");
        this.name = Objects.requireNonNull(name, "name");
        this.dataType = dataType;
        this.size = size;
        this.autoIncrement = autoIncrement;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[table=" + this.table + ", name=" + Column.toStringWithSingleQuotes(this.name) + ", dataType=" + this.dataType + ", size=" + this.size + "]";
    }

    private static String toStringWithSingleQuotes(String value) {
        if (value == null) {
            return String.valueOf(value);
        }
        return "'" + value + "'";
    }

    @Override
    public int compareTo(Column other) {
        int res = this.table.compareTo(other.table);
        if (res != 0) {
            return res;
        }
        res = Column.compare(this.name, other.name);
        return res;
    }

    private static int compare(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        return Objects.equals(this.name, other.name) && this.table.equals(other.table);
    }
}

