/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.rest.client.CloudStoreJaxbContextResolver;
import co.codewizards.cloudstore.rest.client.ssl.HostnameVerifierAllowingAll;
import co.codewizards.cloudstore.rest.shared.filter.GZIPClientRequestFilter;
import co.codewizards.cloudstore.rest.shared.interceptor.GZIPReaderInterceptor;
import co.codewizards.cloudstore.rest.shared.interceptor.GZIPWriterInterceptor;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;

public class ClientBuilderDefaultValuesDecorator
extends ClientBuilder {
    private static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_SOCKET_READ_TIMEOUT = 300000;
    public static final String CONFIG_KEY_SOCKET_CONNECT_TIMEOUT = "socket.connectTimeout";
    public static final String CONFIG_KEY_SOCKET_READ_TIMEOUT = "socket.readTimeout";
    private final ClientBuilder builder;

    public ClientBuilderDefaultValuesDecorator() {
        this(ClientBuilder.newBuilder());
    }

    public ClientBuilderDefaultValuesDecorator(ClientBuilder builder) {
        this.builder = builder;
        ClientConfig clientConfig = new ClientConfig(new Class[]{CloudStoreJaxbContextResolver.class});
        Integer socketReadTimeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_SOCKET_READ_TIMEOUT, 300000);
        Integer socketConnectTimeout = ConfigImpl.getInstance().getPropertyAsPositiveOrZeroInt(CONFIG_KEY_SOCKET_CONNECT_TIMEOUT, 60000);
        clientConfig.property("jersey.config.client.connectTimeout", (Object)socketConnectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)socketReadTimeout);
        clientConfig.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
        ((ClientBuilder)((ClientBuilder)((ClientBuilder)this.builder.withConfig((Configuration)clientConfig).register(GZIPReaderInterceptor.class)).register(GZIPClientRequestFilter.class)).register(GZIPWriterInterceptor.class)).hostnameVerifier((HostnameVerifier)new HostnameVerifierAllowingAll());
    }

    public Client build() {
        return this.builder.build();
    }

    public ClientBuilderDefaultValuesDecorator sslContext(SSLContext sslContext) {
        this.builder.sslContext(sslContext);
        return this;
    }

    public ClientBuilderDefaultValuesDecorator hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.builder.hostnameVerifier(hostnameVerifier);
        return this;
    }

    public Configuration getConfiguration() {
        return this.builder.getConfiguration();
    }

    public ClientBuilder property(String name, Object value) {
        this.builder.property(name, value);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass) {
        this.builder.register(componentClass);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, int priority) {
        this.builder.register(componentClass, priority);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.builder.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.builder.register(componentClass, contracts);
        return this;
    }

    public ClientBuilder register(Object component) {
        this.builder.register(component);
        return this;
    }

    public ClientBuilder register(Object component, int priority) {
        this.builder.register(component, priority);
        return this;
    }

    public ClientBuilder register(Object component, Class<?> ... contracts) {
        this.builder.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.builder.register(component, contracts);
        return this;
    }

    public ClientBuilder withConfig(Configuration config) {
        this.builder.withConfig(config);
        return this;
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.builder.keyStore(keyStore, password);
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        this.builder.trustStore(trustStore);
        return this;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        this.builder.executorService(executorService);
        return this;
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.builder.scheduledExecutorService(scheduledExecutorService);
        return this;
    }

    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.builder.connectTimeout(timeout, unit);
        return this;
    }

    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.builder.readTimeout(timeout, unit);
        return this;
    }
}

