/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.test;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.chronos.ChronosUtil;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.server.CloudStoreServer;
import java.io.IOException;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreServerTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreServerTestSupport.class);
    public final Uid instanceId = new Uid();
    private static final SecureRandom random = new SecureRandom();
    private static final AtomicInteger cloudStoreServerStopTimerIndex = new AtomicInteger();
    private CloudStoreServer cloudStoreServer;
    private Thread cloudStoreServerThread;
    private final Object cloudStoreServerMutex = new Object();
    private final Timer cloudStoreServerStopTimer = new Timer("cloudStoreServerStopTimer-" + cloudStoreServerStopTimerIndex.incrementAndGet(), true);
    private TimerTask cloudStoreServerStopTimerTask;
    private int testInstanceCounter;
    private int securePort;

    public int getSecurePort() {
        return this.securePort;
    }

    public String getSecureUrl() {
        return "https://localhost:" + this.getSecurePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeClass() throws Exception {
        Object object = this.cloudStoreServerMutex;
        synchronized (object) {
            boolean first = this.testInstanceCounter++ == 0;
            logger.debug("[{}].beforeClass: entered. testInstanceCounter={}", (Object)this.instanceId, (Object)this.testInstanceCounter);
            if (this.cloudStoreServerStopTimerTask != null) {
                this.cloudStoreServerStopTimerTask.cancel();
                this.cloudStoreServerStopTimerTask = null;
            }
            if (this.cloudStoreServer == null) {
                IOUtil.deleteDirectoryRecursively((File)ConfigDir.getInstance().getFile());
                this.securePort = this.getRandomAvailableServerPort();
                this.cloudStoreServer = this.createCloudStoreServer();
                this.cloudStoreServer.setSecurePort(this.securePort);
                this.cloudStoreServerThread = new Thread((Runnable)this.cloudStoreServer);
                this.cloudStoreServerThread.setName("cloudStoreServerThread");
                this.cloudStoreServerThread.setDaemon(true);
                this.cloudStoreServerThread.start();
                this.waitForServerToOpenSecurePort();
            }
            return first;
        }
    }

    private int getRandomAvailableServerPort() throws IOException {
        for (int tryCount = 0; tryCount < 100; ++tryCount) {
            int port = 1025 + random.nextInt(30720);
            logger.debug("[{}].getRandomAvailableServerPort: port={}: Trying to connect...", (Object)this.instanceId, (Object)port);
            try {
                Socket socket = new Socket("localhost", port);
                socket.close();
                logger.warn("[{}].getRandomAvailableServerPort: port={}: Connected => Port already in use!", (Object)this.instanceId, (Object)port);
                continue;
            }
            catch (Exception x) {
                logger.debug("[{}].getRandomAvailableServerPort: port={}: Connection attempt failed => Port available.", (Object)this.instanceId, (Object)port);
                return port;
            }
        }
        throw new IllegalStateException("Could not find any available server-port!");
    }

    protected CloudStoreServer createCloudStoreServer() {
        return new CloudStoreServer(new String[0]);
    }

    private void waitForServerToOpenSecurePort() {
        logger.debug("[{}].waitForServerToOpenSecurePort: securePort={}: entered.", (Object)this.instanceId, (Object)this.getSecurePort());
        long timeoutMillis = 180000L;
        long begin = ChronosUtil.nowAsMillis();
        while (true) {
            try {
                Socket socket = new Socket("localhost", this.getSecurePort());
                socket.close();
                logger.info("[{}].waitForServerToOpenSecurePort: securePort={}: successfully connected.", (Object)this.instanceId, (Object)this.getSecurePort());
                return;
            }
            catch (Exception x) {
                logger.debug("waitForServerToOpenSecurePort: securePort={}: failed => sleeping + retrying...", (Object)this.getSecurePort());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ChronosUtil.nowAsMillis() - begin <= 180000L) continue;
                String message = String.format("Server on securePort=%s did not start within timeout=%s ms!", this.getSecurePort(), 180000L);
                logger.error("[{}].waitForServerToOpenSecurePort: {}", (Object)this.instanceId, (Object)message);
                throw new IllegalStateException(message);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterClass() throws Exception {
        Object object = this.cloudStoreServerMutex;
        synchronized (object) {
            logger.debug("[{}].afterClass: entered. testInstanceCounter={}", (Object)this.instanceId, (Object)this.testInstanceCounter);
            if (--this.testInstanceCounter > 0) {
                return false;
            }
            if (this.cloudStoreServerStopTimerTask == null) {
                this.cloudStoreServerStopTimerTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = CloudStoreServerTestSupport.this.cloudStoreServerMutex;
                        synchronized (object) {
                            if (CloudStoreServerTestSupport.this.cloudStoreServer != null) {
                                CloudStoreServerTestSupport.this.cloudStoreServer.stop();
                                CloudStoreServerTestSupport.this.cloudStoreServer = null;
                                CloudStoreServerTestSupport.this.cloudStoreServerStopTimerTask = null;
                            }
                        }
                    }
                };
                this.cloudStoreServerStopTimer.schedule(this.cloudStoreServerStopTimerTask, 60000L);
            }
            return true;
        }
    }
}

