/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.concurrent.CallableProvider;
import co.codewizards.cloudstore.core.concurrent.DeferrableExecutor;
import co.codewizards.cloudstore.core.dto.ChangeSetDto;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_ChangeSetDto/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class ChangeSetDtoService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetDtoService.class);

    public ChangeSetDtoService() {
        logger.debug("<init>: created new instance");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public ChangeSetDto getChangeSetDto(final @QueryParam(value="localSync") boolean localSync) {
        final RepoTransport[] repoTransport = new RepoTransport[]{this.authenticateAndCreateLocalRepoTransport()};
        try {
            String callIdentifier = ChangeSetDtoService.class.getName() + ".getChangeSetDto|" + this.repositoryName + '|' + this.getAuth().getUserName() + '|' + localSync;
            ChangeSetDto changeSetDto = (ChangeSetDto)DeferrableExecutor.getInstance().call(callIdentifier, (CallableProvider)new CallableProvider<ChangeSetDto>(){

                public Callable<ChangeSetDto> getCallable() {
                    final RepoTransport rt = repoTransport[0];
                    repoTransport[0] = null;
                    return new Callable<ChangeSetDto>(){

                        @Override
                        public ChangeSetDto call() throws Exception {
                            try {
                                ChangeSetDto changeSetDto;
                                ChangeSetDto changeSetDto2 = changeSetDto = ChangeSetDtoService.this.getChangeSetDto(rt, localSync);
                                return changeSetDto2;
                            }
                            finally {
                                rt.close();
                            }
                        }
                    };
                }
            });
            return changeSetDto;
        }
        finally {
            if (repoTransport[0] != null) {
                repoTransport[0].close();
            }
        }
    }

    protected ChangeSetDto getChangeSetDto(RepoTransport repoTransport, boolean localSync) {
        return repoTransport.getChangeSetDto(localSync);
    }
}

