/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.ldap;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.otp.LdapPasswordOneTimePadRegistry;
import co.codewizards.cloudstore.core.otp.OneTimePadRegistry;
import co.codewizards.cloudstore.core.util.StringUtil;
import co.codewizards.cloudstore.rest.server.ldap.DnTemplateCollector;
import co.codewizards.cloudstore.rest.server.ldap.LdapClient;
import co.codewizards.cloudstore.rest.server.ldap.QueryLdapClient;
import co.codewizards.cloudstore.rest.server.ldap.SimpleLdapClient;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapClientProvider {
    private static final Logger log = LoggerFactory.getLogger(LdapClientProvider.class);
    public static final String LDAP_TEMPLATE_PATTERN = "ldap.bindDnTemplate[%d]";
    public static final String LDAP_URL = "ldap.url";
    private static final String LDAP_URL_DEFAULT = "ldap://localhost:389";
    public static final String LDAP_QUERY = "ldap.query";
    public static final String LDAP_ADMIN_DN = "ldap.adminDn";
    public static final String LDAP_QUERY_DN = "ldap.queryDn";
    private LdapClient ldapClient;

    protected LdapClientProvider() {
        this((OneTimePadRegistry)new LdapPasswordOneTimePadRegistry());
    }

    protected LdapClientProvider(OneTimePadRegistry adminPasswordRegistry) {
        try {
            String url = ConfigImpl.getInstance().getProperty(LDAP_URL, LDAP_URL_DEFAULT);
            String query = ConfigImpl.getInstance().getProperty(LDAP_QUERY, "");
            this.ldapClient = StringUtil.isEmpty((String)query) ? this.createSimpleLdapClient(url) : this.createQueryLdapClient(adminPasswordRegistry, query, url);
        }
        catch (Exception e) {
            log.warn("LDAP client initialization failed. If you don't use LDAP you can ignore this warning, otherwise you can increase logging to DEBUG in order to see what is the cause of this failure.");
            log.debug("LDAP client initialization failed", (Throwable)e);
        }
    }

    public LdapClient getClient() {
        if (this.ldapClient == null) {
            throw new IllegalStateException("LDAP is not properly configured. Maybe you forgot to put LDAP properties inside cloudstore.properties?");
        }
        return this.ldapClient;
    }

    public static LdapClientProvider getInstance() {
        return Helper.INSTANCE;
    }

    private SimpleLdapClient createSimpleLdapClient(String url) {
        List<String> templates = new DnTemplateCollector().collect();
        return new SimpleLdapClient(templates, url);
    }

    private QueryLdapClient createQueryLdapClient(OneTimePadRegistry adminPasswordRegistry, String query, String url) {
        char[] password = adminPasswordRegistry.readFromFileAndDecrypt();
        String queryDn = ConfigImpl.getInstance().getProperty(LDAP_QUERY_DN, null);
        String adminDn = ConfigImpl.getInstance().getProperty(LDAP_ADMIN_DN, null);
        return new QueryLdapClient(query, queryDn, url, adminDn, password);
    }

    private static class Helper {
        private static final LdapClientProvider INSTANCE = new LdapClientProvider();

        private Helper() {
        }
    }
}

