/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OptimizerImpl;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class ResultSetNode
extends QueryTreeNode {
    private int resultSetNumber;
    private JBitSet referencedTableMap;
    private ResultColumnList resultColumns;
    private boolean statementResultSet;
    private boolean cursorTargetTable;
    private boolean insertSource;
    private CostEstimate costEstimate;
    private CostEstimate scratchCostEstimate;
    private Optimizer optimizer;
    private CostEstimate candidateFinalCostEstimate;

    ResultSetNode(ContextManager contextManager) {
        super(contextManager);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n) {
    }

    boolean isStatementResultSet() {
        return this.statementResultSet;
    }

    boolean isCursorTargetTable() {
        return this.cursorTargetTable;
    }

    void setCursorTargetTable(boolean bl) {
        this.cursorTargetTable = bl;
    }

    CostEstimate getScratchCostEstimate() {
        return this.scratchCostEstimate;
    }

    void setScratchCostEstimate(CostEstimate costEstimate) {
        this.scratchCostEstimate = costEstimate;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    void setResultSetNumber(int n) {
        this.resultSetNumber = n;
    }

    CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    void setCostEstimate(CostEstimate costEstimate) {
        this.costEstimate = costEstimate;
    }

    CostEstimate getFinalCostEstimate() throws StandardException {
        return this.candidateFinalCostEstimate;
    }

    CostEstimate getCandidateFinalCostEstimate() {
        return this.candidateFinalCostEstimate;
    }

    void setCandidateFinalCostEstimate(CostEstimate costEstimate) {
        this.candidateFinalCostEstimate = costEstimate;
    }

    void assignResultSetNumber() throws StandardException {
        this.resultSetNumber = this.getCompilerContext().getNextResultSetNumber();
        this.resultColumns.setResultSetNumber(this.resultSetNumber);
    }

    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        return this;
    }

    ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        return this;
    }

    void bindExpressions(FromList fromList) throws StandardException {
    }

    void bindExpressionsWithTables(FromList fromList) throws StandardException {
    }

    void bindTargetExpressions(FromList fromList) throws StandardException {
    }

    void setTableConstructorTypes(ResultColumnList resultColumnList) throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            ValueNode valueNode = resultColumn.getExpression();
            if (valueNode == null || !valueNode.requiresTypeFromContext()) continue;
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(i);
            valueNode.setType(resultColumn2.getTypeServices());
        }
    }

    void setInsertSource() {
        this.insertSource = true;
    }

    boolean isInsertSource() {
        return this.insertSource;
    }

    void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
    }

    ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        return null;
    }

    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    ResultSetNode setResultToBooleanTrueNode(boolean bl) throws StandardException {
        ResultColumn resultColumn;
        if (this.resultColumns.elementAt(0) instanceof AllResultColumn) {
            resultColumn = new ResultColumn("", null, this.getContextManager());
        } else {
            if (bl) {
                return this;
            }
            resultColumn = (ResultColumn)this.resultColumns.elementAt(0);
            if (resultColumn.getExpression().isBooleanTrue() && this.resultColumns.size() == 1) {
                return this;
            }
        }
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, this.getContextManager());
        resultColumn.setExpression(booleanConstantNode);
        resultColumn.setType(booleanConstantNode.getTypeServices());
        resultColumn.setVirtualColumnId(1);
        this.resultColumns.setElementAt(resultColumn, 0);
        return this;
    }

    FromList getFromList() throws StandardException {
        return new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
    }

    void bindResultColumns(FromList fromList) throws StandardException {
        this.resultColumns.bindResultColumnsToExpressions();
    }

    void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        if (this instanceof SelectNode) {
            this.resultColumns.expandAllsAndNameColumns(((SelectNode)this).fromList);
        }
        if (resultColumnList != null) {
            this.resultColumns.copyResultColumnNames(resultColumnList);
        }
        if (resultColumnList != null) {
            if (tableDescriptor != null) {
                this.resultColumns.bindResultColumnsByName(tableDescriptor, dMLStatementNode);
            } else {
                this.resultColumns.bindResultColumnsByName(fromVTI.getResultColumns(), fromVTI, dMLStatementNode);
            }
        } else {
            this.resultColumns.bindResultColumnsByPosition(tableDescriptor);
        }
    }

    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
    }

    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        return null;
    }

    void projectResultColumns() throws StandardException {
    }

    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return null;
    }

    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        return null;
    }

    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    ResultSetNode genProjectRestrictForReordering() throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns, false);
        return new ProjectRestrictNode(this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        return null;
    }

    ResultSetNode modifyAccessPaths() throws StandardException {
        return this;
    }

    ResultSetNode modifyAccessPaths(PredicateList predicateList) throws StandardException {
        return this.modifyAccessPaths();
    }

    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.resultColumns.makeResultDescriptors();
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        return this.resultColumns.columnTypesAndLengthsMatch();
    }

    void setResultColumns(ResultColumnList resultColumnList) {
        this.resultColumns = resultColumnList;
    }

    ResultColumnList getResultColumns() {
        return this.resultColumns;
    }

    void setReferencedTableMap(JBitSet jBitSet) {
        this.referencedTableMap = jBitSet;
    }

    public JBitSet getReferencedTableMap() {
        return this.referencedTableMap;
    }

    void fillInReferencedTableMap(JBitSet jBitSet) {
    }

    void rejectParameters() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectParameters();
        }
    }

    void rejectXMLValues() throws StandardException {
        if (this.resultColumns != null) {
            this.resultColumns.rejectXMLValues();
        }
    }

    void renameGeneratedResultNames() throws StandardException {
        for (int i = 0; i < this.resultColumns.size(); ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (!resultColumn.isNameGenerated()) continue;
            resultColumn.setName(Integer.toString(i + 1));
        }
    }

    void markStatementResultSet() {
        this.statementResultSet = true;
    }

    ResultSetNode enhanceRCLForInsert(InsertNode insertNode, boolean bl, int[] nArray) throws StandardException {
        if (!bl || this.resultColumns.visibleSize() < insertNode.resultColumnList.size()) {
            return this.generateProjectRestrictForInsert(insertNode, nArray);
        }
        return this;
    }

    ResultColumnList getRCLForInsert(InsertNode insertNode, int[] nArray) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        int n = insertNode.resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = nArray[i] != -1 ? this.resultColumns.getResultColumn(nArray[i] + 1) : this.genNewRCForInsert(insertNode.targetTableDescriptor, insertNode.targetVTI, i + 1, insertNode.getDataDictionary());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    private ResultColumn genNewRCForInsert(TableDescriptor tableDescriptor, FromVTI fromVTI, int n, DataDictionary dataDictionary) throws StandardException {
        ResultColumn resultColumn;
        if (fromVTI != null) {
            resultColumn = fromVTI.getResultColumns().getResultColumn(n);
            resultColumn = resultColumn.cloneMe();
            resultColumn.setExpressionToNullNode();
        } else {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DefaultInfoImpl defaultInfoImpl = (DefaultInfoImpl)columnDescriptor.getDefaultInfo();
            if (defaultInfoImpl != null && !columnDescriptor.isAutoincrement()) {
                Object object;
                if (columnDescriptor.hasGenerationClause()) {
                    resultColumn = this.createGeneratedColumn(tableDescriptor, columnDescriptor);
                } else {
                    object = defaultInfoImpl.getDefaultText();
                    ValueNode valueNode = this.parseDefault((String)object);
                    valueNode = valueNode.bindExpression(this.getFromList(), null, null);
                    resultColumn = new ResultColumn(valueNode.getTypeServices(), valueNode, this.getContextManager());
                }
                object = columnDescriptor.getDefaultDescriptor(dataDictionary);
                this.getCompilerContext().createDependency((Provider)object);
            } else if (columnDescriptor.isAutoincrement()) {
                resultColumn = new ResultColumn(columnDescriptor, null, this.getContextManager());
                resultColumn.setAutoincrementGenerated();
            } else {
                resultColumn = new ResultColumn(dataTypeDescriptor, (ValueNode)this.getNullNode(dataTypeDescriptor), this.getContextManager());
            }
        }
        resultColumn.markGeneratedForUnmatchedColumnInInsert();
        return resultColumn;
    }

    private ResultSetNode generateProjectRestrictForInsert(InsertNode insertNode, int[] nArray) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        int n = insertNode.resultColumnList.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn;
            if (nArray[i] != -1) {
                ResultColumn resultColumn2 = this.resultColumns.getResultColumn(nArray[i] + 1);
                ColumnReference columnReference = new ColumnReference(resultColumn2.getName(), null, this.getContextManager());
                DataTypeDescriptor dataTypeDescriptor = resultColumn2.getType();
                if (dataTypeDescriptor == null) {
                    ColumnDescriptor columnDescriptor = insertNode.targetTableDescriptor.getColumnDescriptor(i + 1);
                    dataTypeDescriptor = columnDescriptor.getType();
                }
                columnReference.setSource(resultColumn2);
                columnReference.setType(dataTypeDescriptor);
                columnReference.setNestingLevel(0);
                columnReference.setSourceLevel(0);
                resultColumn = new ResultColumn(dataTypeDescriptor, (ValueNode)columnReference, this.getContextManager());
            } else {
                resultColumn = this.genNewRCForInsert(insertNode.targetTableDescriptor, insertNode.targetVTI, i + 1, insertNode.getDataDictionary());
            }
            resultColumnList.addResultColumn(resultColumn);
        }
        return new ProjectRestrictNode(this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    private ResultColumn createGeneratedColumn(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        UntypedNullConstantNode untypedNullConstantNode = new UntypedNullConstantNode(this.getContextManager());
        ResultColumn resultColumn = new ResultColumn(columnDescriptor.getType(), (ValueNode)untypedNullConstantNode, this.getContextManager());
        resultColumn.setColumnDescriptor(tableDescriptor, columnDescriptor);
        return resultColumn;
    }

    public ValueNode parseDefault(String string) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        String string2 = "VALUES " + string;
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext.getParser();
        Visitable visitable = parser.parseStatement(string2);
        ValueNode valueNode = ((ResultColumn)((CursorNode)visitable).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        languageConnectionContext.popCompilerContext(compilerContext);
        return valueNode;
    }

    public ResultDescription makeResultDescription() {
        ResultColumnDescriptor[] resultColumnDescriptorArray = this.makeResultDescriptors();
        return this.getExecutionFactory().getResultDescription(resultColumnDescriptorArray, null);
    }

    boolean isUpdatableCursor(DataDictionary dataDictionary) throws StandardException {
        return false;
    }

    FromTable getCursorTargetTable() {
        return null;
    }

    boolean markAsCursorTargetTable() {
        return false;
    }

    void notCursorTargetTable() {
        this.cursorTargetTable = false;
    }

    ResultSetNode genProjectRestrict() throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns);
        return new ProjectRestrictNode(this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    ResultSetNode genProjectRestrict(int n) throws StandardException {
        return this.genProjectRestrict();
    }

    void generateNormalizationResultSet(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n, ResultDescription resultDescription) throws StandardException {
        int n2 = activationClassBuilder.addItem(resultDescription);
        methodBuilder.push(n);
        methodBuilder.push(n2);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(false);
        methodBuilder.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    ResultSetNode changeAccessPath() throws StandardException {
        return this;
    }

    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return false;
    }

    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return false;
    }

    boolean isOneRowResultSet() throws StandardException {
        return false;
    }

    boolean isNotExists() {
        return false;
    }

    protected OptimizerImpl getOptimizerImpl() {
        return (OptimizerImpl)this.optimizer;
    }

    Optimizer getOptimizer() {
        return this.optimizer;
    }

    void setOptimizer(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    protected CostEstimate getNewCostEstimate() throws StandardException {
        OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
        return optimizerFactory.getCostEstimate();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.resultColumns != null) {
            this.resultColumns = (ResultColumnList)this.resultColumns.accept(visitor);
        }
    }

    ResultSetNode considerMaterialization(JBitSet jBitSet) throws StandardException {
        return this;
    }

    boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return false;
    }

    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return null;
    }

    abstract void decrementLevel(int var1);

    void pushOrderByList(OrderByList orderByList) {
    }

    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
    }

    void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
    }

    int updateTargetLockMode() {
        return 7;
    }

    void notFlattenableJoin() {
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, List<FromBaseTable> list) throws StandardException {
        return false;
    }

    boolean returnsAtMostOneRow() {
        return false;
    }

    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
    }

    boolean isPossibleDistinctScan(Set<BaseColumnNode> set) {
        return false;
    }

    void markForDistinctScan() {
    }

    void adjustForSortElimination() {
    }

    void adjustForSortElimination(RequiredRowOrdering requiredRowOrdering) throws StandardException {
        this.adjustForSortElimination();
    }

    static int numDistinctAggregates(List<AggregateNode> list) {
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (!list.get(i).isDistinct()) continue;
            ++n;
        }
        return n;
    }

    JBitSet LOJgetReferencedTables(int n) throws StandardException {
        if (this instanceof FromTable && ((FromTable)this).tableNumber != -1) {
            JBitSet jBitSet = new JBitSet(n);
            jBitSet.set(((FromTable)this).tableNumber);
            return jBitSet;
        }
        return null;
    }

    void pushQueryExpressionSuffix() {
    }

    void printQueryExpressionSuffixClauses(int n, QueryExpressionClauses queryExpressionClauses) {
        for (int i = 0; i < queryExpressionClauses.size(); ++i) {
            Boolean bl;
            ValueNode valueNode;
            ValueNode valueNode2;
            OrderByList orderByList = queryExpressionClauses.getOrderByList(i);
            if (orderByList != null) {
                this.printLabel(n, "orderByLists[" + i + "]:");
                orderByList.treePrint(n + 1);
            }
            if ((valueNode2 = queryExpressionClauses.getOffset(i)) != null) {
                this.printLabel(n, "offset:");
                valueNode2.treePrint(n + 1);
            }
            if ((valueNode = queryExpressionClauses.getFetchFirst(i)) != null) {
                this.printLabel(n, "fetch first/next:");
                valueNode.treePrint(n + 1);
            }
            if ((bl = queryExpressionClauses.getHasJDBCLimitClause()[i]) == null) continue;
            this.printLabel(n, "hasJDBCLimitClause:" + bl + "\n");
        }
    }

    static class QueryExpressionClauses {
        private final List<OrderByList> obl = new ArrayList<OrderByList>();
        private final List<ValueNode> offset = new ArrayList<ValueNode>();
        private final List<ValueNode> fetchFirst = new ArrayList<ValueNode>();
        private final List<Boolean> hasJDBCLimitClause = new ArrayList<Boolean>();

        public QueryExpressionClauses() {
            this.push();
        }

        int size() {
            return this.obl.size();
        }

        void push() {
            int n = this.size();
            if (n <= 0 || this.obl.get(n - 1) != null || this.offset.get(n - 1) != null || this.fetchFirst.get(n - 1) != null) {
                this.obl.add(null);
                this.offset.add(null);
                this.fetchFirst.add(null);
                this.hasJDBCLimitClause.add(null);
            }
        }

        void setOrderByList(OrderByList orderByList) {
            this.obl.set(this.size() - 1, orderByList);
        }

        void setOffset(ValueNode valueNode) {
            this.offset.set(this.size() - 1, valueNode);
        }

        void setFetchFirst(ValueNode valueNode) {
            this.fetchFirst.set(this.size() - 1, valueNode);
        }

        void setHasJDBCLimitClause(Boolean bl) {
            this.hasJDBCLimitClause.set(this.size() - 1, bl);
        }

        OrderByList getOrderByList(int n) {
            return this.obl.get(n);
        }

        void setOrderByList(int n, OrderByList orderByList) {
            this.obl.set(n, orderByList);
        }

        ValueNode getOffset(int n) {
            return this.offset.get(n);
        }

        void setOffset(int n, ValueNode valueNode) {
            this.offset.set(n, valueNode);
        }

        ValueNode getFetchFirst(int n) {
            return this.fetchFirst.get(n);
        }

        void setFetchFirst(int n, ValueNode valueNode) {
            this.fetchFirst.set(n, valueNode);
        }

        Boolean[] getHasJDBCLimitClause() {
            return this.hasJDBCLimitClause.toArray(new Boolean[1]);
        }

        boolean hasOffsetFetchFirst() {
            for (ValueNode valueNode : this.offset) {
                if (valueNode == null) continue;
                return true;
            }
            for (ValueNode valueNode : this.fetchFirst) {
                if (valueNode == null) continue;
                return true;
            }
            return false;
        }
    }
}

