/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommandWithExistingLocalRepo;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.persistence.RemoteRepository;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryDao;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequest;
import co.codewizards.cloudstore.local.persistence.RemoteRepositoryRequestDao;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.kohsuke.args4j.Argument;

public class DropRepoConnectionSubCommand
extends SubCommandWithExistingLocalRepo {
    @Argument(metaVar="<remote>", index=1, required=true, usage="An ID or URL of a remote repository.")
    private String remote;
    private UUID remoteRepositoryId;
    private URL remoteRoot;

    @Override
    public String getSubCommandDescription() {
        return "Cancel a connection to a remote repository. IMPORTANT: This does currently only operate locally. Thus, you have to cancel a connection manually on both sides.";
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        try {
            this.remoteRepositoryId = UUID.fromString(this.remote);
            this.remoteRoot = null;
        }
        catch (IllegalArgumentException x) {
            try {
                this.remoteRoot = new URL(this.remote);
                this.remoteRepositoryId = null;
            }
            catch (MalformedURLException y) {
                throw new IllegalArgumentException(String.format("<remote> '%s' is neither a valid repositoryId nor a valid URL!", this.remote));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        UUID localRepositoryId;
        boolean foundSomethingToCancel = false;
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(this.localRoot);){
            localRepositoryId = localRepoManager.getRepositoryId();
            LocalRepoTransaction transaction = localRepoManager.beginWriteTransaction();
            try {
                RemoteRepository remoteRepository;
                RemoteRepositoryDao remoteRepositoryDao = (RemoteRepositoryDao)transaction.getDao(RemoteRepositoryDao.class);
                if (this.remoteRepositoryId != null) {
                    RemoteRepositoryRequestDao remoteRepositoryRequestDao;
                    RemoteRepositoryRequest remoteRepositoryRequest;
                    remoteRepository = remoteRepositoryDao.getRemoteRepository(this.remoteRepositoryId);
                    if (remoteRepository != null) {
                        foundSomethingToCancel = true;
                        this.remoteRoot = remoteRepository.getRemoteRoot();
                        remoteRepositoryDao.deletePersistent(remoteRepository);
                        remoteRepositoryDao.getPersistenceManager().flush();
                    }
                    if ((remoteRepositoryRequest = (remoteRepositoryRequestDao = (RemoteRepositoryRequestDao)transaction.getDao(RemoteRepositoryRequestDao.class)).getRemoteRepositoryRequest(this.remoteRepositoryId)) != null) {
                        foundSomethingToCancel = true;
                        remoteRepositoryRequestDao.deletePersistent(remoteRepositoryRequest);
                        remoteRepositoryRequestDao.getPersistenceManager().flush();
                    }
                }
                if (this.remoteRoot != null && (remoteRepository = remoteRepositoryDao.getRemoteRepository(this.remoteRoot)) != null) {
                    foundSomethingToCancel = true;
                    this.remoteRepositoryId = remoteRepository.getRepositoryId();
                    remoteRepositoryDao.deletePersistent(remoteRepository);
                    remoteRepositoryDao.getPersistenceManager().flush();
                }
                transaction.commit();
            }
            finally {
                transaction.rollbackIfActive();
            }
        }
        if (foundSomethingToCancel) {
            System.out.println("Successfully cancelled the connection from the local repository to the remote repository:");
            System.out.println();
            System.out.println("  localRepository.repositoryId = " + localRepositoryId);
            System.out.println("  localRepository.localRoot = " + this.localRoot);
            System.out.println();
            System.out.println("  remoteRepository.repositoryId = " + this.remoteRepositoryId);
            System.out.println("  remoteRepository.remoteRoot = " + this.remoteRoot);
            System.out.println();
            System.out.println("Important: This only cancelled the local side of the connection and you should cancel it on the other side, too, using this command (if you didn't do this yet):");
            System.out.println();
            System.out.println(String.format("  cloudstore dropRepoConnection %s %s", this.remoteRepositoryId, localRepositoryId));
        } else {
            System.out.println("There was nothing to be cancelled here. Maybe it was cancelled already before?!");
            System.out.println("Or maybe you want to instead run the following command on the other side (i.e. on the other computer - cancelling currently works only on one side):");
            System.out.println();
            System.out.println(String.format("  cloudstore dropRepoConnection %s %s", this.remoteRepositoryId, localRepositoryId));
        }
    }
}

