/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommandWithExistingLocalRepo;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.progress.LoggerProgressMonitor;
import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.repo.sync.RepoToRepoSync;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSubCommand
extends SubCommandWithExistingLocalRepo {
    private static final Logger logger = LoggerFactory.getLogger(SyncSubCommand.class);
    @Argument(metaVar="<remote>", index=1, required=false, usage="An ID or URL of a remote repository. If none is specified, all remote repositories are synced.")
    private String remote;
    private UUID remoteRepositoryId;
    private URL remoteRoot;
    @Option(name="-localOnly", required=false, usage="Synchronise locally only. Do not communicate with any remote repository.")
    private boolean localOnly;

    @Override
    public String getSubCommandDescription() {
        return "Synchronise a local repository. Depending on the parameters, it synchronises only locally or with one or more remote repositories.";
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.remoteRepositoryId = null;
        this.remoteRoot = null;
        if (this.remote != null && !this.remote.isEmpty()) {
            try {
                this.remoteRepositoryId = UUID.fromString(this.remote);
            }
            catch (IllegalArgumentException x) {
                try {
                    this.remoteRoot = new URL(this.remote);
                }
                catch (MalformedURLException y) {
                    throw new IllegalArgumentException(String.format("<remote> '%s' is neither a valid repositoryId nor a valid URL!", this.remote));
                }
            }
        }
    }

    @Override
    protected void assertLocalRootNotNull() {
        if (!this.isAll()) {
            super.assertLocalRootNotNull();
        }
    }

    @Override
    public void run() throws Exception {
        if (this.isAll()) {
            for (UUID repositoryId : LocalRepoRegistryImpl.getInstance().getRepositoryIds()) {
                this.sync(repositoryId);
            }
        } else {
            this.sync(this.localRoot);
        }
    }

    private void sync(UUID repositoryId) {
        File localRoot = LocalRepoRegistryImpl.getInstance().getLocalRootOrFail(repositoryId);
        this.sync(localRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(File localRoot) {
        UUID repositoryId;
        ArrayList<URL> remoteRoots = new ArrayList<URL>();
        HashMap<UUID, URL> filteredRemoteRepositoryId2RemoteRoot = new HashMap<UUID, URL>();
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);){
            if (this.localOnly) {
                localRepoManager.localSync((ProgressMonitor)new LoggerProgressMonitor(logger));
                return;
            }
            repositoryId = localRepoManager.getRepositoryId();
            localRoot = localRepoManager.getLocalRoot();
            for (Map.Entry me : localRepoManager.getRemoteRepositoryId2RemoteRootMap().entrySet()) {
                UUID id = (UUID)me.getKey();
                URL url = (URL)me.getValue();
                remoteRoots.add(url);
                if (!(this.remoteRepositoryId == null && this.remoteRoot == null || this.remoteRepositoryId != null && this.remoteRepositoryId.equals(id)) && (this.remoteRoot == null || !this.remoteRoot.equals(url))) continue;
                filteredRemoteRepositoryId2RemoteRoot.put(id, url);
            }
        }
        if (remoteRoots.isEmpty()) {
            System.err.println(String.format("WARNING: The repository %s ('%s') is not connected to any remote repository as client!", repositoryId, localRoot));
        } else if (filteredRemoteRepositoryId2RemoteRoot.isEmpty()) {
            System.err.println(String.format("WARNING: The repository %s ('%s') is not connected to the specified remote repository ('%s')!", repositoryId, localRoot, this.remote));
        } else {
            for (Map.Entry me : filteredRemoteRepositoryId2RemoteRoot.entrySet()) {
                UUID remoteRepositoryId = (UUID)me.getKey();
                URL remoteRoot = (URL)me.getValue();
                System.out.println("********************************************************************************");
                System.out.println(String.format("Syncing %s ('%s') with %s ('%s').", repositoryId, localRoot, remoteRepositoryId, remoteRoot));
                System.out.println("********************************************************************************");
                try (RepoToRepoSync repoToRepoSync = RepoToRepoSync.create((File)localRoot, (URL)remoteRoot);){
                    repoToRepoSync.sync((ProgressMonitor)new LoggerProgressMonitor(logger));
                }
            }
        }
    }

    private boolean isAll() {
        return "ALL".equals(this.local);
    }
}

