/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.test;

import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.server.CloudStoreServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class CloudStoreServerTestSupport {
    private static final SecureRandom random = new SecureRandom();
    private static final AtomicInteger cloudStoreServerStopTimerIndex = new AtomicInteger();
    private CloudStoreServer cloudStoreServer;
    private Thread cloudStoreServerThread;
    private final Object cloudStoreServerMutex = new Object();
    private final Timer cloudStoreServerStopTimer = new Timer("cloudStoreServerStopTimer-" + cloudStoreServerStopTimerIndex.incrementAndGet(), true);
    private TimerTask cloudStoreServerStopTimerTask;
    private int testInstanceCounter;
    private int securePort;

    public int getSecurePort() {
        return this.securePort;
    }

    public String getSecureUrl() {
        return "https://localhost:" + this.getSecurePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeClass() throws Exception {
        Object object = this.cloudStoreServerMutex;
        synchronized (object) {
            boolean first;
            boolean bl = first = this.testInstanceCounter++ == 0;
            if (this.cloudStoreServerStopTimerTask != null) {
                this.cloudStoreServerStopTimerTask.cancel();
                this.cloudStoreServerStopTimerTask = null;
            }
            if (this.cloudStoreServer == null) {
                IOUtil.deleteDirectoryRecursively((File)ConfigDir.getInstance().getFile());
                this.securePort = this.getRandomAvailableServerPort();
                this.cloudStoreServer = this.createCloudStoreServer();
                this.cloudStoreServer.setSecurePort(this.securePort);
                this.cloudStoreServerThread = new Thread((Runnable)this.cloudStoreServer);
                this.cloudStoreServerThread.setName("cloudStoreServerThread");
                this.cloudStoreServerThread.setDaemon(true);
                this.cloudStoreServerThread.start();
                this.waitForServerToOpenSecurePort();
            }
            return first;
        }
    }

    private int getRandomAvailableServerPort() throws IOException {
        ServerSocket serverSocket = new ServerSocket(0);
        int port = serverSocket.getLocalPort();
        serverSocket.close();
        return port;
    }

    protected CloudStoreServer createCloudStoreServer() {
        return new CloudStoreServer(new String[0]);
    }

    private void waitForServerToOpenSecurePort() {
        long timeoutMillis = 180000L;
        long begin = System.currentTimeMillis();
        while (true) {
            try {
                Socket socket = new Socket("localhost", this.getSecurePort());
                socket.close();
                return;
            }
            catch (Exception x) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - begin <= 180000L) continue;
                throw new IllegalStateException("Server did not start within timeout (ms): 180000");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean afterClass() throws Exception {
        Object object = this.cloudStoreServerMutex;
        synchronized (object) {
            if (--this.testInstanceCounter > 0) {
                return false;
            }
            if (this.cloudStoreServerStopTimerTask == null) {
                this.cloudStoreServerStopTimerTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = CloudStoreServerTestSupport.this.cloudStoreServerMutex;
                        synchronized (object) {
                            if (CloudStoreServerTestSupport.this.cloudStoreServer != null) {
                                CloudStoreServerTestSupport.this.cloudStoreServer.stop();
                                CloudStoreServerTestSupport.this.cloudStoreServer = null;
                                CloudStoreServerTestSupport.this.cloudStoreServerStopTimerTask = null;
                            }
                        }
                    }
                };
                this.cloudStoreServerStopTimer.schedule(this.cloudStoreServerStopTimerTask, 60000L);
            }
            return true;
        }
    }
}

