/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.util.childprocess;

import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.childprocess.LogDumpedStreamThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpStreamThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(DumpStreamThread.class);
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private volatile boolean ignoreErrors = false;
    private volatile boolean forceInterrupt = false;
    private final LogDumpedStreamThread logDumpedStreamThread;

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @Override
    public void interrupt() {
        this.forceInterrupt = true;
        super.interrupt();
    }

    @Override
    public boolean isInterrupted() {
        return this.forceInterrupt || super.isInterrupted();
    }

    public DumpStreamThread(InputStream inputStream, OutputStream outputStream, String childProcessLoggerName) {
        this(inputStream, outputStream, null, childProcessLoggerName);
    }

    public DumpStreamThread(InputStream inputStream, OutputStream outputStream, Logger childProcessLogger) {
        this(inputStream, outputStream, childProcessLogger, null);
    }

    private DumpStreamThread(InputStream inputStream, OutputStream outputStream, Logger childProcessLogger, String childProcessLoggerName) {
        AssertUtil.assertNotNull(inputStream, "inputStream");
        AssertUtil.assertNotNull(outputStream, "outputStream");
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.logDumpedStreamThread = childProcessLogger != null ? new LogDumpedStreamThread(childProcessLogger) : (childProcessLoggerName == null ? null : new LogDumpedStreamThread(childProcessLoggerName));
    }

    @Override
    public synchronized void start() {
        if (this.logDumpedStreamThread != null) {
            this.logDumpedStreamThread.start();
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            byte[] buffer = new byte[10240];
            while (!this.isInterrupted()) {
                try {
                    int bytesRead = this.inputStream.read(buffer);
                    if (bytesRead <= 0) continue;
                    this.outputStream.write(buffer, 0, bytesRead);
                    if (this.logDumpedStreamThread == null) continue;
                    this.logDumpedStreamThread.write(buffer, bytesRead);
                }
                catch (Throwable e) {
                    if (!this.ignoreErrors) {
                        this.logger.error("run: " + e, e);
                    } else {
                        this.logger.info("run: " + e);
                    }
                    if (this.logDumpedStreamThread != null) {
                        this.logDumpedStreamThread.interrupt();
                    }
                    try {
                        this.outputStream.close();
                        return;
                    }
                    catch (IOException e2) {
                        this.logger.warn("run: outputStream.close() failed: " + e2, (Throwable)e2);
                    }
                    return;
                }
            }
        }
        finally {
            if (this.logDumpedStreamThread != null) {
                this.logDumpedStreamThread.interrupt();
            }
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                this.logger.warn("run: outputStream.close() failed: " + e, (Throwable)e);
            }
        }
    }

    public void setOutputStringBuffer(StringBuffer outputStringBuffer) {
        if (this.logDumpedStreamThread == null) {
            throw new IllegalStateException("Not supported, if logging is disabled!");
        }
        this.logDumpedStreamThread.setOutputStringBuffer(outputStringBuffer);
    }

    public StringBuffer getOutputStringBuffer() {
        if (this.logDumpedStreamThread == null) {
            throw new IllegalStateException("Not supported, if logging is disabled!");
        }
        return this.logDumpedStreamThread.getOutputStringBuffer();
    }

    public void setOutputStringBufferMaxLength(int outputStringBufferMaxLength) {
        if (this.logDumpedStreamThread == null) {
            throw new IllegalStateException("Not supported, if logging is disabled!");
        }
        this.logDumpedStreamThread.setOutputStringBufferMaxLength(outputStringBufferMaxLength);
    }

    public int getOutputStringBufferMaxLength() {
        if (this.logDumpedStreamThread == null) {
            throw new IllegalStateException("Not supported, if logging is disabled!");
        }
        return this.logDumpedStreamThread.getOutputStringBufferMaxLength();
    }

    public void flushBuffer() {
        if (this.logDumpedStreamThread != null) {
            this.logDumpedStreamThread.flushBuffer();
        }
    }
}

