/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.RepoInfoSubCommand;
import co.codewizards.cloudstore.client.SubCommand;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.util.UUID;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class CreateRepoSubCommand
extends SubCommand {
    @Argument(metaVar="<localRoot>", required=true, usage="The path of the repository's root in the local file system. This must be an existing directory. If it does not exist and the '-createDir' option is set, it is automatically created.")
    private String localRoot;
    private File localRootFile;
    @Option(name="-createDir", required=false, usage="Whether to create the repository's root directory, if it does not yet exist. If specified, all parent-directories are created, too, if needed.")
    private boolean createDir;
    @Option(name="-noAlias", required=false, usage="Whether to suppress the automatic creation of a repository-alias with the local root's name.")
    private boolean noAlias;
    @Option(name="-alias", metaVar="<alias>", required=false, usage="Specify a different alias. By default, the root directory's name is used. For example, if the repository's root is '/home/user/Documents', the alias 'Documents' is chosen. If this option is present, the specified <alias> is used instead.")
    private String alias;

    @Override
    public String getSubCommandDescription() {
        return "Create a new repository.";
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.localRootFile = this.localRoot == null ? OioFileFactory.createFile((String)"").getAbsoluteFile() : OioFileFactory.createFile((String)this.localRoot).getAbsoluteFile();
        this.localRoot = this.localRootFile.getPath();
        if (!this.noAlias && (this.alias == null || this.alias.isEmpty())) {
            String simplified = IOUtil.simplifyPath((File)this.localRootFile);
            this.alias = OioFileFactory.createFile((String)simplified).getName();
        }
        if (this.alias != null && this.alias.isEmpty()) {
            this.alias = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.alias != null && this.noAlias) {
            System.err.println("ERROR: You specified both '-alias' and '-noAlias'. These options exclude each other and cannot be combined!");
            System.exit(101);
        }
        if (!this.localRootFile.exists() && this.createDir) {
            this.localRootFile.mkdirs();
            if (!this.localRootFile.exists()) {
                throw new IOException("Could not create directory (permissions?): " + this.localRoot);
            }
        }
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForNewRepository(this.localRootFile);){
            if (!this.noAlias && this.alias != null) {
                LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
                UUID oldRepositoryId = localRepoRegistry.getRepositoryId(this.alias);
                File oldLocalRoot = null;
                if (!(oldRepositoryId == null || (oldLocalRoot = localRepoRegistry.getLocalRoot(oldRepositoryId)) != null && oldLocalRoot.exists())) {
                    oldRepositoryId = null;
                    oldLocalRoot = null;
                }
                if (oldRepositoryId != null) {
                    System.err.println(String.format("WARNING: There is already a repository registered with the alias '%s'! Skipping automatic alias registration. The existing repository's ID is '%s' and its local-root is '%s'.", this.alias, oldRepositoryId, oldLocalRoot));
                } else {
                    localRepoManager.putRepositoryAlias(this.alias);
                }
            }
        }
        new RepoInfoSubCommand(this.localRootFile).run();
    }
}

