/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommand;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import org.kohsuke.args4j.Argument;

public abstract class SubCommandWithExistingLocalRepo
extends SubCommand {
    @Argument(metaVar="<local>", required=true, index=0, usage="A path inside a repository in the local file system or a repository-ID or a repository-alias (optionally with a path). If this matches both a locally existing directory and a repository-ID/-alias, it is assumed to be a repository-ID/-alias. Note, that it may be a sub-directory inside the repository specified in the form <repositoryId>/path (this must be a '/' even on Windows).")
    protected String local;
    protected String localPathPrefix;
    protected File localFile;
    protected File localRoot;

    @Override
    public void prepare() throws Exception {
        String repositoryName;
        super.prepare();
        AssertUtil.assertNotNull((Object)this.local, (String)"local");
        int slashIndex = this.local.indexOf(47);
        if (slashIndex < 0) {
            repositoryName = this.local;
            this.localPathPrefix = "";
        } else {
            repositoryName = this.local.substring(0, slashIndex);
            this.localPathPrefix = this.local.substring(slashIndex);
            if (!this.localPathPrefix.startsWith("/")) {
                throw new IllegalStateException("localPathPrefix does not start with '/': " + this.localPathPrefix);
            }
        }
        if ("/".equals(this.localPathPrefix)) {
            this.localPathPrefix = "";
        }
        this.localRoot = LocalRepoRegistryImpl.getInstance().getLocalRootForRepositoryName(repositoryName);
        if (this.localRoot != null) {
            this.localFile = this.localPathPrefix.isEmpty() ? this.localRoot : OioFileFactory.createFile((File)this.localRoot, (String[])new String[]{this.localPathPrefix});
        } else {
            this.localFile = OioFileFactory.createFile((String)this.local).getAbsoluteFile();
            this.localRoot = LocalRepoHelper.getLocalRootContainingFile((File)this.localFile);
            if (this.localRoot == null) {
                this.localRoot = this.localFile;
            }
            this.localPathPrefix = this.localRoot.equals(this.localFile) ? "" : IOUtil.getRelativePath((File)this.localRoot, (File)this.localFile).replace(OioFileFactory.FILE_SEPARATOR_CHAR, '/');
            if (!this.localPathPrefix.isEmpty() && !this.localPathPrefix.startsWith("/")) {
                this.localPathPrefix = "/" + this.localPathPrefix;
            }
        }
        this.assertLocalRootNotNull();
    }

    protected void assertLocalRootNotNull() {
        AssertUtil.assertNotNull((Object)this.localRoot, (String)"localRoot");
    }
}

