/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.core.invoke.ClassInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassManager {
    private static final Logger logger = LoggerFactory.getLogger(ClassManager.class);
    private final Uid clientId;
    private Map<Integer, Class<?>> classId2Class = new HashMap();
    private Map<Class<?>, Integer> class2ClassId = new HashMap();
    private Set<Integer> classIdsKnownByRemoteSide = new HashSet<Integer>();
    private Map<Integer, ClassInfo> classId2ClassInfo = new HashMap<Integer, ClassInfo>();
    private static final Map<String, Class<?>> primitiveClassName2Class;
    private int nextClassId;

    public ClassManager(Uid clientId) {
        this.clientId = (Uid)AssertUtil.assertNotNull((Object)clientId, (String)"clientId");
        logger.debug("[{}].<init>: Created ClassManager.", (Object)clientId);
    }

    public synchronized int getClassIdOrFail(Class<?> clazz) {
        int classId = this.getClassId(clazz);
        if (classId < 0) {
            throw new IllegalArgumentException(String.format("ClassManager[%s] does not have classId for this class: %s", this.clientId, clazz.getName()));
        }
        return classId;
    }

    public synchronized int getClassId(Class<?> clazz) {
        AssertUtil.assertNotNull(clazz, (String)"clazz");
        Integer classId = this.class2ClassId.get(clazz);
        if (classId == null) {
            return -1;
        }
        return classId;
    }

    public synchronized int getClassIdOrCreate(Class<?> clazz) {
        AssertUtil.assertNotNull(clazz, (String)"clazz");
        Integer classId = this.class2ClassId.get(clazz);
        if (classId == null) {
            classId = this.nextClassId();
            logger.debug("[{}].getClassIdOrCreate: Assigned classId={} to {}.", new Object[]{this.clientId, classId, clazz.getName()});
            this.class2ClassId.put(clazz, classId);
            this.classId2Class.put(classId, clazz);
        }
        return classId;
    }

    public synchronized Class<?> getClassOrFail(int classId) {
        Class<?> clazz = this.getClass(classId);
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("ClassManager[%s] does not have class for this classId: %s", this.clientId, classId));
        }
        return clazz;
    }

    public synchronized Class<?> getClass(int classId) {
        Class<?> clazz = this.classId2Class.get(classId);
        return clazz;
    }

    public synchronized boolean isClassIdKnownByRemoteSide(int classId) {
        boolean result = this.classIdsKnownByRemoteSide.contains(classId);
        return result;
    }

    public synchronized void setClassIdKnownByRemoteSide(int classId) {
        if (this.classIdsKnownByRemoteSide.add(classId)) {
            logger.debug("[{}].setClassIdKnownByRemoteSide: classId={}", (Object)this.clientId, (Object)classId);
        }
    }

    public synchronized ClassInfo getClassInfo(int classId) {
        ClassInfo classInfo = this.classId2ClassInfo.get(classId);
        if (classInfo == null) {
            Class<?> clazz = this.getClass(classId);
            if (clazz == null) {
                return null;
            }
            Set<String> interfaceNames = this.getInterfaceNames(clazz);
            classInfo = new ClassInfo(classId, clazz.getName(), interfaceNames, this.isEqualsOverridden(clazz));
            this.classId2ClassInfo.put(classId, classInfo);
        }
        return classInfo;
    }

    private boolean isEqualsOverridden(Class<?> clazz) {
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                return true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                Util.doNothing();
                continue;
            }
        }
        return false;
    }

    protected synchronized int nextClassId() {
        return this.nextClassId++;
    }

    protected Set<String> getInterfaceNames(Class<?> clazz) {
        AssertUtil.assertNotNull(clazz, (String)"clazz");
        LinkedHashSet<String> interfaceNames = new LinkedHashSet<String>();
        this.populateInterfaceNames(interfaceNames, clazz);
        return interfaceNames;
    }

    private void populateInterfaceNames(Set<String> interfaceNames, Class<?> clazz) {
        if (clazz.isInterface()) {
            interfaceNames.add(clazz.getName());
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            this.populateInterfaceNames(interfaceNames, iface);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class && superclass != null) {
            this.populateInterfaceNames(interfaceNames, superclass);
        }
    }

    public Class<?>[] getClassesOrFail(String[] classNames) {
        AssertUtil.assertNotNull((Object)classNames, (String)"classNames");
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            classes[i] = this.getClassOrFail(classNames[i]);
        }
        return classes;
    }

    public Class<?> getClassOrFail(String className) {
        AssertUtil.assertNotNull((Object)className, (String)"className");
        Class<?> clazz = primitiveClassName2Class.get(className);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return clazz;
    }

    static {
        Class[] primitives = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Character.TYPE, Boolean.TYPE};
        HashMap<String, Class> m = new HashMap<String, Class>(primitives.length);
        for (Class clazz : primitives) {
            m.put(clazz.getName(), clazz);
        }
        primitiveClassName2Class = Collections.unmodifiableMap(m);
    }
}

