/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.util.Arrays;
import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;

public class FederalInformationProcessingStandard202 {
    public static final short SECURE_HASH_ALGORITHM_KECCAK_128_RATE = 168;
    public static final short SECURE_HASH_ALGORITHM_KECCAK_256_RATE = 136;
    public static final short SECURE_HASH_ALGORITHM_3_256_RATE = 136;
    public static final short NUMBER_OF_ROUND = 24;
    public static final long[] KECCAK_F_ROUND_CONSTANT = new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L};
    private CommonFunction function = new CommonFunction();

    private long leftRotation(long number, short offset) {
        return number << offset ^ number >>> 64 - offset;
    }

    private void thetaStep1(long[] C, long[] A) {
        for (int i = 0; i < 25; i = (int)((short)(i + 1))) {
            int n = i % 5;
            C[n] = C[n] ^ A[i];
        }
    }

    private void thetaStep2(long[] D, long[] C) {
        for (int i = 0; i < 5; i = (int)((short)(i + 1))) {
            D[i] = C[(i + 4) % 5] ^ this.leftRotation(C[(i + 1) % 5], (short)1);
        }
    }

    private void chi(long[] E, long[] C, short begin, short end) {
        for (int i = begin; i < end; ++i) {
            E[i] = C[i % 5] ^ (C[(i + 1) % 5] ^ 0xFFFFFFFFFFFFFFFFL) & C[(i + 2) % 5];
        }
    }

    private void statePermutation(long[] A, long[] C, long[] D, long[] E, short round) {
        this.thetaStep1(C, A);
        this.thetaStep2(D, C);
        A[0] = A[0] ^ D[0];
        C[0] = A[0];
        A[6] = A[6] ^ D[1];
        C[1] = this.leftRotation(A[6], (short)44);
        A[12] = A[12] ^ D[2];
        C[2] = this.leftRotation(A[12], (short)43);
        A[18] = A[18] ^ D[3];
        C[3] = this.leftRotation(A[18], (short)21);
        A[24] = A[24] ^ D[4];
        C[4] = this.leftRotation(A[24], (short)14);
        this.chi(E, C, (short)0, (short)5);
        E[0] = E[0] ^ KECCAK_F_ROUND_CONSTANT[round];
        A[3] = A[3] ^ D[3];
        C[0] = this.leftRotation(A[3], (short)28);
        A[9] = A[9] ^ D[4];
        C[1] = this.leftRotation(A[9], (short)20);
        A[10] = A[10] ^ D[0];
        C[2] = this.leftRotation(A[10], (short)3);
        A[16] = A[16] ^ D[1];
        C[3] = this.leftRotation(A[16], (short)45);
        A[22] = A[22] ^ D[2];
        C[4] = this.leftRotation(A[22], (short)61);
        this.chi(E, C, (short)5, (short)10);
        A[1] = A[1] ^ D[1];
        C[0] = this.leftRotation(A[1], (short)1);
        A[7] = A[7] ^ D[2];
        C[1] = this.leftRotation(A[7], (short)6);
        A[13] = A[13] ^ D[3];
        C[2] = this.leftRotation(A[13], (short)25);
        A[19] = A[19] ^ D[4];
        C[3] = this.leftRotation(A[19], (short)8);
        A[20] = A[20] ^ D[0];
        C[4] = this.leftRotation(A[20], (short)18);
        this.chi(E, C, (short)10, (short)15);
        A[4] = A[4] ^ D[4];
        C[0] = this.leftRotation(A[4], (short)27);
        A[5] = A[5] ^ D[0];
        C[1] = this.leftRotation(A[5], (short)36);
        A[11] = A[11] ^ D[1];
        C[2] = this.leftRotation(A[11], (short)10);
        A[17] = A[17] ^ D[2];
        C[3] = this.leftRotation(A[17], (short)15);
        A[23] = A[23] ^ D[3];
        C[4] = this.leftRotation(A[23], (short)56);
        this.chi(E, C, (short)15, (short)20);
        A[2] = A[2] ^ D[2];
        C[0] = this.leftRotation(A[2], (short)62);
        A[8] = A[8] ^ D[3];
        C[1] = this.leftRotation(A[8], (short)55);
        A[14] = A[14] ^ D[4];
        C[2] = this.leftRotation(A[14], (short)39);
        A[15] = A[15] ^ D[0];
        C[3] = this.leftRotation(A[15], (short)41);
        A[21] = A[21] ^ D[1];
        C[4] = this.leftRotation(A[21], (short)2);
        this.chi(E, C, (short)20, (short)25);
    }

    private void keccakF1600StatePermution(long[] state) {
        long[] C = new long[5];
        long[] D = new long[5];
        long[] E = new long[25];
        for (short round = 0; round < 24; round = (short)(round + 2)) {
            this.statePermutation(state, C, D, E, round);
            this.statePermutation(E, C, D, state, (short)(round + 1));
        }
    }

    private void keccakAbsorb(long[] state, short rate, byte[] message, int messageOffset, int messageLength, byte p) {
        int i;
        byte[] T = new byte[200];
        while (messageLength >= rate) {
            for (i = 0; i < rate / 8; i = (int)((short)(i + 1))) {
                int n = i;
                state[n] = state[n] ^ this.function.load64(message, messageOffset + 8 * i);
            }
            this.keccakF1600StatePermution(state);
            messageLength -= rate;
            messageOffset += rate;
        }
        Arrays.fill(T, 0, (int)rate, (byte)0);
        this.function.memoryCopy(T, 0, message, messageOffset, messageLength);
        T[messageLength] = p;
        int n = rate - 1;
        T[n] = (byte)(T[n] | 0x10000000);
        for (i = 0; i < rate / 8; i = (int)((short)(i + 1))) {
            int n2 = i;
            state[n2] = state[n2] ^ this.function.load64(T, 8 * i);
        }
    }

    private void keccakSqueezeBlock(byte[] output, short outputOffset, short numberOfBlock, long[] state, short rate) {
        while (numberOfBlock > 0) {
            this.keccakF1600StatePermution(state);
            for (int i = 0; i < rate >>> 3; i = (int)((short)(i + 1))) {
                this.function.store64(output, outputOffset + 8 * i, state[i]);
            }
            outputOffset = (short)(outputOffset + rate);
            numberOfBlock = (short)(numberOfBlock - 1);
        }
    }

    public void secureHashAlgorithmKECCAK128Absorb(long[] state, byte[] input, int inputOffset, int byteLengthOfInput) {
        this.keccakAbsorb(state, (short)168, input, inputOffset, byteLengthOfInput, (byte)31);
    }

    public void secureHashAlgorithmKECCAK256Absorb(long[] state, byte[] input, int inputOffset, int byteLengthOfInput) {
        this.keccakAbsorb(state, (short)136, input, inputOffset, byteLengthOfInput, (byte)31);
    }

    public void secureHashAlgorithmKECCAK128SqueezeBlock(byte[] output, short outputOffset, short numberOfBlock, long[] state) {
        this.keccakSqueezeBlock(output, outputOffset, numberOfBlock, state, (short)168);
    }

    public void secureHashAlgorithmKECCAK256SqueezeBlock(byte[] output, short outputOffset, short numberOfBlock, long[] state) {
        this.keccakSqueezeBlock(output, outputOffset, numberOfBlock, state, (short)136);
    }

    private void secureHashAlgorithmKECCAK(byte[] output, short outputOffset, short outputLength, byte[] input, int inputOffset, int inputLength, short rate) {
        long[] state = new long[25];
        byte[] T = new byte[rate];
        short numberOfBlock = (short)(outputLength / rate);
        short tOffset = 0;
        Arrays.fill(state, 0L);
        this.keccakAbsorb(state, rate, input, inputOffset, inputLength, (byte)31);
        this.keccakSqueezeBlock(output, outputOffset, numberOfBlock, state, rate);
        outputOffset = (short)(outputOffset + numberOfBlock * rate);
        outputLength = (short)(outputLength - numberOfBlock * rate);
        if (outputLength > 0) {
            this.keccakSqueezeBlock(T, tOffset, (short)1, state, rate);
            for (int i = 0; i < outputLength; ++i) {
                output[outputOffset + i] = T[tOffset + i];
            }
        }
    }

    public void secureHashAlgorithmKECCAK128(byte[] output, short outputOffset, short outputLength, byte[] input, int inputOffset, int inputLength) {
        this.secureHashAlgorithmKECCAK(output, outputOffset, outputLength, input, inputOffset, inputLength, (short)168);
    }

    public void secureHashAlgorithmKECCAK256(byte[] output, short outputOffset, short outputLength, byte[] input, int inputOffset, int inputLength) {
        this.secureHashAlgorithmKECCAK(output, outputOffset, outputLength, input, inputOffset, inputLength, (short)136);
    }

    private void customizableSecureHashAlgorithmKECCAKSimpleAbsorb(long[] state, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength, long firstState, short rate) {
        Arrays.fill(state, 0L);
        state[0] = firstState;
        state[0] = state[0] ^ (long)continuousTimeStochasticModelling << 48;
        this.keccakF1600StatePermution(state);
        this.keccakAbsorb(state, rate, input, inputOffset, inputLength, (byte)4);
    }

    public void customizableSecureHashAlgorithmKECCAK128SimpleAbsorb(long[] state, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength) {
        this.customizableSecureHashAlgorithmKECCAKSimpleAbsorb(state, continuousTimeStochasticModelling, input, inputOffset, inputLength, 17596481120257L, (short)168);
    }

    public void customizableSecureHashAlgorithmKECCAK256SimpleAbsorb(long[] state, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength) {
        this.customizableSecureHashAlgorithmKECCAKSimpleAbsorb(state, continuousTimeStochasticModelling, input, inputOffset, inputLength, 0x100100018801L, (short)136);
    }

    public void customizableSecureHashAlgorithmKECCAK128SimpleSqueezeBlock(byte[] output, short outputOffset, short numberOfBlock, long[] state) {
        this.keccakSqueezeBlock(output, outputOffset, numberOfBlock, state, (short)168);
    }

    public void customizableSecureHashAlgorithmKECCAK256SimpleSqueezeBlock(byte[] output, short outputOffset, short numberOfBlock, long[] state) {
        this.keccakSqueezeBlock(output, outputOffset, numberOfBlock, state, (short)136);
    }

    private void customizableSecureHashAlgorithmKECCAKSimple(byte[] output, short outputOffset, short outputLength, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength, long firstState, short rate) {
        long[] state = new long[25];
        byte[] T = new byte[rate];
        short tOffset = 0;
        this.customizableSecureHashAlgorithmKECCAKSimpleAbsorb(state, continuousTimeStochasticModelling, input, inputOffset, inputLength, firstState, rate);
        this.keccakSqueezeBlock(output, outputOffset, (short)(outputLength / rate), state, rate);
        outputOffset = (short)(outputOffset + outputLength / rate * rate);
        if (outputLength % rate != 0) {
            this.keccakSqueezeBlock(T, tOffset, (short)1, state, rate);
            for (int i = 0; i < outputLength % rate; ++i) {
                output[outputOffset + i] = T[tOffset + i];
            }
        }
    }

    public void customizableSecureHashAlgorithmKECCAK128Simple(byte[] output, short outputOffset, short outputLength, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength) {
        this.customizableSecureHashAlgorithmKECCAKSimple(output, outputOffset, outputLength, continuousTimeStochasticModelling, input, inputOffset, inputLength, 17596481120257L, (short)168);
    }

    public void customizableSecureHashAlgorithmKECCAK256Simple(byte[] output, short outputOffset, short outputLength, short continuousTimeStochasticModelling, byte[] input, int inputOffset, int inputLength) {
        this.customizableSecureHashAlgorithmKECCAKSimple(output, outputOffset, outputLength, continuousTimeStochasticModelling, input, inputOffset, inputLength, 0x100100018801L, (short)136);
    }
}

