/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;
import org.bouncycastle.pqc.crypto.qtesla.FederalInformationProcessingStandard202;
import org.bouncycastle.pqc.crypto.qtesla.Polynomial;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialHeuristic;
import org.bouncycastle.pqc.crypto.qtesla.PolynomialProvablySecure;
import org.bouncycastle.pqc.crypto.qtesla.Sample;

public class QTESLA {
    private static CommonFunction function = new CommonFunction();
    private static FederalInformationProcessingStandard202 fips = new FederalInformationProcessingStandard202();
    private static Polynomial polynomial = new Polynomial();
    private SecureRandom random;
    private Sample sample;

    public QTESLA() {
        this.random = new SecureRandom();
        this.sample = new Sample();
    }

    public QTESLA(SecureRandom random) {
        this.random = random;
        this.sample = new Sample();
    }

    private static void packSecretKey(byte[] secretKey, long[] secretPolynomial, long[] errorPolynomial, byte[] seed, int seedOffset, short n) {
        int i;
        for (i = 0; i < n * 16 / 8; i = (int)((short)(i + 2))) {
            function.store16(secretKey, i, (short)secretPolynomial[i / 2]);
        }
        for (i = 0; i < n * 16 / 8; i = (int)((short)(i + 2))) {
            function.store16(secretKey, i + n * 16 / 8, (short)errorPolynomial[i / 2]);
        }
        function.memoryCopy(secretKey, n * 16 / 8 * 2, seed, seedOffset, 64);
    }

    private static void packSecretKey(byte[] secretKey, long[] secretPolynomial, long[] errorPolynomial, byte[] seed, int seedOffset, short n, short k) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            secretKey[i] = (byte)secretPolynomial[i];
        }
        for (short j = 0; j < k; j = (short)(j + 1)) {
            for (short i = 0; i < n; i = (short)(i + 1)) {
                secretKey[n + j * n + i] = (byte)errorPolynomial[j * n + i];
            }
        }
        function.memoryCopy(secretKey, (k + 1) * n, seed, seedOffset, 64);
    }

    private static void encodePublicKey(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset, short n, short qLogarithm) {
        int j = 0;
        int i = 0;
        while (i < n * qLogarithm / 32) {
            function.store32(publicKey, 4 * (i + 0), (int)(T[j + 0] | T[j + 1] << 23));
            function.store32(publicKey, 4 * (i + 1), (int)(T[j + 1] >> 9 | T[j + 2] << 14));
            function.store32(publicKey, 4 * (i + 2), (int)(T[j + 2] >> 18 | T[j + 3] << 5 | T[j + 4] << 28));
            function.store32(publicKey, 4 * (i + 3), (int)(T[j + 4] >> 4 | T[j + 5] << 19));
            function.store32(publicKey, 4 * (i + 4), (int)(T[j + 5] >> 13 | T[j + 6] << 10));
            function.store32(publicKey, 4 * (i + 5), (int)(T[j + 6] >> 22 | T[j + 7] << 1 | T[j + 8] << 24));
            function.store32(publicKey, 4 * (i + 6), (int)(T[j + 8] >> 8 | T[j + 9] << 15));
            function.store32(publicKey, 4 * (i + 7), (int)(T[j + 9] >> 17 | T[j + 10] << 6 | T[j + 11] << 29));
            function.store32(publicKey, 4 * (i + 8), (int)(T[j + 11] >> 3 | T[j + 12] << 20));
            function.store32(publicKey, 4 * (i + 9), (int)(T[j + 12] >> 12 | T[j + 13] << 11));
            function.store32(publicKey, 4 * (i + 10), (int)(T[j + 13] >> 21 | T[j + 14] << 2 | T[j + 15] << 25));
            function.store32(publicKey, 4 * (i + 11), (int)(T[j + 15] >> 7 | T[j + 16] << 16));
            function.store32(publicKey, 4 * (i + 12), (int)(T[j + 16] >> 16 | T[j + 17] << 7 | T[j + 18] << 30));
            function.store32(publicKey, 4 * (i + 13), (int)(T[j + 18] >> 2 | T[j + 19] << 21));
            function.store32(publicKey, 4 * (i + 14), (int)(T[j + 19] >> 11 | T[j + 20] << 12));
            function.store32(publicKey, 4 * (i + 15), (int)(T[j + 20] >> 20 | T[j + 21] << 3 | T[j + 22] << 26));
            function.store32(publicKey, 4 * (i + 16), (int)(T[j + 22] >> 6 | T[j + 23] << 17));
            function.store32(publicKey, 4 * (i + 17), (int)(T[j + 23] >> 15 | T[j + 24] << 8 | T[j + 25] << 31));
            function.store32(publicKey, 4 * (i + 18), (int)(T[j + 25] >> 1 | T[j + 26] << 22));
            function.store32(publicKey, 4 * (i + 19), (int)(T[j + 26] >> 10 | T[j + 27] << 13));
            function.store32(publicKey, 4 * (i + 20), (int)(T[j + 27] >> 19 | T[j + 28] << 4 | T[j + 29] << 27));
            function.store32(publicKey, 4 * (i + 21), (int)(T[j + 29] >> 5 | T[j + 30] << 18));
            function.store32(publicKey, 4 * (i + 22), (int)(T[j + 30] >> 14 | T[j + 31] << 9));
            j = (short)(j + 32);
            i = (short)(i + qLogarithm);
        }
        function.memoryCopy(publicKey, n * qLogarithm / 8, seedA, seedAOffset, 32);
    }

    private static void encodePublicKeyIIISpeed(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 768; i = (int)((short)(i + 3))) {
            function.store32(publicKey, 4 * (i + 0), (int)(T[j + 0] | T[j + 1] << 24));
            function.store32(publicKey, 4 * (i + 1), (int)(T[j + 1] >> 8 | T[j + 2] << 16));
            function.store32(publicKey, 4 * (i + 2), (int)(T[j + 2] >> 16 | T[j + 3] << 8));
            j = (short)(j + 4);
        }
        function.memoryCopy(publicKey, 3072, seedA, seedAOffset, 32);
    }

    private static void encodePublicKeyIP(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 3712; i = (int)((short)(i + 29))) {
            function.store32(publicKey, 4 * (i + 0), (int)(T[j + 0] | T[j + 1] << 29));
            function.store32(publicKey, 4 * (i + 1), (int)(T[j + 1] >> 3 | T[j + 2] << 26));
            function.store32(publicKey, 4 * (i + 2), (int)(T[j + 2] >> 6 | T[j + 3] << 23));
            function.store32(publicKey, 4 * (i + 3), (int)(T[j + 3] >> 9 | T[j + 4] << 20));
            function.store32(publicKey, 4 * (i + 4), (int)(T[j + 4] >> 12 | T[j + 5] << 17));
            function.store32(publicKey, 4 * (i + 5), (int)(T[j + 5] >> 15 | T[j + 6] << 14));
            function.store32(publicKey, 4 * (i + 6), (int)(T[j + 6] >> 18 | T[j + 7] << 11));
            function.store32(publicKey, 4 * (i + 7), (int)(T[j + 7] >> 21 | T[j + 8] << 8));
            function.store32(publicKey, 4 * (i + 8), (int)(T[j + 8] >> 24 | T[j + 9] << 5));
            function.store32(publicKey, 4 * (i + 9), (int)(T[j + 9] >> 27 | T[j + 10] << 2 | T[j + 11] << 31));
            function.store32(publicKey, 4 * (i + 10), (int)(T[j + 11] >> 1 | T[j + 12] << 28));
            function.store32(publicKey, 4 * (i + 11), (int)(T[j + 12] >> 4 | T[j + 13] << 25));
            function.store32(publicKey, 4 * (i + 12), (int)(T[j + 13] >> 7 | T[j + 14] << 22));
            function.store32(publicKey, 4 * (i + 13), (int)(T[j + 14] >> 10 | T[j + 15] << 19));
            function.store32(publicKey, 4 * (i + 14), (int)(T[j + 15] >> 13 | T[j + 16] << 16));
            function.store32(publicKey, 4 * (i + 15), (int)(T[j + 16] >> 16 | T[j + 17] << 13));
            function.store32(publicKey, 4 * (i + 16), (int)(T[j + 17] >> 19 | T[j + 18] << 10));
            function.store32(publicKey, 4 * (i + 17), (int)(T[j + 18] >> 22 | T[j + 19] << 7));
            function.store32(publicKey, 4 * (i + 18), (int)(T[j + 19] >> 25 | T[j + 20] << 4));
            function.store32(publicKey, 4 * (i + 19), (int)(T[j + 20] >> 28 | T[j + 21] << 1 | T[j + 22] << 30));
            function.store32(publicKey, 4 * (i + 20), (int)(T[j + 22] >> 2 | T[j + 23] << 27));
            function.store32(publicKey, 4 * (i + 21), (int)(T[j + 23] >> 5 | T[j + 24] << 24));
            function.store32(publicKey, 4 * (i + 22), (int)(T[j + 24] >> 8 | T[j + 25] << 21));
            function.store32(publicKey, 4 * (i + 23), (int)(T[j + 25] >> 11 | T[j + 26] << 18));
            function.store32(publicKey, 4 * (i + 24), (int)(T[j + 26] >> 14 | T[j + 27] << 15));
            function.store32(publicKey, 4 * (i + 25), (int)(T[j + 27] >> 17 | T[j + 28] << 12));
            function.store32(publicKey, 4 * (i + 26), (int)(T[j + 28] >> 20 | T[j + 29] << 9));
            function.store32(publicKey, 4 * (i + 27), (int)(T[j + 29] >> 23 | T[j + 30] << 6));
            function.store32(publicKey, 4 * (i + 28), (int)(T[j + 30] >> 26 | T[j + 31] << 3));
            j = (short)(j + 32);
        }
        function.memoryCopy(publicKey, 14848, seedA, seedAOffset, 32);
    }

    private static void encodePublicKeyIIIP(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 9920; i = (int)((short)(i + 31))) {
            for (int index = 0; index < 31; index = (int)((short)(index + 1))) {
                function.store32(publicKey, 4 * (i + index), (int)(T[j + index] >> index | T[j + index + 1] << 31 - index));
            }
            j = (short)(j + 32);
        }
        function.memoryCopy(publicKey, 14848, seedA, seedAOffset, 32);
    }

    private static void decodePublicKey(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput, short n, short qLogarithm) {
        int j = 0;
        int mask = (1 << qLogarithm) - 1;
        for (short i = 0; i < n; i = (short)(i + 32)) {
            publicKey[i + 0] = function.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (function.load32(publicKeyInput, 4 * (j + 0)) >>> 23 | function.load32(publicKeyInput, 4 * (j + 1)) << 9) & mask;
            publicKey[i + 2] = (function.load32(publicKeyInput, 4 * (j + 1)) >>> 14 | function.load32(publicKeyInput, 4 * (j + 2)) << 18) & mask;
            publicKey[i + 3] = function.load32(publicKeyInput, 4 * (j + 2)) >>> 5 & mask;
            publicKey[i + 4] = (function.load32(publicKeyInput, 4 * (j + 2)) >>> 28 | function.load32(publicKeyInput, 4 * (j + 3)) << 4) & mask;
            publicKey[i + 5] = (function.load32(publicKeyInput, 4 * (j + 3)) >>> 19 | function.load32(publicKeyInput, 4 * (j + 4)) << 13) & mask;
            publicKey[i + 6] = (function.load32(publicKeyInput, 4 * (j + 4)) >>> 10 | function.load32(publicKeyInput, 4 * (j + 5)) << 22) & mask;
            publicKey[i + 7] = function.load32(publicKeyInput, 4 * (j + 5)) >>> 1 & mask;
            publicKey[i + 8] = (function.load32(publicKeyInput, 4 * (j + 5)) >>> 24 | function.load32(publicKeyInput, 4 * (j + 6)) << 8) & mask;
            publicKey[i + 9] = (function.load32(publicKeyInput, 4 * (j + 6)) >>> 15 | function.load32(publicKeyInput, 4 * (j + 7)) << 17) & mask;
            publicKey[i + 10] = function.load32(publicKeyInput, 4 * (j + 7)) >>> 6 & mask;
            publicKey[i + 11] = (function.load32(publicKeyInput, 4 * (j + 7)) >>> 29 | function.load32(publicKeyInput, 4 * (j + 8)) << 3) & mask;
            publicKey[i + 12] = (function.load32(publicKeyInput, 4 * (j + 8)) >>> 20 | function.load32(publicKeyInput, 4 * (j + 9)) << 12) & mask;
            publicKey[i + 13] = (function.load32(publicKeyInput, 4 * (j + 9)) >>> 11 | function.load32(publicKeyInput, 4 * (j + 10)) << 21) & mask;
            publicKey[i + 14] = function.load32(publicKeyInput, 4 * (j + 10)) >>> 2 & mask;
            publicKey[i + 15] = (function.load32(publicKeyInput, 4 * (j + 10)) >>> 25 | function.load32(publicKeyInput, 4 * (j + 11)) << 7) & mask;
            publicKey[i + 16] = (function.load32(publicKeyInput, 4 * (j + 11)) >>> 16 | function.load32(publicKeyInput, 4 * (j + 12)) << 16) & mask;
            publicKey[i + 17] = function.load32(publicKeyInput, 4 * (j + 12)) >>> 7 & mask;
            publicKey[i + 18] = (function.load32(publicKeyInput, 4 * (j + 12)) >>> 30 | function.load32(publicKeyInput, 4 * (j + 13)) << 2) & mask;
            publicKey[i + 19] = (function.load32(publicKeyInput, 4 * (j + 13)) >>> 21 | function.load32(publicKeyInput, 4 * (j + 14)) << 11) & mask;
            publicKey[i + 20] = (function.load32(publicKeyInput, 4 * (j + 14)) >>> 12 | function.load32(publicKeyInput, 4 * (j + 15)) << 20) & mask;
            publicKey[i + 21] = function.load32(publicKeyInput, 4 * (j + 15)) >>> 3 & mask;
            publicKey[i + 22] = (function.load32(publicKeyInput, 4 * (j + 15)) >>> 26 | function.load32(publicKeyInput, 4 * (j + 16)) << 6) & mask;
            publicKey[i + 23] = (function.load32(publicKeyInput, 4 * (j + 16)) >>> 17 | function.load32(publicKeyInput, 4 * (j + 17)) << 15) & mask;
            publicKey[i + 24] = function.load32(publicKeyInput, 4 * (j + 17)) >>> 8 & mask;
            publicKey[i + 25] = (function.load32(publicKeyInput, 4 * (j + 17)) >>> 31 | function.load32(publicKeyInput, 4 * (j + 18)) << 1) & mask;
            publicKey[i + 26] = (function.load32(publicKeyInput, 4 * (j + 18)) >>> 22 | function.load32(publicKeyInput, 4 * (j + 19)) << 10) & mask;
            publicKey[i + 27] = (function.load32(publicKeyInput, 4 * (j + 19)) >>> 13 | function.load32(publicKeyInput, 4 * (j + 20)) << 19) & mask;
            publicKey[i + 28] = function.load32(publicKeyInput, 4 * (j + 20)) >>> 4 & mask;
            publicKey[i + 29] = (function.load32(publicKeyInput, 4 * (j + 20)) >>> 27 | function.load32(publicKeyInput, 4 * (j + 21)) << 5) & mask;
            publicKey[i + 30] = (function.load32(publicKeyInput, 4 * (j + 21)) >>> 18 | function.load32(publicKeyInput, 4 * (j + 22)) << 14) & mask;
            publicKey[i + 31] = function.load32(publicKeyInput, 4 * (j + 22)) >>> 9;
            j = (short)(j + qLogarithm);
        }
        function.memoryCopy(seedA, seedAOffset, publicKeyInput, n * qLogarithm / 8, 32);
    }

    private static void decodePublicKeyIIISpeed(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = 0xFFFFFF;
        for (int i = 0; i < 1024; i = (int)((short)(i + 4))) {
            publicKey[i + 0] = function.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (function.load32(publicKeyInput, 4 * (j + 0)) >>> 24 | function.load32(publicKeyInput, 4 * (j + 1)) << 8) & mask;
            publicKey[i + 2] = (function.load32(publicKeyInput, 4 * (j + 1)) >>> 16 | function.load32(publicKeyInput, 4 * (j + 2)) << 16) & mask;
            publicKey[i + 3] = function.load32(publicKeyInput, 4 * (j + 2)) >>> 8;
            j = (short)(j + 3);
        }
        function.memoryCopy(seedA, seedAOffset, publicKeyInput, 3072, 32);
    }

    private static void decodePublicKeyIP(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = 0x1FFFFFFF;
        for (int i = 0; i < 4096; i = (int)((short)(i + 32))) {
            publicKey[i + 0] = function.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (function.load32(publicKeyInput, 4 * (j + 0)) >>> 29 | function.load32(publicKeyInput, 4 * (j + 1)) << 3) & mask;
            publicKey[i + 2] = (function.load32(publicKeyInput, 4 * (j + 1)) >>> 26 | function.load32(publicKeyInput, 4 * (j + 2)) << 6) & mask;
            publicKey[i + 3] = (function.load32(publicKeyInput, 4 * (j + 2)) >>> 23 | function.load32(publicKeyInput, 4 * (j + 3)) << 9) & mask;
            publicKey[i + 4] = (function.load32(publicKeyInput, 4 * (j + 3)) >>> 20 | function.load32(publicKeyInput, 4 * (j + 4)) << 12) & mask;
            publicKey[i + 5] = (function.load32(publicKeyInput, 4 * (j + 4)) >>> 17 | function.load32(publicKeyInput, 4 * (j + 5)) << 15) & mask;
            publicKey[i + 6] = (function.load32(publicKeyInput, 4 * (j + 5)) >>> 14 | function.load32(publicKeyInput, 4 * (j + 6)) << 18) & mask;
            publicKey[i + 7] = (function.load32(publicKeyInput, 4 * (j + 6)) >>> 11 | function.load32(publicKeyInput, 4 * (j + 7)) << 21) & mask;
            publicKey[i + 8] = (function.load32(publicKeyInput, 4 * (j + 7)) >>> 8 | function.load32(publicKeyInput, 4 * (j + 8)) << 24) & mask;
            publicKey[i + 9] = (function.load32(publicKeyInput, 4 * (j + 8)) >>> 5 | function.load32(publicKeyInput, 4 * (j + 9)) << 27) & mask;
            publicKey[i + 10] = function.load32(publicKeyInput, 4 * (j + 9)) >>> 2 & mask;
            publicKey[i + 11] = (function.load32(publicKeyInput, 4 * (j + 9)) >>> 31 | function.load32(publicKeyInput, 4 * (j + 10)) << 1) & mask;
            publicKey[i + 12] = (function.load32(publicKeyInput, 4 * (j + 10)) >>> 28 | function.load32(publicKeyInput, 4 * (j + 11)) << 4) & mask;
            publicKey[i + 13] = (function.load32(publicKeyInput, 4 * (j + 11)) >>> 25 | function.load32(publicKeyInput, 4 * (j + 12)) << 7) & mask;
            publicKey[i + 14] = (function.load32(publicKeyInput, 4 * (j + 12)) >>> 22 | function.load32(publicKeyInput, 4 * (j + 13)) << 10) & mask;
            publicKey[i + 15] = (function.load32(publicKeyInput, 4 * (j + 13)) >>> 19 | function.load32(publicKeyInput, 4 * (j + 14)) << 13) & mask;
            publicKey[i + 16] = (function.load32(publicKeyInput, 4 * (j + 14)) >>> 16 | function.load32(publicKeyInput, 4 * (j + 15)) << 16) & mask;
            publicKey[i + 17] = (function.load32(publicKeyInput, 4 * (j + 15)) >>> 13 | function.load32(publicKeyInput, 4 * (j + 16)) << 19) & mask;
            publicKey[i + 18] = (function.load32(publicKeyInput, 4 * (j + 16)) >>> 10 | function.load32(publicKeyInput, 4 * (j + 17)) << 22) & mask;
            publicKey[i + 19] = (function.load32(publicKeyInput, 4 * (j + 17)) >>> 7 | function.load32(publicKeyInput, 4 * (j + 18)) << 25) & mask;
            publicKey[i + 20] = (function.load32(publicKeyInput, 4 * (j + 18)) >>> 4 | function.load32(publicKeyInput, 4 * (j + 19)) << 28) & mask;
            publicKey[i + 21] = function.load32(publicKeyInput, 4 * (j + 19)) >>> 1 & mask;
            publicKey[i + 22] = (function.load32(publicKeyInput, 4 * (j + 19)) >>> 30 | function.load32(publicKeyInput, 4 * (j + 20)) << 2) & mask;
            publicKey[i + 23] = (function.load32(publicKeyInput, 4 * (j + 20)) >>> 27 | function.load32(publicKeyInput, 4 * (j + 21)) << 5) & mask;
            publicKey[i + 24] = (function.load32(publicKeyInput, 4 * (j + 21)) >>> 24 | function.load32(publicKeyInput, 4 * (j + 22)) << 8) & mask;
            publicKey[i + 25] = (function.load32(publicKeyInput, 4 * (j + 22)) >>> 21 | function.load32(publicKeyInput, 4 * (j + 23)) << 11) & mask;
            publicKey[i + 26] = (function.load32(publicKeyInput, 4 * (j + 23)) >>> 18 | function.load32(publicKeyInput, 4 * (j + 24)) << 14) & mask;
            publicKey[i + 27] = (function.load32(publicKeyInput, 4 * (j + 24)) >>> 15 | function.load32(publicKeyInput, 4 * (j + 25)) << 17) & mask;
            publicKey[i + 28] = (function.load32(publicKeyInput, 4 * (j + 25)) >>> 12 | function.load32(publicKeyInput, 4 * (j + 26)) << 20) & mask;
            publicKey[i + 29] = (function.load32(publicKeyInput, 4 * (j + 26)) >>> 9 | function.load32(publicKeyInput, 4 * (j + 27)) << 23) & mask;
            publicKey[i + 30] = (function.load32(publicKeyInput, 4 * (j + 27)) >>> 6 | function.load32(publicKeyInput, 4 * (j + 28)) << 26) & mask;
            publicKey[i + 31] = function.load32(publicKeyInput, 4 * (j + 28)) >>> 3;
            j = (short)(j + 29);
        }
        function.memoryCopy(seedA, seedAOffset, publicKeyInput, 14848, 32);
    }

    private static void decodePublicKeyIIIP(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = Integer.MAX_VALUE;
        for (int i = 0; i < 10240; i = (int)((short)(i + 32))) {
            publicKey[i] = function.load32(publicKeyInput, 4 * j) & mask;
            for (int index = 1; index < 31; index = (int)((short)(index + 1))) {
                publicKey[i + index] = (function.load32(publicKeyInput, 4 * (j + index - 1)) >>> 32 - index | function.load32(publicKeyInput, 4 * (j + index)) << index) & mask;
            }
            publicKey[i + 31] = function.load32(publicKeyInput, 4 * (j + 31 - 1)) >>> 1;
            j = (short)(j + 31);
        }
        function.memoryCopy(seedA, seedAOffset, publicKeyInput, 39680, 32);
    }

    private static void encodeSignature(byte[] signature, int signatureOffset, byte[] C, short cOffset, long[] Z, short n, short d) {
        int j = 0;
        int i = 0;
        while (i < n * d / 32) {
            function.store32(signature, signatureOffset + 4 * (i + 0), (int)(Z[j + 0] & 0x1FFFFFL | Z[j + 1] << 21));
            function.store32(signature, signatureOffset + 4 * (i + 1), (int)(Z[j + 1] >>> 11 & 0x3FFL | (Z[j + 2] & 0x1FFFFFL) << 10 | Z[j + 3] << 31));
            function.store32(signature, signatureOffset + 4 * (i + 2), (int)(Z[j + 3] >>> 1 & 0xFFFFFL | Z[j + 4] << 20));
            function.store32(signature, signatureOffset + 4 * (i + 3), (int)(Z[j + 4] >>> 12 & 0x1FFL | (Z[j + 5] & 0x1FFFFFL) << 9 | Z[j + 6] << 30));
            function.store32(signature, signatureOffset + 4 * (i + 4), (int)(Z[j + 6] >>> 2 & 0x7FFFFL | Z[j + 7] << 19));
            function.store32(signature, signatureOffset + 4 * (i + 5), (int)(Z[j + 7] >>> 13 & 0xFFL | (Z[j + 8] & 0x1FFFFFL) << 8 | Z[j + 9] << 29));
            function.store32(signature, signatureOffset + 4 * (i + 6), (int)(Z[j + 9] >>> 3 & 0x3FFFFL | Z[j + 10] << 18));
            function.store32(signature, signatureOffset + 4 * (i + 7), (int)(Z[j + 10] >>> 14 & 0x7FL | (Z[j + 11] & 0x1FFFFFL) << 7 | Z[j + 12] << 28));
            function.store32(signature, signatureOffset + 4 * (i + 8), (int)(Z[j + 12] >>> 4 & 0x1FFFFL | Z[j + 13] << 17));
            function.store32(signature, signatureOffset + 4 * (i + 9), (int)(Z[j + 13] >>> 15 & 0x3FL | (Z[j + 14] & 0x1FFFFFL) << 6 | Z[j + 15] << 27));
            function.store32(signature, signatureOffset + 4 * (i + 10), (int)(Z[j + 15] >>> 5 & 0xFFFFL | Z[j + 16] << 16));
            function.store32(signature, signatureOffset + 4 * (i + 11), (int)(Z[j + 16] >>> 16 & 0x1FL | (Z[j + 17] & 0x1FFFFFL) << 5 | Z[j + 18] << 26));
            function.store32(signature, signatureOffset + 4 * (i + 12), (int)(Z[j + 18] >>> 6 & 0x7FFFL | Z[j + 19] << 15));
            function.store32(signature, signatureOffset + 4 * (i + 13), (int)(Z[j + 19] >>> 17 & 0xFL | (Z[j + 20] & 0x1FFFFFL) << 4 | Z[j + 21] << 25));
            function.store32(signature, signatureOffset + 4 * (i + 14), (int)(Z[j + 21] >>> 7 & 0x3FFFL | Z[j + 22] << 14));
            function.store32(signature, signatureOffset + 4 * (i + 15), (int)(Z[j + 22] >>> 18 & 7L | (Z[j + 23] & 0x1FFFFFL) << 3 | Z[j + 24] << 24));
            function.store32(signature, signatureOffset + 4 * (i + 16), (int)(Z[j + 24] >>> 8 & 0x1FFFL | Z[j + 25] << 13));
            function.store32(signature, signatureOffset + 4 * (i + 17), (int)(Z[j + 25] >>> 19 & 3L | (Z[j + 26] & 0x1FFFFFL) << 2 | Z[j + 27] << 23));
            function.store32(signature, signatureOffset + 4 * (i + 18), (int)(Z[j + 27] >>> 9 & 0xFFFL | Z[j + 28] << 12));
            function.store32(signature, signatureOffset + 4 * (i + 19), (int)(Z[j + 28] >>> 20 & 1L | (Z[j + 29] & 0x1FFFFFL) << 1 | Z[j + 30] << 22));
            function.store32(signature, signatureOffset + 4 * (i + 20), (int)(Z[j + 30] >>> 10 & 0x7FFL | Z[j + 31] << 11));
            j = (short)(j + 32);
            i = (short)(i + d);
        }
        function.memoryCopy(signature, signatureOffset + n * d / 8, C, (int)cOffset, 32);
    }

    private static void encodeSignatureIIISpeedIP(byte[] signature, int signatureOffset, byte[] C, short cOffset, long[] Z, short n, short d) {
        int j = 0;
        int i = 0;
        while (i < n * d / 32) {
            function.store32(signature, signatureOffset + 4 * (i + 0), (int)(Z[j + 0] & 0x3FFFFFL | Z[j + 1] << 22));
            function.store32(signature, signatureOffset + 4 * (i + 1), (int)(Z[j + 1] >>> 10 & 0xFFFL | Z[j + 2] << 12));
            function.store32(signature, signatureOffset + 4 * (i + 2), (int)(Z[j + 2] >>> 20 & 3L | (Z[j + 3] & 0x3FFFFFL) << 2 | Z[j + 4] << 24));
            function.store32(signature, signatureOffset + 4 * (i + 3), (int)(Z[j + 4] >>> 8 & 0x3FFFL | Z[j + 5] << 14));
            function.store32(signature, signatureOffset + 4 * (i + 4), (int)(Z[j + 5] >>> 18 & 0xFL | (Z[j + 6] & 0x3FFFFFL) << 4 | Z[j + 7] << 26));
            function.store32(signature, signatureOffset + 4 * (i + 5), (int)(Z[j + 7] >>> 6 & 0xFFFFL | Z[j + 8] << 16));
            function.store32(signature, signatureOffset + 4 * (i + 6), (int)(Z[j + 8] >>> 16 & 0x3FL | (Z[j + 9] & 0x3FFFFFL) << 6 | Z[j + 10] << 28));
            function.store32(signature, signatureOffset + 4 * (i + 7), (int)(Z[j + 10] >>> 4 & 0x3FFFFL | Z[j + 11] << 18));
            function.store32(signature, signatureOffset + 4 * (i + 8), (int)(Z[j + 11] >>> 14 & 0xFFL | (Z[j + 12] & 0x3FFFFFL) << 8 | Z[j + 13] << 30));
            function.store32(signature, signatureOffset + 4 * (i + 9), (int)(Z[j + 13] >>> 2 & 0xFFFFFL | Z[j + 14] << 20));
            function.store32(signature, signatureOffset + 4 * (i + 10), (int)(Z[j + 14] >>> 12 & 0x3FFL | Z[j + 15] << 10));
            j = (short)(j + 16);
            i = (short)(i + d / 2);
        }
        function.memoryCopy(signature, signatureOffset + n * d / 8, C, (int)cOffset, 32);
    }

    private static void encodeSignature(byte[] signature, int signatureOffset, byte[] C, short cOffset, long[] Z) {
        int j = 0;
        for (int i = 0; i < 1536; i = (int)((short)(i + 3))) {
            function.store32(signature, signatureOffset + 4 * (i + 0), (int)(Z[j + 0] & 0xFFFFFFL | Z[j + 1] << 24));
            function.store32(signature, signatureOffset + 4 * (i + 1), (int)(Z[j + 1] >>> 8 & 0xFFFFL | Z[j + 2] << 16));
            function.store32(signature, signatureOffset + 4 * (i + 2), (int)(Z[j + 2] >>> 16 & 0xFFL | Z[j + 3] << 8));
            j = (short)(j + 4);
        }
        function.memoryCopy(signature, signatureOffset + 6144, C, (int)cOffset, 32);
    }

    private static void decodeSignature(byte[] C, long[] Z, byte[] signature, int signatureOffset, short n, short d) {
        int j = 0;
        for (short i = 0; i < n; i = (short)(i + 32)) {
            Z[i + 0] = function.load32(signature, signatureOffset + 4 * (j + 0)) << 11 >>> 11;
            Z[i + 1] = function.load32(signature, signatureOffset + 4 * (j + 0)) >>> 21 | function.load32(signature, signatureOffset + 4 * (j + 1)) << 22 >>> 11;
            Z[i + 2] = function.load32(signature, signatureOffset + 4 * (j + 1)) << 1 >>> 11;
            Z[i + 3] = function.load32(signature, signatureOffset + 4 * (j + 1)) >>> 31 | function.load32(signature, signatureOffset + 4 * (j + 2)) << 12 >>> 11;
            Z[i + 4] = function.load32(signature, signatureOffset + 4 * (j + 2)) >>> 20 | function.load32(signature, signatureOffset + 4 * (j + 3)) << 23 >>> 11;
            Z[i + 5] = function.load32(signature, signatureOffset + 4 * (j + 3)) << 2 >>> 11;
            Z[i + 6] = function.load32(signature, signatureOffset + 4 * (j + 3)) >>> 30 | function.load32(signature, signatureOffset + 4 * (j + 4)) << 13 >>> 11;
            Z[i + 7] = function.load32(signature, signatureOffset + 4 * (j + 4)) >>> 19 | function.load32(signature, signatureOffset + 4 * (j + 5)) << 24 >>> 11;
            Z[i + 8] = function.load32(signature, signatureOffset + 4 * (j + 5)) << 3 >>> 11;
            Z[i + 9] = function.load32(signature, signatureOffset + 4 * (j + 5)) >>> 29 | function.load32(signature, signatureOffset + 4 * (j + 6)) << 14 >>> 11;
            Z[i + 10] = function.load32(signature, signatureOffset + 4 * (j + 6)) >>> 18 | function.load32(signature, signatureOffset + 4 * (j + 7)) << 25 >>> 11;
            Z[i + 11] = function.load32(signature, signatureOffset + 4 * (j + 7)) << 4 >>> 11;
            Z[i + 12] = function.load32(signature, signatureOffset + 4 * (j + 7)) >>> 28 | function.load32(signature, signatureOffset + 4 * (j + 8)) << 15 >>> 11;
            Z[i + 13] = function.load32(signature, signatureOffset + 4 * (j + 8)) >>> 17 | function.load32(signature, signatureOffset + 4 * (j + 9)) << 26 >>> 11;
            Z[i + 14] = function.load32(signature, signatureOffset + 4 * (j + 9)) << 5 >>> 11;
            Z[i + 15] = function.load32(signature, signatureOffset + 4 * (j + 9)) >>> 27 | function.load32(signature, signatureOffset + 4 * (j + 10)) << 16 >>> 11;
            Z[i + 16] = function.load32(signature, signatureOffset + 4 * (j + 10)) >>> 16 | function.load32(signature, signatureOffset + 4 * (j + 11)) << 27 >>> 11;
            Z[i + 17] = function.load32(signature, signatureOffset + 4 * (j + 11)) << 6 >>> 11;
            Z[i + 18] = function.load32(signature, signatureOffset + 4 * (j + 11)) >>> 26 | function.load32(signature, signatureOffset + 4 * (j + 12)) << 17 >>> 11;
            Z[i + 19] = function.load32(signature, signatureOffset + 4 * (j + 12)) >>> 15 | function.load32(signature, signatureOffset + 4 * (j + 13)) << 28 >>> 11;
            Z[i + 20] = function.load32(signature, signatureOffset + 4 * (j + 13)) << 7 >>> 11;
            Z[i + 21] = function.load32(signature, signatureOffset + 4 * (j + 13)) >>> 25 | function.load32(signature, signatureOffset + 4 * (j + 14)) << 18 >>> 11;
            Z[i + 22] = function.load32(signature, signatureOffset + 4 * (j + 14)) >>> 14 | function.load32(signature, signatureOffset + 4 * (j + 15)) << 29 >>> 11;
            Z[i + 23] = function.load32(signature, signatureOffset + 4 * (j + 15)) << 8 >>> 11;
            Z[i + 24] = function.load32(signature, signatureOffset + 4 * (j + 15)) >>> 24 | function.load32(signature, signatureOffset + 4 * (j + 16)) << 19 >>> 11;
            Z[i + 25] = function.load32(signature, signatureOffset + 4 * (j + 16)) >>> 13 | function.load32(signature, signatureOffset + 4 * (j + 17)) << 30 >>> 11;
            Z[i + 26] = function.load32(signature, signatureOffset + 4 * (j + 17)) << 9 >>> 11;
            Z[i + 27] = function.load32(signature, signatureOffset + 4 * (j + 17)) >>> 23 | function.load32(signature, signatureOffset + 4 * (j + 18)) << 20 >>> 11;
            Z[i + 28] = function.load32(signature, signatureOffset + 4 * (j + 18)) >>> 12 | function.load32(signature, signatureOffset + 4 * (j + 19)) << 31 >>> 11;
            Z[i + 29] = function.load32(signature, signatureOffset + 4 * (j + 19)) << 10 >>> 11;
            Z[i + 30] = function.load32(signature, signatureOffset + 4 * (j + 19)) >>> 22 | function.load32(signature, signatureOffset + 4 * (j + 20)) << 21 >>> 11;
            Z[i + 31] = function.load32(signature, signatureOffset + 4 * (j + 20)) >>> 11;
            j = (short)(j + d);
        }
        function.memoryCopy(C, 0, signature, signatureOffset + n * d / 8, 32);
    }

    private static void decodeSignatureIIISpeedIP(byte[] C, long[] Z, byte[] signature, int signatureOffset, short n, short d) {
        int j = 0;
        for (short i = 0; i < n; i = (short)(i + 16)) {
            Z[i + 0] = function.load32(signature, signatureOffset + 4 * (j + 0)) << 10 >>> 10;
            Z[i + 1] = function.load32(signature, signatureOffset + 4 * (j + 0)) >>> 22 | function.load32(signature, signatureOffset + 4 * (j + 1)) << 20 >>> 10;
            Z[i + 2] = function.load32(signature, signatureOffset + 4 * (j + 1)) >>> 12 | function.load32(signature, signatureOffset + 4 * (j + 2)) << 30 >>> 10;
            Z[i + 3] = function.load32(signature, signatureOffset + 4 * (j + 2)) << 8 >>> 10;
            Z[i + 4] = function.load32(signature, signatureOffset + 4 * (j + 2)) >>> 24 | function.load32(signature, signatureOffset + 4 * (j + 3)) << 18 >>> 10;
            Z[i + 5] = function.load32(signature, signatureOffset + 4 * (j + 3)) >>> 14 | function.load32(signature, signatureOffset + 4 * (j + 4)) << 28 >>> 10;
            Z[i + 6] = function.load32(signature, signatureOffset + 4 * (j + 4)) << 6 >>> 10;
            Z[i + 7] = function.load32(signature, signatureOffset + 4 * (j + 4)) >>> 26 | function.load32(signature, signatureOffset + 4 * (j + 5)) << 16 >>> 10;
            Z[i + 8] = function.load32(signature, signatureOffset + 4 * (j + 5)) >>> 16 | function.load32(signature, signatureOffset + 4 * (j + 6)) << 26 >>> 10;
            Z[i + 9] = function.load32(signature, signatureOffset + 4 * (j + 6)) << 4 >>> 10;
            Z[i + 10] = function.load32(signature, signatureOffset + 4 * (j + 6)) >>> 28 | function.load32(signature, signatureOffset + 4 * (j + 7)) << 14 >>> 10;
            Z[i + 11] = function.load32(signature, signatureOffset + 4 * (j + 7)) >>> 18 | function.load32(signature, signatureOffset + 4 * (j + 8)) << 24 >>> 10;
            Z[i + 12] = function.load32(signature, signatureOffset + 4 * (j + 8)) << 2 >>> 10;
            Z[i + 13] = function.load32(signature, signatureOffset + 4 * (j + 8)) >>> 30 | function.load32(signature, signatureOffset + 4 * (j + 9)) << 12 >>> 10;
            Z[i + 14] = function.load32(signature, signatureOffset + 4 * (j + 9)) >>> 20 | function.load32(signature, signatureOffset + 4 * (j + 10)) << 22 >>> 10;
            Z[i + 15] = function.load32(signature, signatureOffset + 4 * (j + 10)) >>> 10;
            j = (short)(j + d / 2);
        }
        function.memoryCopy(C, 0, signature, signatureOffset + n * d / 8, 32);
    }

    private static void decodeSignature(byte[] C, long[] Z, byte[] signature, int signatureOffset) {
        int j = 0;
        for (int i = 0; i < 2048; i = (int)((short)(i + 4))) {
            Z[i + 0] = function.load32(signature, signatureOffset + 4 * (j + 0)) << 8 >>> 8;
            Z[i + 1] = function.load32(signature, signatureOffset + 4 * (j + 0)) >>> 24 & 0xFF | function.load32(signature, signatureOffset + 4 * (j + 1)) << 16 >>> 8;
            Z[i + 2] = function.load32(signature, signatureOffset + 4 * (j + 1)) >>> 16 & 0xFFFF | function.load32(signature, signatureOffset + 4 * (j + 2)) << 24 >>> 8;
            Z[i + 3] = function.load32(signature, signatureOffset + 4 * (j + 2)) >>> 8;
            j = (short)(j + 3);
        }
        function.memoryCopy(C, 0, signature, signatureOffset + 6144, 32);
    }

    private static void hashFunction(byte[] output, short outputOffset, long[] V, byte[] message, int messageOffset, int messageLength, short n, short d, int q) {
        byte[] T = new byte[n + messageLength];
        for (short i = 0; i < n; i = (short)(i + 1)) {
            long mask = (long)(q / 2) - V[i] >> 63;
            V[i] = V[i] - (long)q & mask | V[i] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long cL = V[i] & (long)((1 << d) - 1);
            mask = cL - (long)(1 << d) & mask | cL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            T[i] = (byte)(V[i] - cL >> d);
        }
        function.memoryCopy(T, (int)n, message, messageOffset, messageLength);
        if (q == 4205569) {
            fips.secureHashAlgorithmKECCAK128(output, outputOffset, (short)32, T, 0, messageLength + n);
        }
        if (q == 4206593 || q == 0x1FFFFF) {
            fips.secureHashAlgorithmKECCAK256(output, outputOffset, (short)32, T, 0, messageLength + n);
        }
    }

    private static void hashFunction(byte[] output, short outputOffset, long[] V, byte[] message, int messageOffset, int messageLength, short n, short k, short d, int q) {
        byte[] T = new byte[n * k + messageLength];
        for (short j = 0; j < k; j = (short)(j + 1)) {
            short index = (short)(j * n);
            for (short i = 0; i < n; i = (short)(i + 1)) {
                long temporary = V[index];
                long mask = (long)(q / 2) - temporary >> 63;
                temporary = temporary - (long)q & mask | temporary & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                long cL = temporary & (long)((1 << d) - 1);
                mask = (long)(1 << d - 1) - cL >> 63;
                cL = cL - (long)(1 << d) & mask | cL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                short s = index;
                index = (short)(index + 1);
                T[s] = (byte)(temporary - cL >> d);
            }
        }
        function.memoryCopy(T, n * k, message, messageOffset, messageLength);
        if (q == 485978113) {
            fips.secureHashAlgorithmKECCAK128(output, outputOffset, (short)32, T, 0, messageLength + n * k);
        }
        if (q == 1129725953) {
            fips.secureHashAlgorithmKECCAK256(output, outputOffset, (short)32, T, 0, messageLength + n * k);
        }
    }

    private static long absolute(long value) {
        return (value >> 63 ^ value) - (value >> 63);
    }

    private static boolean testRejection(long[] Z, short n, int b, short u) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            if (QTESLA.absolute(Z[i]) <= (long)(b - u)) continue;
            return true;
        }
        return false;
    }

    private static boolean testZ(long[] Z, short n, int b, short u) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            if (Z[i] >= (long)(-(b - u)) && Z[i] <= (long)(b - u)) continue;
            return true;
        }
        return false;
    }

    private static boolean testV(long[] V, short n, short d, int q, short rejection) {
        for (short i = 0; i < n; i = (short)(i + 1)) {
            long mask = (long)(q / 2) - V[i] >> 63;
            long right = V[i] - (long)q & mask | V[i] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            long test1 = (QTESLA.absolute(right) - (long)(q / 2 - rejection) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            long left = right;
            right = right + (long)((1 << d - 1) - 1) >> d & 0xFFFFFFFFL;
            long test2 = (QTESLA.absolute(right = left - (right << d)) - (long)((1 << d - 1) - rejection) ^ 0xFFFFFFFFFFFFFFFFL) >>> 63;
            if ((test1 | test2) != 1L) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPolynomial(long[] polynomial, short offset, short bound, short n, short w) {
        short i;
        short summation = 0;
        short limit = n;
        short[] list = new short[n];
        for (i = 0; i < n; i = (short)(i + 1)) {
            list[i] = (short)QTESLA.absolute(polynomial[offset + i]);
        }
        for (i = 0; i < w; i = (short)(i + 1)) {
            for (int j = 0; j < limit - 1; j = (int)((short)(j + 1))) {
                short mask = (short)(list[j + 1] - list[j] >> 15);
                short temporary = (short)(list[j + 1] & mask | list[j] & ~mask);
                list[j + 1] = (short)(list[j] & mask | list[j + 1] & ~mask);
                list[j] = temporary;
            }
            short s = limit;
            limit = (short)(limit - 1);
            summation = (short)(summation + list[s - 1]);
        }
        return summation > bound;
    }

    private static void sparsePolynomialMultiplication16(long[] product, byte[] secretKey, short secretKeyOffset, short[] positionList, short[] signList, short n, short w) {
        Arrays.fill(product, 0L);
        for (short i = 0; i < w; i = (short)(i + 1)) {
            short j;
            short position = positionList[i];
            for (j = 0; j < position; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] - (long)(signList[i] * function.load16(secretKey, secretKeyOffset + 2 * (n + j - position)));
            }
            for (j = position; j < n; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] + (long)(signList[i] * function.load16(secretKey, secretKeyOffset + 2 * (j - position)));
            }
        }
    }

    private static void sparsePolynomialMultiplication8(long[] product, byte[] secretKey, short secretKeyOffset, short[] positionList, short[] signList, short n, short w) {
        Arrays.fill(product, 0L);
        for (short i = 0; i < w; i = (short)(i + 1)) {
            short j;
            short position = positionList[i];
            for (j = 0; j < position; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] - (long)(signList[i] * (char)secretKey[secretKeyOffset + n + j - position]);
            }
            for (j = position; j < n; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] + (long)(signList[i] * (char)secretKey[secretKeyOffset + j - position]);
            }
        }
    }

    private static void sparsePolynomialMultiplication32(long[] product, int[] publicKey, short publicKeyOffset, short[] positionList, short[] signList, short n, short w, int q, short barrettMultiplication, short barrettDivision) {
        short i;
        Arrays.fill(product, 0L);
        for (i = 0; i < w; i = (short)(i + 1)) {
            short j;
            short position = positionList[i];
            for (j = 0; j < position; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] - (long)(signList[i] * publicKey[publicKeyOffset + n + j - position]);
            }
            for (j = position; j < n; j = (short)(j + 1)) {
                short s = j;
                product[s] = product[s] + (long)(signList[i] * publicKey[publicKeyOffset + j - position]);
            }
        }
        if (q == 4205569 || q == 4206593 || q == 8404993) {
            for (i = 0; i < n; i = (short)(i + 1)) {
                product[i] = polynomial.barrett(product[i], q, barrettMultiplication, barrettDivision);
            }
        }
        if (q == 485978113 || q == 1129725953) {
            for (i = 0; i < n; i = (short)(i + 1)) {
                product[i] = polynomial.barrettP(product[i], q, barrettMultiplication, barrettDivision);
            }
        }
    }

    short generateKeyPair(byte[] publicKey, byte[] secretKey, short n, short w, int q, long qInverse, short qLogarithm, short generatorA, int inverseNumberTheoreticTransform, double xi, long[] zeta, short errorBound, short secretBound) {
        int nonce = 0;
        byte[] randomness = new byte[32];
        byte[] randomnessExtended = new byte[128];
        long[] secretPolynomial = new long[n];
        long[] errorPolynomial = new long[n];
        long[] A = new long[n];
        long[] T = new long[n];
        this.random.nextBytes(randomness);
        if (q == 4205569) {
            fips.secureHashAlgorithmKECCAK128(randomnessExtended, (short)0, (short)128, randomness, 0, 32);
        }
        if (q == 4206593 || q == 8404993) {
            fips.secureHashAlgorithmKECCAK256(randomnessExtended, (short)0, (short)128, randomness, 0, 32);
        }
        do {
            if (q == 4205569) {
                this.sample.polynomialGaussSamplerI(errorPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_I);
            }
            if (q == 4206593) {
                this.sample.polynomialGaussSamplerIII(errorPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (q != 8404993) continue;
            this.sample.polynomialGaussSamplerIII(errorPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(errorPolynomial, (short)0, errorBound, n, w));
        do {
            if (q == 4205569) {
                this.sample.polynomialGaussSamplerI(secretPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_I);
            }
            if (q == 4206593) {
                this.sample.polynomialGaussSamplerIII(secretPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SIZE);
            }
            if (q != 8404993) continue;
            this.sample.polynomialGaussSamplerIII(secretPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_III_SPEED);
        } while (QTESLA.checkPolynomial(secretPolynomial, (short)0, secretBound, n, w));
        polynomial.polynomialUniform(A, randomnessExtended, 64, n, (short)1, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        polynomial.polynomialMultiplication(T, A, secretPolynomial, n, q, qInverse, zeta);
        polynomial.polynomialAddition(T, T, errorPolynomial, n);
        QTESLA.packSecretKey(secretKey, secretPolynomial, errorPolynomial, randomnessExtended, 64, n);
        if (q == 4205569) {
            QTESLA.encodePublicKey(publicKey, T, randomnessExtended, 64, n, (short)23);
        }
        if (q == 4206593) {
            QTESLA.encodePublicKey(publicKey, T, randomnessExtended, 64, n, (short)23);
        }
        if (q == 8404993) {
            QTESLA.encodePublicKeyIIISpeed(publicKey, T, randomnessExtended, 64);
        }
        return 0;
    }

    public short generateKeyPairI(byte[] publicKey, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.generateKeyPair(publicKey, secretKey, (short)512, (short)30, 4205569, 3098553343L, (short)23, (short)19, 113307, 27.9988, PolynomialHeuristic.ZETA_I, (short)1586, (short)1586);
    }

    public short generateKeyPairIIISize(byte[] publicKey, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.generateKeyPair(publicKey, secretKey, (short)1024, (short)48, 4206593, 4148178943L, (short)23, (short)38, 1217638, 9.9962, PolynomialHeuristic.ZETA_III_SIZE, (short)910, (short)910);
    }

    public short generateKeyPairIIISpeed(byte[] publicKey, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.generateKeyPair(publicKey, secretKey, (short)1024, (short)48, 8404993, 4034936831L, (short)24, (short)38, 237839, 12.0, PolynomialHeuristic.ZETA_III_SPEED, (short)1147, (short)1233);
    }

    short generateKeyPair(byte[] publicKey, byte[] secretKey, short n, short k, short w, int q, long qInverse, short qLogarithm, short generatorA, int inverseNumberTheoreticTransform, double xi, long[] zeta, short errorBound, short secretBound) {
        short i;
        int nonce = 0;
        byte[] randomness = new byte[32];
        byte[] randomnessExtended = new byte[32 * (k + 3)];
        long[] secretPolynomial = new long[n];
        long[] secretPolynomialNumberTheoreticTransform = new long[n];
        long[] errorPolynomial = new long[n * k];
        long[] A = new long[n * k];
        long[] T = new long[n * k];
        long[] temporaryErrorPolynomial = new long[n];
        long[] temporaryA = new long[n];
        long[] temporaryT = new long[n];
        this.random.nextBytes(randomness);
        if (q == 485978113) {
            fips.secureHashAlgorithmKECCAK128(randomnessExtended, (short)0, (short)(32 * (k + 3)), randomness, 0, 32);
        }
        if (q == 1129725953) {
            fips.secureHashAlgorithmKECCAK256(randomnessExtended, (short)0, (short)(32 * (k + 3)), randomness, 0, 32);
        }
        for (i = 0; i < k; i = (short)(i + 1)) {
            do {
                if (q == 485978113) {
                    this.sample.polynomialGaussSamplerI(errorPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_P);
                }
                if (q != 1129725953) continue;
                this.sample.polynomialGaussSamplerIII(errorPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_P);
            } while (QTESLA.checkPolynomial(errorPolynomial, (short)(n * i), errorBound, n, w));
        }
        do {
            if (q == 485978113) {
                this.sample.polynomialGaussSamplerI(secretPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_P);
            }
            if (q != 1129725953) continue;
            this.sample.polynomialGaussSamplerIII(secretPolynomial, randomnessExtended, (short)0, ++nonce, n, xi, Sample.EXPONENTIAL_DISTRIBUTION_P);
        } while (QTESLA.checkPolynomial(secretPolynomial, (short)0, secretBound, n, w));
        polynomial.polynomialUniform(A, randomnessExtended, (short)(32 * (k + 1)), n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        polynomial.polynomialNumberTheoreticTransform(secretPolynomialNumberTheoreticTransform, secretPolynomial, n, zeta);
        for (i = 0; i < k; i = (short)(i + 1)) {
            function.memoryCopy(temporaryA, 0, A, n * i, (int)n);
            function.memoryCopy(temporaryErrorPolynomial, 0, errorPolynomial, n * i, (int)n);
            polynomial.polynomialMultiplication(temporaryT, temporaryA, secretPolynomial, n, q, qInverse);
            polynomial.polynomialAddition(temporaryT, temporaryT, temporaryErrorPolynomial, n);
            for (short j = 0; j < n; j = (short)(j + 1)) {
                long mask = (long)q - temporaryT[i] >> 63;
                short s = i;
                temporaryT[s] = temporaryT[s] - ((long)q & mask);
            }
            function.memoryCopy(T, n * i, temporaryT, 0, (int)n);
        }
        QTESLA.packSecretKey(secretKey, secretPolynomial, errorPolynomial, randomnessExtended, 32 * (k + 1), n, k);
        if (q == 485978113) {
            QTESLA.encodePublicKeyIP(publicKey, T, randomnessExtended, 32 * (k + 1));
        }
        if (q == 1129725953) {
            QTESLA.encodePublicKeyIIIP(publicKey, T, randomnessExtended, 32 * (k + 1));
        }
        return 0;
    }

    public short generateKeyPairIP(byte[] publicKey, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.generateKeyPair(publicKey, secretKey, (short)1024, (short)4, (short)25, 485978113, 3421990911L, (short)29, (short)108, 472064468, 10.0, PolynomialProvablySecure.ZETA_I_P, (short)554, (short)554);
    }

    public short generateKeyPairIIIP(byte[] publicKey, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.generateKeyPair(publicKey, secretKey, (short)2048, (short)5, (short)40, 1129725953, 861290495L, (short)31, (short)180, 851423148, 12.0, PolynomialProvablySecure.ZETA_III_P, (short)901, (short)901);
    }

    private short signing(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey, short n, short w, int q, long qInverse, short qLogarithm, int b, short bBit, short d, short u, short rejection, short generatorA, int inverseNumberTheoreticTransform, int secretKeyByte, short barrettMultiplication, short barrettDivision, long[] zeta, long[] zetaInverse) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        byte[] C = new byte[32];
        byte[] randomness = new byte[32];
        byte[] randomnessInput = new byte[messageLength + 32 + 32];
        byte[] temporaryRandomnessInput = new byte[32];
        short[] positionList = new short[w];
        short[] signList = new short[w];
        long[] A = new long[n];
        long[] V = new long[n];
        long[] Y = new long[n];
        long[] Z = new long[n];
        long[] SC = new long[n];
        long[] EC2 = new long[n];
        int nonce = 0;
        this.random.nextBytes(temporaryRandomnessInput);
        function.memoryCopy(randomnessInput, 32, temporaryRandomnessInput, 0, 32);
        function.memoryCopy(randomnessInput, 0, secretKey, secretKeyByte - 32, 32);
        function.memoryCopy(randomnessInput, 64, message, messageOffset, messageLength);
        if (q == 4205569) {
            fips.secureHashAlgorithmKECCAK128(randomness, (short)0, (short)32, randomnessInput, 0, messageLength + 32 + 32);
        }
        if (q == 4206593) {
            fips.secureHashAlgorithmKECCAK256(randomness, (short)0, (short)32, randomnessInput, 0, messageLength + 32 + 32);
        }
        if (q == 8404993) {
            fips.secureHashAlgorithmKECCAK256(randomness, (short)0, (short)32, randomnessInput, 0, messageLength + 32 + 32);
        }
        polynomial.polynomialUniform(A, secretKey, secretKeyByte - 64, n, (short)1, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        while (true) {
            this.sample.sampleY(Y, randomness, (short)0, ++nonce, n, b, bBit);
            polynomial.polynomialMultiplication(V, A, Y, n, q, qInverse, zeta);
            QTESLA.hashFunction(C, (short)0, V, message, messageOffset, messageLength, n, d, q);
            this.sample.encodeC(positionList, signList, C, (short)0, n, w);
            QTESLA.sparsePolynomialMultiplication16(SC, secretKey, (short)0, positionList, signList, n, w);
            polynomial.polynomialAddition(Z, Y, SC, n);
            if (QTESLA.testRejection(Z, n, b, u)) continue;
            QTESLA.sparsePolynomialMultiplication16(EC2, secretKey, (short)(n * 16 / 8), positionList, signList, n, w);
            polynomial.polynomialSubtraction(V, V, EC2, n, q, barrettMultiplication, barrettDivision);
            if (!QTESLA.testV(V, n, d, q, rejection)) break;
        }
        if (q == 4205569) {
            function.memoryCopy(signature, signatureOffset + 1376, message, messageOffset, messageLength);
            signatureLength = 1376 + messageLength;
            QTESLA.encodeSignature(signature, 0, C, (short)0, Z, n, d);
        }
        if (q == 4206593) {
            function.memoryCopy(signature, signatureOffset + 2720, message, messageOffset, messageLength);
            signatureLength = 2720 + messageLength;
            QTESLA.encodeSignature(signature, 0, C, (short)0, Z, n, d);
        }
        if (q == 8404993) {
            function.memoryCopy(signature, signatureOffset + 2848, message, messageOffset, messageLength);
            signatureLength = 2848 + messageLength;
            QTESLA.encodeSignatureIIISpeedIP(signature, 0, C, (short)0, Z, n, d);
        }
        return 0;
    }

    public short signingI(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.signing(signature, signatureOffset, signatureLength, message, messageOffset, messageLength, secretKey, (short)512, (short)30, 4205569, 3098553343L, (short)23, 1048575, (short)20, (short)21, (short)1586, (short)1586, (short)19, 113307, 2112, (short)1021, (short)32, PolynomialHeuristic.ZETA_I, PolynomialHeuristic.ZETA_INVERSE_I);
    }

    public short signingIIISize(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.signing(signature, signatureOffset, signatureLength, message, messageOffset, messageLength, secretKey, (short)1024, (short)48, 4206593, 4148178943L, (short)23, 1048575, (short)20, (short)21, (short)910, (short)910, (short)38, 1217638, 4160, (short)1021, (short)32, PolynomialHeuristic.ZETA_III_SIZE, PolynomialHeuristic.ZETA_INVERSE_III_SIZE);
    }

    public short signingIIISpeed(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.signing(signature, signatureOffset, signatureLength, message, messageOffset, messageLength, secretKey, (short)1024, (short)48, 8404993, 4034936831L, (short)24, 0x1FFFFF, (short)21, (short)22, (short)1233, (short)1147, (short)38, 237839, 4160, (short)511, (short)32, PolynomialHeuristic.ZETA_III_SPEED, PolynomialHeuristic.ZETA_INVERSE_III_SPEED);
    }

    private short signing(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey, short n, short k, short w, int q, long qInverse, short qLogarithm, int b, short bBit, short d, short u, short rejection, short generatorA, int inverseNumberTheoreticTransform, int secretKeyByte, short barrettMultiplication, short barrettDivision, long[] zeta) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        byte[] C = new byte[32];
        byte[] randomness = new byte[32];
        byte[] randomnessInput = new byte[messageLength + 32 + 32];
        byte[] temporaryRandomnessInput = new byte[32];
        short[] positionList = new short[w];
        short[] signList = new short[w];
        long[] A = new long[n * k];
        long[] V = new long[n * k];
        long[] Y = new long[n];
        long[] numberTheoreticTransformY = new long[n];
        long[] Z = new long[n];
        long[] SC = new long[n];
        long[] EC2 = new long[n * k];
        long[] temporaryA = new long[n];
        long[] temporaryV = new long[n];
        long[] temporaryEC = new long[n];
        boolean response = false;
        int nonce = 0;
        this.random.nextBytes(temporaryRandomnessInput);
        function.memoryCopy(randomnessInput, 32, temporaryRandomnessInput, 0, 32);
        function.memoryCopy(randomnessInput, 0, secretKey, secretKeyByte - 32, 32);
        function.memoryCopy(randomnessInput, 64, message, messageOffset, messageLength);
        if (q == 485978113) {
            fips.secureHashAlgorithmKECCAK128(randomness, (short)0, (short)32, randomnessInput, 0, messageLength + 32 + 32);
        }
        if (q == 1129725953) {
            fips.secureHashAlgorithmKECCAK256(randomness, (short)0, (short)32, randomnessInput, 0, messageLength + 32 + 32);
        }
        polynomial.polynomialUniform(A, secretKey, secretKeyByte - 64, n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        while (true) {
            short i;
            this.sample.sampleY(Y, randomness, (short)0, nonce++, n, b, bBit);
            polynomial.polynomialNumberTheoreticTransform(numberTheoreticTransformY, Y, n, zeta);
            for (i = 0; i < k; i = (short)(i + 1)) {
                function.memoryCopy(temporaryA, 0, A, n * i, (int)n);
                polynomial.polynomialMultiplication(temporaryV, temporaryA, numberTheoreticTransformY, n, q, qInverse);
                function.memoryCopy(V, n * i, temporaryV, 0, (int)n);
            }
            QTESLA.hashFunction(C, (short)0, V, message, messageOffset, messageLength, n, k, d, q);
            this.sample.encodeC(positionList, signList, C, (short)0, n, w);
            QTESLA.sparsePolynomialMultiplication8(SC, secretKey, (short)0, positionList, signList, n, w);
            polynomial.polynomialAddition(Z, Y, SC, n);
            if (QTESLA.testRejection(Z, n, b, u)) continue;
            for (i = 0; i < k; i = (short)(i + 1)) {
                QTESLA.sparsePolynomialMultiplication8(temporaryEC, secretKey, (short)(n * (i + 1)), positionList, signList, n, w);
                function.memoryCopy(temporaryV, 0, V, n * i, (int)n);
                polynomial.polynomialSubtractionP(temporaryV, temporaryV, temporaryEC, n, q, barrettMultiplication, barrettDivision);
                function.memoryCopy(EC2, n * i, temporaryEC, 0, (int)n);
                function.memoryCopy(V, n * i, temporaryV, 0, (int)n);
                response = QTESLA.testV(temporaryV, n, d, q, rejection);
                if (response) break;
            }
            if (!response) break;
        }
        if (q == 485978113) {
            function.memoryCopy(signature, signatureOffset + 2848, message, messageOffset, messageLength);
            signatureLength = messageLength + 2848;
            QTESLA.encodeSignatureIIISpeedIP(signature, messageLength, C, (short)0, Z, n, d);
        }
        if (q == 1129725953) {
            function.memoryCopy(signature, signatureOffset + 6176, message, messageOffset, messageLength);
            signatureLength = messageLength + 6176;
            QTESLA.encodeSignature(signature, messageLength, C, (short)0, Z);
        }
        return 0;
    }

    public short signingIP(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.signing(signature, signatureOffset, signatureLength, message, messageOffset, messageLength, secretKey, (short)1024, (short)4, (short)25, 485978113, 3421990911L, (short)29, 0x1FFFFF, (short)21, (short)22, (short)554, (short)554, (short)108, 472064468, 5184, (short)1, (short)29, PolynomialProvablySecure.ZETA_I_P);
    }

    public short signingIIIP(byte[] signature, int signatureOffset, int signatureLength, byte[] message, int messageOffset, int messageLength, byte[] secretKey) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, ShortBufferException {
        return this.signing(signature, signatureOffset, signatureLength, message, messageOffset, messageLength, secretKey, (short)2048, (short)5, (short)40, 1129725953, 861290495L, (short)31, 0x7FFFFF, (short)23, (short)24, (short)901, (short)901, (short)180, 851423148, 12352, (short)15, (short)34, PolynomialProvablySecure.ZETA_III_P);
    }

    private short verify(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey, short n, short w, int q, long qInverse, short qLogarithm, int b, short d, short u, short lowerBound, short generatorA, int inverseNumberTheoreticTransform, short barrettMultiplication, short barrettDivision, long[] zeta) {
        byte[] C = new byte[32];
        byte[] cSignature = new byte[32];
        byte[] seed = new byte[32];
        int[] newPublicKey = new int[n];
        short[] positionList = new short[w];
        short[] signList = new short[w];
        long[] W = new long[n];
        long[] Z = new long[n];
        long[] TC = new long[n];
        long[] A = new long[n];
        if (signatureLength < lowerBound) {
            return -1;
        }
        if (q == 4205569 || q == 4206593) {
            QTESLA.decodeSignature(C, Z, signature, signatureOffset, n, d);
        }
        if (q == 8404993) {
            QTESLA.decodeSignatureIIISpeedIP(C, Z, signature, signatureOffset, n, d);
        }
        if (QTESLA.testZ(Z, n, b, u)) {
            return -2;
        }
        if (q == 4205569 || q == 4206593) {
            QTESLA.decodePublicKey(newPublicKey, seed, 0, publicKey, n, d);
        }
        if (q == 8404993) {
            QTESLA.decodePublicKeyIIISpeed(newPublicKey, seed, 0, publicKey);
        }
        polynomial.polynomialUniform(A, seed, 0, n, (short)1, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        this.sample.encodeC(positionList, signList, C, (short)0, n, w);
        polynomial.polynomialMultiplication(W, A, Z, n, q, qInverse, zeta);
        QTESLA.sparsePolynomialMultiplication32(TC, newPublicKey, (short)0, positionList, signList, n, w, q, barrettMultiplication, barrettDivision);
        polynomial.polynomialSubtraction(W, W, TC, n, q, barrettMultiplication, barrettDivision);
        QTESLA.hashFunction(cSignature, (short)0, W, signature, signatureOffset + lowerBound, signatureLength - lowerBound, n, d, q);
        if (!function.memoryEqual(C, 0, cSignature, 0, 32)) {
            return -3;
        }
        messageLength = signatureLength - lowerBound;
        function.memoryCopy(message, messageOffset, signature, signatureOffset + lowerBound, messageLength);
        return 0;
    }

    public short verifyI(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return this.verify(message, messageOffset, messageLength, signature, signatureOffset, signatureLength, publicKey, (short)512, (short)30, 4205569, 3098553343L, (short)23, 1048575, (short)21, (short)1586, (short)1376, (short)19, 113307, (short)1021, (short)32, PolynomialHeuristic.ZETA_I);
    }

    public short verifyIIISize(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return this.verify(message, messageOffset, messageLength, signature, signatureOffset, signatureLength, publicKey, (short)1024, (short)48, 4206593, 4148178943L, (short)23, 1048575, (short)21, (short)910, (short)2720, (short)38, 1217638, (short)1021, (short)32, PolynomialHeuristic.ZETA_III_SIZE);
    }

    public short verifyIIISpeed(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return this.verify(message, messageOffset, messageLength, signature, signatureOffset, signatureLength, publicKey, (short)1024, (short)48, 8404993, 4034936831L, (short)24, 0x1FFFFF, (short)22, (short)1233, (short)2848, (short)38, 237839, (short)511, (short)32, PolynomialHeuristic.ZETA_III_SPEED);
    }

    private short verify(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey, short n, short k, short w, int q, long qInverse, short qLogarithm, int b, short d, short u, short lowerBound, short generatorA, int inverseNumberTheoreticTransform, short barrettMultiplication, short barrettDivision, long[] zeta) {
        byte[] C = new byte[32];
        byte[] cSignature = new byte[32];
        byte[] seed = new byte[32];
        int[] newPublicKey = new int[n * k];
        short[] positionList = new short[w];
        short[] signList = new short[w];
        long[] W = new long[n * k];
        long[] Z = new long[n];
        long[] numberTheoreticTransformZ = new long[n];
        long[] TC = new long[n * k];
        long[] A = new long[n * k];
        long[] temporaryW = new long[n];
        long[] temporaryTC = new long[n];
        long[] temporaryA = new long[n];
        if (signatureLength < lowerBound) {
            return -1;
        }
        if (q == 485978113) {
            QTESLA.decodeSignatureIIISpeedIP(C, Z, signature, signatureOffset, n, d);
        }
        if (q == 1129725953) {
            QTESLA.decodeSignature(C, Z, signature, signatureOffset);
        }
        if (QTESLA.testZ(Z, n, b, u)) {
            return -2;
        }
        if (q == 485978113) {
            QTESLA.decodePublicKeyIP(newPublicKey, seed, 0, publicKey);
        }
        if (q == 1129725953) {
            QTESLA.decodePublicKeyIIIP(newPublicKey, seed, 0, publicKey);
        }
        polynomial.polynomialUniform(A, seed, 0, n, k, q, qInverse, qLogarithm, generatorA, inverseNumberTheoreticTransform);
        this.sample.encodeC(positionList, signList, C, (short)0, n, w);
        polynomial.polynomialNumberTheoreticTransform(numberTheoreticTransformZ, Z, n, zeta);
        for (short i = 0; i < k; i = (short)(i + 1)) {
            function.memoryCopy(temporaryTC, 0, TC, n * i, (int)n);
            function.memoryCopy(temporaryA, 0, A, n * i, (int)n);
            polynomial.polynomialMultiplication(temporaryW, temporaryA, numberTheoreticTransformZ, n, q, qInverse);
            QTESLA.sparsePolynomialMultiplication32(temporaryTC, newPublicKey, (short)(n * i), positionList, signList, n, w, q, barrettMultiplication, barrettDivision);
            polynomial.polynomialSubtractionP(temporaryW, temporaryW, TC, n, q, barrettMultiplication, barrettDivision);
            function.memoryCopy(W, n * i, temporaryW, 0, (int)n);
        }
        QTESLA.hashFunction(cSignature, (short)0, W, signature, signatureOffset + lowerBound, signatureLength - lowerBound, n, k, d, q);
        if (!function.memoryEqual(C, 0, cSignature, 0, 32)) {
            return -3;
        }
        messageLength = signatureLength - lowerBound;
        function.memoryCopy(message, messageOffset, signature, signatureOffset + lowerBound, messageLength);
        return 0;
    }

    public short verifyIP(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return this.verify(message, messageOffset, messageLength, signature, signatureOffset, signatureLength, publicKey, (short)1024, (short)4, (short)25, 485978113, 3421990911L, (short)29, 0x1FFFFF, (short)22, (short)554, (short)2848, (short)108, 472064468, (short)1, (short)29, PolynomialProvablySecure.ZETA_I_P);
    }

    public short verifyIIIP(byte[] message, int messageOffset, int messageLength, byte[] signature, int signatureOffset, int signatureLength, byte[] publicKey) {
        return this.verify(message, messageOffset, messageLength, signature, signatureOffset, signatureLength, publicKey, (short)2048, (short)5, (short)40, 1129725953, 861290495L, (short)31, 0x7FFFFF, (short)24, (short)901, (short)6176, (short)180, 851423148, (short)15, (short)34, PolynomialProvablySecure.ZETA_III_P);
    }
}

