/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.updater;

import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.updater.DefaultTarGzEntryNameConverter;
import co.codewizards.cloudstore.updater.TarGzEntryNameConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarGzFile {
    private static final Logger logger = LoggerFactory.getLogger(TarGzFile.class);
    private final File tarGzFile;
    private TarGzEntryNameConverter tarGzEntryNameConverter;
    private FileFilter fileFilter;
    private static final TarGzEntryNameConverter defaultEntryNameConverter = new DefaultTarGzEntryNameConverter();

    public TarGzFile(File tarGzFile) {
        this.tarGzFile = AssertUtil.assertNotNull(tarGzFile, "tarGzFile");
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public TarGzFile fileFilter(FileFilter fileFilter) {
        this.setFileFilter(fileFilter);
        return this;
    }

    public TarGzEntryNameConverter getTarGzEntryNameConverter() {
        return this.tarGzEntryNameConverter;
    }

    public void setTarGzEntryNameConverter(TarGzEntryNameConverter tarGzEntryNameConverter) {
        this.tarGzEntryNameConverter = tarGzEntryNameConverter;
    }

    public TarGzFile tarGzEntryNameConverter(TarGzEntryNameConverter tarGzEntryNameConverter) {
        this.setTarGzEntryNameConverter(tarGzEntryNameConverter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(File rootDir) throws IOException {
        boolean deleteIncompleteTarGzFile = false;
        OutputStream fout = StreamUtil.castStream(this.tarGzFile.createOutputStream());
        try {
            deleteIncompleteTarGzFile = true;
            GzipParameters gzipParameters = new GzipParameters();
            gzipParameters.setCompressionLevel(9);
            try (TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(fout), gzipParameters));){
                this.writeTar(out, rootDir, rootDir);
            }
            deleteIncompleteTarGzFile = false;
        }
        finally {
            fout.close();
            if (deleteIncompleteTarGzFile) {
                this.tarGzFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTar(TarArchiveOutputStream out, File rootDir, File dir) throws IOException {
        block10: {
            TarGzEntryNameConverter tarGzEntryNameConverter = this.tarGzEntryNameConverter == null ? defaultEntryNameConverter : this.tarGzEntryNameConverter;
            try {
                File[] children = dir.listFiles(this.fileFilter);
                if (children == null) break block10;
                for (File child : children) {
                    block11: {
                        String entryName = tarGzEntryNameConverter.getEntryName(rootDir, child);
                        TarArchiveEntry archiveEntry = (TarArchiveEntry)out.createArchiveEntry(child.getIoFile(), entryName);
                        if (child.canExecute()) {
                            archiveEntry.setMode(archiveEntry.getMode() | 0x49);
                        }
                        out.putArchiveEntry((ArchiveEntry)archiveEntry);
                        try {
                            if (!child.isFile()) break block11;
                            try (InputStream in = StreamUtil.castStream(child.createInputStream());){
                                this.transferStreamData(in, (OutputStream)out);
                            }
                        }
                        finally {
                            out.closeArchiveEntry();
                        }
                    }
                    if (!child.isDirectory()) continue;
                    this.writeTar(out, rootDir, child);
                }
            }
            catch (IOException | RuntimeException x) {
                logger.error(x.toString(), (Throwable)x);
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File rootDir) throws IOException {
        rootDir.mkdirs();
        TarGzEntryNameConverter tarGzEntryNameConverter = this.tarGzEntryNameConverter == null ? defaultEntryNameConverter : this.tarGzEntryNameConverter;
        FileFilter fileFilter = this.fileFilter;
        try (InputStream fin = StreamUtil.castStream(this.tarGzFile.createInputStream());
             TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(fin)));){
            TarArchiveEntry entry;
            while (null != (entry = in.getNextTarEntry())) {
                if (entry.isDirectory()) {
                    File dir = tarGzEntryNameConverter.getFile(rootDir, entry.getName());
                    if (fileFilter != null && !fileFilter.accept(dir.getIoFile()) || dir.exists() || dir.mkdirs()) continue;
                    throw new IllegalStateException("Could not create directory entry, possibly permission issues: " + dir.getAbsolutePath());
                }
                File file = tarGzEntryNameConverter.getFile(rootDir, entry.getName());
                if (fileFilter != null && !fileFilter.accept(file.getIoFile())) continue;
                File dir = file.getParentFile();
                if (!dir.isDirectory()) {
                    dir.mkdirs();
                }
                if (file.isFile()) {
                    file.delete();
                }
                try (OutputStream out = StreamUtil.castStream(file.createOutputStream());){
                    this.transferStreamData((InputStream)in, out);
                }
                if ((entry.getMode() & 0x40) == 0 && (entry.getMode() & 8) == 0 && (entry.getMode() & 1) == 0) continue;
                file.setExecutable(true, false);
            }
        }
    }

    private void transferStreamData(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            if (len <= 0) continue;
            out.write(buf, 0, len);
        }
    }
}

