/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto;

import co.codewizards.cloudstore.core.dto.ErrorStackTraceElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Error
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className;
    private String message;
    private List<ErrorStackTraceElement> stackTraceElements;
    private Error cause;

    public Error() {
    }

    public Error(String message) {
        this.message = message;
    }

    public Error(Throwable throwable) {
        if (throwable != null) {
            this.message = throwable.getMessage();
            this.className = throwable.getClass().getName();
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                this.getStackTraceElements().add(new ErrorStackTraceElement(stackTraceElement));
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                Error errorCause = new Error(cause);
                this.setCause(errorCause);
            }
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<ErrorStackTraceElement> getStackTraceElements() {
        if (this.stackTraceElements == null) {
            this.stackTraceElements = new ArrayList<ErrorStackTraceElement>();
        }
        return this.stackTraceElements;
    }

    public void setStackTraceElements(List<ErrorStackTraceElement> stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    public Error getCause() {
        return this.cause;
    }

    public void setCause(Error cause) {
        this.cause = cause;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "className=" + this.className + ", message=" + this.message + ", stackTraceElements=" + this.stackTraceElements + ", cause=" + this.cause;
    }
}

