/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.collection;

import co.codewizards.cloudstore.core.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ListMerger<E, K> {
    private List<E> source;
    private List<E> dest;
    private Map<K, List<E>> sourceKey2elements;
    private Map<K, List<E>> destKey2elements;

    public void merge(List<E> source, List<E> dest) {
        List<E> destElements;
        this.source = Objects.requireNonNull(source, "source");
        this.dest = Objects.requireNonNull(dest, "dest");
        this.populateSourceKey2element();
        this.populateDestKey2element();
        LinkedList<E> destElementsToRemove = new LinkedList<E>();
        for (Object object : dest) {
            K sourceKey = this.getKey(object);
            List<E> sourceElements = this.nullToEmptyList(this.sourceKey2elements.get(sourceKey));
            destElements = this.nullToEmptyList(this.destKey2elements.get(sourceKey));
            int elementsToRemoveQty = destElements.size() - sourceElements.size();
            if (elementsToRemoveQty <= 0) continue;
            for (int i = 0; i < elementsToRemoveQty; ++i) {
                E removed = destElements.remove(0);
                destElementsToRemove.add(removed);
            }
        }
        for (Object object : destElementsToRemove) {
            dest.remove(object);
        }
        int index = -1;
        for (E sourceElement : source) {
            Object destKey;
            K sourceKey = this.getKey(sourceElement);
            destElements = this.nullToEmptyList(this.destKey2elements.get(sourceKey));
            Object destElement = dest.size() <= ++index ? null : dest.get(index);
            Object v0 = destKey = destElement == null ? null : this.getKey(destElement);
            if (Util.equal(sourceKey, destKey)) {
                this.update(dest, index, sourceElement, destElement);
                destElements.remove(destElement);
                continue;
            }
            destElement = null;
            destKey = null;
            if (!destElements.isEmpty()) {
                destElement = destElements.remove(0);
                int lastIndexOf = dest.lastIndexOf(destElement);
                dest.remove(lastIndexOf);
                dest.add(index, destElement);
                this.update(dest, index, sourceElement, destElement);
                continue;
            }
            this.add(dest, index, sourceElement);
        }
    }

    private <T> List<T> nullToEmptyList(List<T> list) {
        return list == null ? Collections.emptyList() : list;
    }

    protected void add(List<E> dest, int index, E element) {
        dest.add(index, element);
    }

    protected abstract K getKey(E var1);

    protected abstract void update(List<E> var1, int var2, E var3, E var4);

    protected void populateSourceKey2element() {
        this.sourceKey2elements = new HashMap<K, List<E>>();
        for (E element : this.source) {
            K key = this.getKey(element);
            List<E> elements = this.sourceKey2elements.get(key);
            if (elements == null) {
                elements = new LinkedList();
                this.sourceKey2elements.put(key, elements);
            }
            elements.add(element);
        }
    }

    protected void populateDestKey2element() {
        this.destKey2elements = new HashMap<K, List<E>>();
        for (E element : this.dest) {
            K key = this.getKey(element);
            List<E> elements = this.destKey2elements.get(key);
            if (elements == null) {
                elements = new LinkedList();
                this.destKey2elements.put(key, elements);
            }
            elements.add(element);
        }
    }
}

