/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.core.TimeUnit;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OneArgumentOptionHandler;
import org.kohsuke.args4j.spi.Setter;

public class TimePeriodOptionHandler
extends OneArgumentOptionHandler<Long> {
    public TimePeriodOptionHandler(CmdLineParser parser, OptionDef option, Setter<Long> setter) {
        super(parser, option, setter);
    }

    protected Long parse(String argument) throws NumberFormatException, CmdLineException {
        TimeUnit timeUnit = null;
        for (TimeUnit u : TimeUnit.values()) {
            if (!argument.endsWith(u.name()) || timeUnit != null && timeUnit.name().length() >= u.name().length()) continue;
            timeUnit = u;
        }
        if (timeUnit == null) {
            throw new CmdLineException(this.owner, "Argument '" + argument + "' does not end with one of the following unit-suffixes: " + TimeUnit.getAllUnitsWithDisplayName());
        }
        String numberVal = argument.substring(0, argument.length() - timeUnit.name().length()).trim();
        long valueMSec = Long.parseLong(numberVal);
        return timeUnit.toMillis(valueMSec);
    }
}

