/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.dto;

import co.codewizards.cloudstore.core.dto.jaxb.DateTimeXmlAdapter;
import co.codewizards.cloudstore.core.util.ISO8601;
import co.codewizards.cloudstore.core.util.Util;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlJavaTypeAdapter(type=DateTime.class, value=DateTimeXmlAdapter.class)
public class DateTime {
    private final Date date;

    public DateTime(String dateString) {
        this.date = ISO8601.parseDate(Objects.requireNonNull(dateString, "dateString"));
    }

    public DateTime(Date date) {
        this.date = (Date)Objects.requireNonNull(date, "date").clone();
    }

    public long getMillis() {
        return this.date.getTime();
    }

    public int hashCode() {
        return this.date == null ? 0 : this.date.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateTime other = (DateTime)obj;
        return Util.equal(this.date, other.date);
    }

    public String toString() {
        return ISO8601.formatDate(this.date);
    }

    public Date toDate() {
        return (Date)this.date.clone();
    }
}

