/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.repo.sync;

import co.codewizards.cloudstore.core.dto.CopyModificationDto;
import co.codewizards.cloudstore.core.dto.DeleteModificationDto;
import co.codewizards.cloudstore.core.dto.ModificationDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModificationDtoSet {
    private final Map<String, List<DeleteModificationDto>> path2DeleteModificationDtos;
    private final Map<String, List<CopyModificationDto>> fromPath2CopyModificationDtos;

    public ModificationDtoSet(Collection<ModificationDto> modificationDtos) {
        Objects.requireNonNull(modificationDtos, "modificationDtos");
        this.path2DeleteModificationDtos = new HashMap<String, List<DeleteModificationDto>>();
        this.fromPath2CopyModificationDtos = new HashMap<String, List<CopyModificationDto>>();
        for (ModificationDto modificationDto : modificationDtos) {
            List<ModificationDto> list;
            if (modificationDto instanceof CopyModificationDto) {
                CopyModificationDto copyModificationDto = (CopyModificationDto)modificationDto;
                String fromPath = copyModificationDto.getFromPath();
                list = this.fromPath2CopyModificationDtos.get(fromPath);
                if (list == null) {
                    list = new LinkedList<CopyModificationDto>();
                    this.fromPath2CopyModificationDtos.put(fromPath, list);
                }
                list.add(copyModificationDto);
                continue;
            }
            if (modificationDto instanceof DeleteModificationDto) {
                DeleteModificationDto deleteModificationDto = (DeleteModificationDto)modificationDto;
                String path = deleteModificationDto.getPath();
                list = this.path2DeleteModificationDtos.get(path);
                if (list == null) {
                    list = new LinkedList();
                    this.path2DeleteModificationDtos.put(path, list);
                }
                list.add((CopyModificationDto)((Object)deleteModificationDto));
                continue;
            }
            throw new UnsupportedOperationException("Unknown ModificationDto type: " + modificationDto);
        }
    }

    public Map<String, List<CopyModificationDto>> getFromPath2CopyModificationDtos() {
        return this.fromPath2CopyModificationDtos;
    }

    public Map<String, List<DeleteModificationDto>> getPath2DeleteModificationDtos() {
        return this.path2DeleteModificationDtos;
    }
}

