/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.local.JdbcConnectionFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairDatabase
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RepairDatabase.class);
    private final File localRoot;
    private Connection connection;
    private Statement statement;

    public RepairDatabase(File localRoot) {
        this.localRoot = Objects.requireNonNull(localRoot, "localRoot");
    }

    @Override
    public void run() {
        try {
            JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(this.localRoot);
            this.connection = jdbcConnectionFactory.createConnection();
            try {
                this.statement = this.connection.createStatement();
                try {
                    this.executeDerbyCheckTable();
                    this.dropForeignKeys();
                    this.dropIndices();
                    this.executeDerbyCheckTable();
                }
                finally {
                    this.statement.close();
                }
            }
            finally {
                this.connection.close();
            }
        }
        catch (SQLException x) {
            throw new RuntimeException(x);
        }
    }

    private void executeDerbyCheckTable() throws SQLException {
        this.statement.execute("SELECT schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid");
    }

    private void dropForeignKeys() throws SQLException {
        for (String tableName : this.getTableNames()) {
            for (String foreignKeyName : this.getForeignKeyNames(tableName)) {
                try {
                    this.statement.execute(String.format("ALTER TABLE \"%s\" DROP CONSTRAINT \"%s\"", tableName, foreignKeyName));
                    logger.info("dropForeignKeys: Dropped foreign-key '{}' of table '{}'.", (Object)foreignKeyName, (Object)tableName);
                }
                catch (SQLException x) {
                    logger.warn("dropForeignKeys: Could not drop foreign-key '{}' of table '{}': {}", new Object[]{foreignKeyName, tableName, x.toString()});
                }
            }
        }
    }

    private void dropIndices() throws SQLException {
        for (String tableName : this.getTableNames()) {
            for (String indexName : this.getIndexNames(tableName)) {
                try {
                    this.statement.execute(String.format("DROP INDEX \"%s\"", indexName));
                    logger.info("dropIndices: Dropped index '{}'.", (Object)indexName);
                }
                catch (SQLException x) {
                    logger.warn("dropIndices: Could not drop index '{}': {}", (Object)indexName, (Object)x.toString());
                }
            }
        }
    }

    private Collection<String> getTableNames() throws SQLException {
        ArrayList<String> res = new ArrayList<String>();
        ResultSet rs = this.connection.getMetaData().getTables(null, null, null, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            if ("SEQUENCE".equals(tableType == null ? null : tableType.toUpperCase()) || tableName.toLowerCase().startsWith("sys")) continue;
            res.add(tableName);
        }
        rs.close();
        return res;
    }

    private Collection<String> getForeignKeyNames(String tableName) throws SQLException {
        HashSet<String> tableNameAndForeignKeyNameSet = new HashSet<String>();
        ArrayList<String> res = new ArrayList<String>();
        for (String toTableName : this.getTableNames()) {
            ResultSet rs = this.connection.getMetaData().getCrossReference(null, null, toTableName, null, null, tableName);
            while (rs.next()) {
                String tableNameAndForeignKeyName;
                String foreignKeyName = rs.getString("FK_NAME");
                if (foreignKeyName == null || !tableNameAndForeignKeyNameSet.add(tableNameAndForeignKeyName = tableName + '.' + foreignKeyName)) continue;
                res.add(foreignKeyName);
            }
            rs.close();
        }
        return res;
    }

    private Collection<String> getIndexNames(String tableName) throws SQLException {
        ArrayList<String> res = new ArrayList<String>();
        ResultSet rs = this.connection.getMetaData().getIndexInfo(null, null, tableName, false, true);
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null) continue;
            res.add(indexName);
        }
        rs.close();
        return res;
    }
}

