/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import co.codewizards.cloudstore.client.SubCommandWithExistingLocalRepo;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import java.util.UUID;
import org.kohsuke.args4j.Argument;

public class CreateRepoAliasSubCommand
extends SubCommandWithExistingLocalRepo {
    @Argument(metaVar="<alias>", index=1, required=true, usage="The alias to be created.")
    private String alias;

    @Override
    public String getSubCommandDescription() {
        return "Create an alias for an existing repository.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
        try (LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(this.localRoot);){
            UUID oldRepositoryId = localRepoRegistry.getRepositoryId(this.alias);
            File oldLocalRoot = null;
            if (!(oldRepositoryId == null || (oldLocalRoot = localRepoRegistry.getLocalRoot(oldRepositoryId)) != null && oldLocalRoot.exists())) {
                oldRepositoryId = null;
                oldLocalRoot = null;
            }
            if (oldRepositoryId != null) {
                System.err.println(String.format("ERROR: There is already a repository registered with the alias '%s'! The existing repository's ID is '%s' and its local-root is '%s'.", this.alias, oldRepositoryId, oldLocalRoot));
            } else {
                localRepoManager.putRepositoryAlias(this.alias);
                System.out.println(String.format("Created alias '%s' for repository %s (local-root '%s').", this.alias, localRepoManager.getRepositoryId(), localRepoManager.getLocalRoot()));
            }
        }
    }
}

