/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.ls.core.invoke.refjanitor;

import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.collection.WeakIdentityHashMap;
import co.codewizards.cloudstore.core.ref.IdentityWeakReference;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.ls.core.invoke.MethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.filter.ExtMethodInvocationRequest;
import co.codewizards.cloudstore.ls.core.invoke.refjanitor.AbstractReferenceJanitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyChangeListenerJanitor
extends AbstractReferenceJanitor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyChangeListenerJanitor.class);
    private final WeakIdentityHashMap<Object, Map<Object, List<IdentityWeakReference<PropertyChangeListener>>>> bean2Property2ListenerRefs = new WeakIdentityHashMap();
    private final WeakIdentityHashMap<PropertyChangeListener, WeakReference<FaultTolerantPropertyChangeListener>> originalListener2FaultTolerantPropertyChangeListenerRef = new WeakIdentityHashMap();

    @Override
    public void preInvoke(ExtMethodInvocationRequest extMethodInvocationRequest) {
        MethodInvocationRequest methodInvocationRequest = extMethodInvocationRequest.getMethodInvocationRequest();
        Object bean = methodInvocationRequest.getObject();
        if (bean == null) {
            return;
        }
        String methodName = methodInvocationRequest.getMethodName();
        Object[] arguments = methodInvocationRequest.getArguments();
        Object property = null;
        PropertyChangeListener listener = null;
        if (arguments.length == 1 && arguments[0] instanceof PropertyChangeListener) {
            listener = (PropertyChangeListener)arguments[0];
            arguments[0] = this.getFaultTolerantPropertyChangeListenerOrCreate(listener);
        } else if (arguments.length == 2 && arguments[1] instanceof PropertyChangeListener) {
            listener = (PropertyChangeListener)arguments[1];
            if (arguments[0] instanceof PropertyBase) {
                property = arguments[0];
            } else if (arguments[0] instanceof String) {
                property = arguments[0];
            } else {
                return;
            }
            arguments[1] = this.getFaultTolerantPropertyChangeListenerOrCreate(listener);
        } else {
            return;
        }
        Objects.requireNonNull(listener, "listener");
        if ("addPropertyChangeListener".equals(methodName)) {
            this.trackAddPropertyChangeListener(bean, property, listener);
        } else if ("removePropertyChangeListener".equals(methodName)) {
            this.trackRemovePropertyChangeListener(bean, property, listener);
        }
    }

    private synchronized FaultTolerantPropertyChangeListener getFaultTolerantPropertyChangeListenerOrCreate(PropertyChangeListener listener) {
        FaultTolerantPropertyChangeListener faultTolerantListener;
        Objects.requireNonNull(listener, "listener");
        WeakReference ref = (WeakReference)this.originalListener2FaultTolerantPropertyChangeListenerRef.get((Object)listener);
        FaultTolerantPropertyChangeListener faultTolerantPropertyChangeListener = faultTolerantListener = ref == null ? null : (FaultTolerantPropertyChangeListener)ref.get();
        if (faultTolerantListener == null) {
            faultTolerantListener = new FaultTolerantPropertyChangeListener(listener);
            this.originalListener2FaultTolerantPropertyChangeListenerRef.put((Object)listener, new WeakReference<FaultTolerantPropertyChangeListener>(faultTolerantListener));
        }
        return faultTolerantListener;
    }

    private synchronized FaultTolerantPropertyChangeListener getFaultTolerantPropertyChangeListener(PropertyChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        WeakReference ref = (WeakReference)this.originalListener2FaultTolerantPropertyChangeListenerRef.get((Object)listener);
        FaultTolerantPropertyChangeListener faultTolerantListener = ref == null ? null : (FaultTolerantPropertyChangeListener)ref.get();
        return faultTolerantListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUp() {
        HashMap<Object, Map<Object, List<IdentityWeakReference<PropertyChangeListener>>>> bean2Property2ListenerRefs;
        PropertyChangeListenerJanitor propertyChangeListenerJanitor = this;
        synchronized (propertyChangeListenerJanitor) {
            bean2Property2ListenerRefs = new HashMap<Object, Map<Object, List<IdentityWeakReference<PropertyChangeListener>>>>((Map<Object, Map<Object, List<IdentityWeakReference<PropertyChangeListener>>>>)this.bean2Property2ListenerRefs);
            this.bean2Property2ListenerRefs.clear();
        }
        for (Map.Entry entry : bean2Property2ListenerRefs.entrySet()) {
            Object bean = entry.getKey();
            if (bean == null) {
                throw new IllegalStateException("bean2Property2ListenerRefs.entrySet() contained null-key!");
            }
            for (Map.Entry me2 : ((Map)entry.getValue()).entrySet()) {
                Object property = me2.getKey();
                for (IdentityWeakReference ref : (List)me2.getValue()) {
                    PropertyChangeListener listener = (PropertyChangeListener)ref.get();
                    if (listener == null) continue;
                    this.tryRemovePropertyChangeListener(bean, property, listener);
                }
            }
        }
    }

    private void tryRemovePropertyChangeListener(Object bean, Object property, PropertyChangeListener listener) {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(listener, "listener");
        FaultTolerantPropertyChangeListener faultTolerantPropertyChangeListener = this.getFaultTolerantPropertyChangeListener(listener);
        if (faultTolerantPropertyChangeListener == null) {
            return;
        }
        try {
            if (property != null) {
                ReflectionUtil.invoke((Object)bean, (String)"removePropertyChangeListener", (Object[])new Object[]{property, faultTolerantPropertyChangeListener});
            } else {
                ReflectionUtil.invoke((Object)bean, (String)"removePropertyChangeListener", (Object[])new Object[]{faultTolerantPropertyChangeListener});
            }
        }
        catch (Exception x) {
            logger.error("tryRemovePropertyChangeListener: " + x, (Throwable)x);
        }
    }

    private synchronized void trackAddPropertyChangeListener(Object bean, Object property, PropertyChangeListener listener) {
        LinkedList<IdentityWeakReference> listenerRefs;
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(listener, "listener");
        HashMap property2ListenerRefs = (HashMap)this.bean2Property2ListenerRefs.get(bean);
        if (property2ListenerRefs == null) {
            property2ListenerRefs = new HashMap();
            this.bean2Property2ListenerRefs.put(bean, property2ListenerRefs);
        }
        if ((listenerRefs = (LinkedList<IdentityWeakReference>)property2ListenerRefs.get(property)) == null) {
            listenerRefs = new LinkedList<IdentityWeakReference>();
            property2ListenerRefs.put(property, listenerRefs);
        } else {
            this.expunge((List<IdentityWeakReference<PropertyChangeListener>>)listenerRefs);
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.add(listenerRef);
    }

    private synchronized void trackRemovePropertyChangeListener(Object bean, Object property, PropertyChangeListener listener) {
        Objects.requireNonNull(bean, "bean");
        Objects.requireNonNull(listener, "listener");
        Map property2ListenerRefs = (Map)this.bean2Property2ListenerRefs.get(bean);
        if (property2ListenerRefs == null) {
            return;
        }
        List listenerRefs = (List)property2ListenerRefs.get(property);
        if (listenerRefs == null) {
            return;
        }
        IdentityWeakReference listenerRef = new IdentityWeakReference((Object)listener);
        listenerRefs.remove(listenerRef);
        this.expunge(listenerRefs);
        if (listenerRefs.isEmpty()) {
            property2ListenerRefs.remove(property);
        }
        if (property2ListenerRefs.isEmpty()) {
            this.bean2Property2ListenerRefs.remove(bean);
        }
    }

    private void expunge(List<IdentityWeakReference<PropertyChangeListener>> listenerRefs) {
        Objects.requireNonNull(listenerRefs, "listenerRefs");
        Iterator<IdentityWeakReference<PropertyChangeListener>> it = listenerRefs.iterator();
        while (it.hasNext()) {
            IdentityWeakReference<PropertyChangeListener> ref = it.next();
            if (ref.get() != null) continue;
            it.remove();
        }
    }

    private static class FaultTolerantPropertyChangeListener
    implements PropertyChangeListener {
        private static final Logger logger = LoggerFactory.getLogger(FaultTolerantPropertyChangeListener.class);
        private final PropertyChangeListener delegate;

        public FaultTolerantPropertyChangeListener(PropertyChangeListener delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            try {
                this.delegate.propertyChange(event);
            }
            catch (Exception x) {
                logger.error("propertyChange: " + x, (Throwable)x);
            }
        }

        protected void finalize() throws Throwable {
            logger.debug("finalize: entered.");
            super.finalize();
        }
    }
}

