/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.client;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import co.codewizards.cloudstore.client.AcceptRepoConnectionSubCommand;
import co.codewizards.cloudstore.client.AfterUpdateHookSubCommand;
import co.codewizards.cloudstore.client.ChangeLdapPasswordSubCommand;
import co.codewizards.cloudstore.client.CreateRepoAliasSubCommand;
import co.codewizards.cloudstore.client.CreateRepoSubCommand;
import co.codewizards.cloudstore.client.DropRepoAliasSubCommand;
import co.codewizards.cloudstore.client.DropRepoConnectionSubCommand;
import co.codewizards.cloudstore.client.HelpSubCommand;
import co.codewizards.cloudstore.client.RepairDatabaseSubCommand;
import co.codewizards.cloudstore.client.RepoInfoSubCommand;
import co.codewizards.cloudstore.client.RepoListSubCommand;
import co.codewizards.cloudstore.client.RequestRepoConnectionSubCommand;
import co.codewizards.cloudstore.client.SubCommand;
import co.codewizards.cloudstore.client.SyncSubCommand;
import co.codewizards.cloudstore.client.TimeoutConsoleReader;
import co.codewizards.cloudstore.client.VersionSubCommand;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.transport.RepoTransportFactoryRegistry;
import co.codewizards.cloudstore.core.updater.CloudStoreUpdaterCore;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.MainArgsUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.rest.client.ssl.CheckServerTrustedCertificateExceptionContext;
import co.codewizards.cloudstore.rest.client.ssl.CheckServerTrustedCertificateExceptionResult;
import co.codewizards.cloudstore.rest.client.ssl.DynamicX509TrustManagerCallback;
import co.codewizards.cloudstore.rest.client.transport.RestRepoTransportFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreClient.class);
    public static final List<Class<? extends SubCommand>> subCommandClasses;
    public final List<SubCommand> subCommands;
    public final Map<String, SubCommand> subCommandName2subCommand;
    private static final String CMD_PREFIX = "cloudstore";
    private boolean throwException;
    private final String[] args;

    private static final String[] stripSubCommand(String[] args) {
        String[] result = new String[args.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = args[i + 1];
        }
        return result;
    }

    public static void main(String ... args) throws Exception {
        args = MainArgsUtil.extractAndApplySystemPropertiesReturnOthers((String[])args);
        CloudStoreClient.initLogging();
        try {
            int programExitStatus;
            try {
                RestRepoTransportFactory restRepoTransportFactory = (RestRepoTransportFactory)RepoTransportFactoryRegistry.getInstance().getRepoTransportFactoryOrFail(RestRepoTransportFactory.class);
                restRepoTransportFactory.setDynamicX509TrustManagerCallbackClass(ConsoleDynamicX509TrustManagerCallback.class);
                programExitStatus = new CloudStoreClient(args).throwException(false).execute();
            }
            finally {
                new CloudStoreUpdaterCore().createUpdaterDirIfUpdateNeeded();
            }
            System.exit(programExitStatus);
        }
        catch (Throwable x) {
            logger.error(x.toString(), x);
            System.exit(999);
        }
    }

    public CloudStoreClient(String ... args) {
        try {
            ArrayList<SubCommand> l = new ArrayList<SubCommand>();
            HashMap<String, SubCommand> m = new HashMap<String, SubCommand>();
            for (Class<? extends SubCommand> c : subCommandClasses) {
                SubCommand subCommand = c.newInstance();
                l.add(subCommand);
                m.put(subCommand.getSubCommandName(), subCommand);
            }
            l.trimToSize();
            this.subCommands = Collections.unmodifiableList(l);
            this.subCommandName2subCommand = Collections.unmodifiableMap(m);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.throwException = true;
        this.args = args == null ? new String[]{} : args;
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public CloudStoreClient throwException(boolean throwException) {
        this.setThrowException(throwException);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        Object parser;
        SubCommand subCommand;
        boolean displayHelp;
        int programExitStatus;
        block23: {
            logger.debug("execute: CloudStore CLI version {} is executing.", (Object)VersionSubCommand.getVersion());
            String[] args = MainArgsUtil.extractAndApplySystemPropertiesReturnOthers((String[])this.args);
            programExitStatus = 1;
            displayHelp = true;
            String subCommandName = null;
            subCommand = null;
            if (args.length > 0) {
                subCommandName = args[0];
                if ("help".equals(subCommandName)) {
                    if (args.length > 1 && (subCommand = this.subCommandName2subCommand.get(subCommandName = args[1])) == null) {
                        System.err.println("Unknown sub-command: " + subCommandName);
                        subCommandName = null;
                    }
                } else {
                    subCommand = this.subCommandName2subCommand.get(subCommandName);
                    if (subCommand == null) {
                        System.err.println("Unknown sub-command: " + subCommandName);
                        subCommandName = null;
                    } else {
                        displayHelp = false;
                        parser = new CmdLineParser((Object)subCommand);
                        try {
                            String[] argsWithoutSubCommand = CloudStoreClient.stripSubCommand(args);
                            parser.parseArgument(argsWithoutSubCommand);
                            boolean failed = true;
                            subCommand.prepare();
                            try {
                                subCommand.run();
                                failed = false;
                            }
                            finally {
                                try {
                                    subCommand.cleanUp();
                                }
                                catch (Exception x) {
                                    if (failed) {
                                        logger.error("cleanUp() failed (but suppressing this exception to prevent primary exception from being lost): " + x, (Throwable)x);
                                    }
                                    throw x;
                                }
                            }
                            programExitStatus = 0;
                        }
                        catch (CmdLineException e) {
                            programExitStatus = 2;
                            displayHelp = true;
                            System.err.println("Error: " + e.getMessage());
                            System.err.println();
                            if (this.throwException) {
                                throw e;
                            }
                        }
                        catch (Exception x) {
                            programExitStatus = 3;
                            logger.error(x.toString(), (Throwable)x);
                            if (!this.throwException) break block23;
                            throw x;
                        }
                    }
                }
            }
        }
        if (displayHelp) {
            if (subCommand == null) {
                System.err.println("Syntax: cloudstore <sub-command> <options>");
                System.err.println();
                System.err.println("Get help for a specific sub-command: cloudstore help <sub-command>");
                System.err.println();
                System.err.println("Available sub-commands:");
                for (SubCommand sc : this.subCommands) {
                    if (!sc.isVisibleInHelp()) continue;
                    System.err.println("  " + sc.getSubCommandName());
                }
            } else {
                parser = new CmdLineParser(subCommand);
                System.err.println(subCommand.getSubCommandName() + ": " + subCommand.getSubCommandDescription());
                System.err.println();
                System.err.print("Syntax: cloudstore " + subCommand.getSubCommandName());
                parser.printSingleLineUsage((OutputStream)System.err);
                System.err.println();
                System.err.println();
                System.err.println("Options:");
                parser.printUsage((OutputStream)System.err);
            }
        }
        return programExitStatus;
    }

    private static void initLogging() throws IOException, JoranException {
        File logDir = ConfigDir.getInstance().getLogDir();
        DerbyUtil.setLogFile((File)OioFileFactory.createFile((File)logDir, (String[])new String[]{"derby.log"}));
        String logbackXmlName = "logback.client.xml";
        File logbackXmlFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"logback.client.xml"});
        if (!logbackXmlFile.exists()) {
            AppIdRegistry.getInstance().copyResourceResolvingAppId(CloudStoreClient.class, "logback.client.xml", logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile.getIoFile());
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        DebugUtil.logSystemProperties();
    }

    static {
        List<Class> l = Arrays.asList(AcceptRepoConnectionSubCommand.class, AfterUpdateHookSubCommand.class, CreateRepoSubCommand.class, CreateRepoAliasSubCommand.class, DropRepoAliasSubCommand.class, DropRepoConnectionSubCommand.class, HelpSubCommand.class, RepairDatabaseSubCommand.class, RepoInfoSubCommand.class, RepoListSubCommand.class, RequestRepoConnectionSubCommand.class, ChangeLdapPasswordSubCommand.class, SyncSubCommand.class, VersionSubCommand.class);
        subCommandClasses = Collections.unmodifiableList(l);
    }

    public static class ConsoleDynamicX509TrustManagerCallback
    implements DynamicX509TrustManagerCallback {
        public CheckServerTrustedCertificateExceptionResult handleCheckServerTrustedCertificateException(CheckServerTrustedCertificateExceptionContext context) {
            CheckServerTrustedCertificateExceptionResult result = new CheckServerTrustedCertificateExceptionResult();
            String certificateSha1 = null;
            try {
                certificateSha1 = HashUtil.sha1ForHuman((byte[])context.getCertificateChain()[0].getEncoded());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(66);
            }
            System.out.println("You are connecting to this server for the first time or someone is tampering with your");
            System.out.println("connection to this server!");
            System.out.println();
            System.out.println("The server presented a certificate with the following fingerprint (SHA1):");
            System.out.println();
            System.out.println("\t" + certificateSha1);
            System.out.println();
            System.out.println("Please verify that this is really your server's certificate and not a man in the middle!");
            System.out.println("Your server shows its certificate's fingerprint during startup.");
            System.out.println();
            String trustedString = this.prompt(">>> Do you want to register this certificate and trust this connection? (y/n) ", new Object[0]);
            if ("y".equals(trustedString)) {
                result.setTrusted(true);
            } else if ("n".equals(trustedString)) {
                result.setTrusted(false);
            }
            return result;
        }

        protected String prompt(String question, Object ... args) {
            String result;
            TimeoutConsoleReader consoleInput = new TimeoutConsoleReader(question, 300000L, "n");
            try {
                result = consoleInput.readLine();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("A problem occured, while reading from console!");
            }
            return result;
        }
    }
}

