/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.objectfactory;

import co.codewizards.cloudstore.core.objectfactory.ClassExtension;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;

public class ObjectFactory {
    private final Map<Class<?>, ClassExtension<?>> baseClass2ClassExtension;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static ObjectFactory getInstance() {
        return Holder.instance;
    }

    protected ObjectFactory() {
        HashMap baseClass2ClassExtension = new HashMap();
        for (ClassExtension classExtension : ServiceLoader.load(ClassExtension.class)) {
            ClassExtension old = (ClassExtension)baseClass2ClassExtension.get(classExtension.getBaseClass());
            if (old == null || old.getPriority() < classExtension.getPriority()) {
                baseClass2ClassExtension.put(classExtension.getBaseClass(), classExtension);
                continue;
            }
            if (old.getPriority() != classExtension.getPriority()) continue;
            throw new IllegalStateException("Multiple ClassExtensions registered on the base-class %s with the same priority!");
        }
        this.baseClass2ClassExtension = Collections.unmodifiableMap(baseClass2ClassExtension);
    }

    public <T> Class<? extends T> getExtendingClass(Class<T> clazz) {
        ClassExtension<T> classExtension;
        Class<T> c = clazz;
        while (null != (classExtension = this.getClassExtension(c))) {
            c = classExtension.getExtendingClass();
        }
        return c;
    }

    public <T> ClassExtension<T> getClassExtension(Class<T> clazz) {
        return this.baseClass2ClassExtension.get(clazz);
    }

    public <T> T createObject(Class<T> clazz) {
        return this.createObject(clazz, null, (Object[])null);
    }

    public <T> T createObject(Class<T> clazz, Object ... parameters) {
        return this.createObject(clazz, null, parameters);
    }

    public <T> T createObject(Class<T> clazz, Class<?>[] parameterTypes, Object ... parameters) {
        Constructor<T> constructor;
        Objects.requireNonNull(clazz, "clazz");
        if (parameterTypes != null && parameters != null && parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException(String.format("parameterTypes.length != parameters.length :: %s != %s", parameterTypes.length, parameters.length));
        }
        if (parameterTypes == null && (parameters == null || parameters.length == 0)) {
            parameterTypes = EMPTY_CLASS_ARRAY;
        }
        Class<T> c = this.getExtendingClass(clazz);
        if (parameterTypes == null && parameters != null) {
            constructor = this.getMatchingConstructor(c, parameters);
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] != null) continue;
                throw new IllegalArgumentException(String.format("parameterTypes[%s] == null", i));
            }
            try {
                constructor = c.getDeclaredConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        constructor.setAccessible(true);
        try {
            T instance = constructor.newInstance(parameters);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Constructor<T> getMatchingConstructor(Class<T> clazz, Object[] parameters) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(parameters, "parameters");
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        LinkedList constructorsWithSameNumberOfArguments = new LinkedList();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != parameters.length) continue;
            Constructor<?> con = constructor;
            constructorsWithSameNumberOfArguments.add(con);
        }
        if (constructorsWithSameNumberOfArguments.isEmpty()) {
            throw new RuntimeException(new NoSuchMethodException(String.format("The class %s does not have any constructor with %s arguments.", clazz.getName(), parameters.length)));
        }
        if (constructorsWithSameNumberOfArguments.size() == 1) {
            return (Constructor)constructorsWithSameNumberOfArguments.get(0);
        }
        throw new UnsupportedOperationException(String.format("The class %s has multiple constructors with %s arguments. This is NOT YET SUPPORTED!", clazz.getName(), parameters.length));
    }

    private static final class Holder {
        public static final ObjectFactory instance = new ObjectFactory();

        private Holder() {
        }
    }
}

