/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.oio;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class IoFileRelativePathUtil {
    private static final boolean LIKE_JAVA_NIO_PATH_RELATIVIZE = true;

    private IoFileRelativePathUtil() {
    }

    static String getRelativePath(File from, File to) {
        return IoFileRelativePathUtil.getRelativePath(from, to, File.separatorChar);
    }

    static String getRelativePath(File from, File to, char separatorChar) {
        String fromPath = from.getAbsolutePath();
        String toPath = to.getAbsolutePath();
        boolean isDirectory = from.isDirectory();
        return IoFileRelativePathUtil.getRelativePath(fromPath, toPath, isDirectory, separatorChar);
    }

    static String getRelativePath(String fromPath, String toPath, boolean isFromPathDirectory, char separatorChar) {
        isFromPathDirectory = true;
        ArrayList<String> fromPathSegments = IoFileRelativePathUtil.splitPath(fromPath);
        ArrayList<String> toPathSegments = IoFileRelativePathUtil.splitPath(toPath);
        while (!fromPathSegments.isEmpty() && !toPathSegments.isEmpty() && fromPathSegments.get(0).equals(toPathSegments.get(0))) {
            fromPathSegments.remove(0);
            toPathSegments.remove(0);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fromPathSegments.size() - (isFromPathDirectory ? 0 : 1); ++i) {
            sb.append("..");
            sb.append(separatorChar);
        }
        for (String s : toPathSegments) {
            sb.append(s);
            sb.append(separatorChar);
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static ArrayList<String> splitPath(String path) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, File.separator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(".")) continue;
            if (token.equals("..")) {
                if (pathSegments.isEmpty()) continue;
                pathSegments.remove(pathSegments.size() - 1);
                continue;
            }
            pathSegments.add(token);
        }
        return pathSegments;
    }
}

