/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.client.request;

import co.codewizards.cloudstore.rest.client.request.AbstractRequest;
import java.util.Objects;
import javax.ws.rs.client.WebTarget;

public class GetFileData
extends AbstractRequest<byte[]> {
    private final String repositoryName;
    private final String path;
    private final long offset;
    private final int length;

    public GetFileData(String repositoryName, String path, long offset, int length) {
        this.repositoryName = Objects.requireNonNull(repositoryName, "repositoryName");
        this.path = path;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public byte[] execute() {
        WebTarget webTarget = this.createWebTarget(GetFileData.urlEncode(this.repositoryName), this.encodePath(this.path));
        if (this.offset > 0L) {
            webTarget = webTarget.queryParam("offset", new Object[]{this.offset});
        }
        if (this.length >= 0) {
            webTarget = webTarget.queryParam("length", new Object[]{this.length});
        }
        return (byte[])this.assignCredentials(webTarget.request(new String[]{"application/octet-stream"})).get(byte[].class);
    }

    @Override
    public boolean isResultNullable() {
        return false;
    }
}

